<?php
require_once '../config/db.php';
require_once '../authorize.php';

// جلب الموظفين
$stmt = $conn->query("SELECT id, name FROM users ORDER BY name ASC");
$employees = $stmt->fetchAll(PDO::FETCH_ASSOC);

// ألوان المستخدم (من جلسة المستخدم)
$user = $_SESSION['user'];
$color = $user['color'];
$userThemeColor      = $color['hex_code']      ?? '#f3f4f6';
$userThemeTextColor  = $color['text_color']    ?? '#222';
$userThemeNavColor   = $color['nav_color']     ?? '#19213a';
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>تقييم الموظف</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    body, .main-card, tr:hover, a:hover {
      background-color: <?= $userThemeColor ?> !important;
    }
    nav, .card {
      background-color: <?= $userThemeNavColor ?> !important;
    }
    .text, label, h3, h2, th, td, select, input, textarea, a {
      color: <?= $userThemeTextColor ?> !important;
    }
    .navbar-shadow { box-shadow: 0 4px 8px rgba(30,30,60,0.06);}
  </style>
</head>
<body class="bg-gray-50 min-h-screen">
  <?php include $_SERVER['DOCUMENT_ROOT'] . '/erp_task_system/navbar/navbar.php'; ?>

  <div class="max-w-3xl mx-auto bg-white shadow-md p-6 rounded-lg mt-10 main-card">
    <h2 class="text-2xl font-bold mb-4 text-center text-blue-800">📊 تقييم موظف</h2>

    <!-- النموذج فقط -->
    <form id="evalForm" action="store_evaluation.php" method="POST" class="grid grid-cols-1 md:grid-cols-2 gap-4">
      <div>
        <label class="block mb-1 font-medium">الموظف</label>
        <select name="employee_id" id="employee_id" class="w-full border p-2 rounded" required>
          <option value="">اختر الموظف</option>
          <?php foreach($employees as $emp): ?>
            <option value="<?= $emp['id'] ?>"><?= htmlspecialchars($emp['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>

      <div>
        <label class="block mb-1 font-medium">نوع التقييم</label>
        <select name="evaluation_period" id="evaluation_period" class="w-full border p-2 rounded" required>
          <option value="monthly">شهري</option>
          <option value="semi_annual">نصف سنوي</option>
        </select>
      </div>

      <div>
        <label class="block mb-1 font-medium">تاريخ التقييم</label>
        <input type="date" name="evaluation_date" id="evaluation_date" class="w-full border p-2 rounded" required value="<?= date('Y-m-d') ?>">
      </div>

      <?php
      $fields = [
        'discipline' => 'الانضباط',
        'work_quality' => 'جودة العمل',
        'task_completion' => 'إنجاز المهام',
        'collaboration' => 'التعاون',
        'self_development' => 'التطوير الذاتي',
        'manager_rating' => 'تقييم المدير'
      ];
      foreach ($fields as $key => $label): ?>
        <div>
          <label class="block mb-1 font-medium"><?= $label ?></label>
          <select name="<?= $key ?>" id="<?= $key ?>" class="w-full border p-2 rounded" required>
            <?php for ($i = 5; $i >= 1; $i--): ?>
              <option value="<?= $i ?>"><?= $i ?></option>
            <?php endfor; ?>
          </select>
        </div>
      <?php endforeach; ?>

      <div class="md:col-span-2">
        <label class="block mb-1 font-medium">ملاحظات</label>
        <textarea name="comments" id="comments" class="w-full border p-2 rounded" rows="3"></textarea>
      </div>

      <div class="md:col-span-2 text-center mt-3">
        <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded hover:bg-blue-700">💾 حفظ التقييم</button>
      </div>
    </form>

    <!-- ✅ كل التقييمات السابقة -->
    <div id="allEvaluations" class="bg-gray-50 rounded p-4 mt-8 hidden">
      <h3 class="text-lg font-bold mb-2 text-blue-800">🗂️ جميع التقييمات السابقة</h3>
      <div id="evalsTable"></div>
    </div>
  </div>

  <!-- ✅ جلب التقييمات تلقائياً -->
  <script>
    // اسماء المقيمين (تجيبهم من جافاسكربت - AJAX) مع كل تقييم
    function loadEvaluations(empId) {
      if (!empId) return;
      document.getElementById('employee_id').value = empId;
      fetch('get_employee_evaluations.php?id=' + empId)
        .then(r => r.json())
        .then(data => {
          // لا تعرض ملخص التقييم الأخير أبدًا (تم حذفه)

          // جدول جميع التقييمات السابقة
          var allEvalsDiv = document.getElementById('allEvaluations');
          var evalsTableDiv = document.getElementById('evalsTable');
          if (data && data.success && data.evaluations.length > 0) {
            allEvalsDiv.classList.remove('hidden');
            let html = `
              <div class="overflow-x-auto">
              <table class="w-full text-sm bg-white shadow rounded">
                <thead>
                  <tr>
                    <th class="p-2 border">التاريخ</th>
                    <th class="p-2 border">نوع التقييم</th>
                    <th class="p-2 border">الانضباط</th>
                    <th class="p-2 border">جودة العمل</th>
                    <th class="p-2 border">إنجاز المهام</th>
                    <th class="p-2 border">التعاون</th>
                    <th class="p-2 border">التطوير الذاتي</th>
                    <th class="p-2 border">تقييم المدير</th>
                    <th class="p-2 border">ملاحظات</th>
                    <th class="p-2 border">المقيم</th>
                  </tr>
                </thead>
                <tbody>
            `;
            for (let evalItem of data.evaluations) {
              html += `
                <tr>
                  <td class="p-2 border">${evalItem.evaluation_date}</td>
                  <td class="p-2 border">${evalItem.evaluation_period === 'monthly' ? 'شهري' : 'نصف سنوي'}</td>
                  <td class="p-2 border">${evalItem.discipline}</td>
                  <td class="p-2 border">${evalItem.work_quality}</td>
                  <td class="p-2 border">${evalItem.task_completion}</td>
                  <td class="p-2 border">${evalItem.collaboration}</td>
                  <td class="p-2 border">${evalItem.self_development}</td>
                  <td class="p-2 border">${evalItem.manager_rating}</td>
                  <td class="p-2 border">${evalItem.comments ? evalItem.comments : '—'}</td>
                  <td class="p-2 border">${evalItem.evaluator_name ? evalItem.evaluator_name : (evalItem.created_by_name ? evalItem.created_by_name : '—')}</td>
                </tr>
              `;
            }
            html += `</tbody></table></div>`;
            evalsTableDiv.innerHTML = html;
          } else {
            allEvalsDiv.classList.add('hidden');
            evalsTableDiv.innerHTML = '';
          }
        });
    }

    // يدوي إذا اخترت من القائمة
    document.getElementById('employee_id').addEventListener('change', function() {
      loadEvaluations(this.value);
    });

    // تلقائي إذا فتحت الصفحة وفيها id في الرابط
    window.onload = function() {
      const url = new URL(window.location.href);
      const empId = url.searchParams.get("id");
      if (empId) {
        loadEvaluations(empId);
      }
    };
  </script>
</body>
</html>
