<?php
session_start();
require_once '../config/db.php';
require_once '../authorize.php';

$user = $_SESSION['user'];
$color = $user['color'];
$userThemeColor      = $color['hex_code'];
$userThemeTextColor  = $color['text_color'];
$userThemeNavColor   = $color['nav_color'];
$currentUserColorId  = $user['color_id'];
$allColors = $user['colors'];

// تحديث موقع
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update'])) {
  $id = $_POST['id'];
  $name = $_POST['name'];
  $lat = $_POST['latitude'];
  $lng = $_POST['longitude'];

  $stmt = $conn->prepare("UPDATE locations SET name = ?, latitude = ?, longitude = ? WHERE id = ?");
  $stmt->execute([$name, $lat, $lng, $id]);
  $message = "✅ تم تحديث الموقع بنجاح.";
}

// إضافة موقع جديد
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_location'])) {
  $name = $_POST['new_name'];
  $lat = $_POST['new_latitude'];
  $lng = $_POST['new_longitude'];

  if ($name && $lat && $lng) {
    $stmt = $conn->prepare("INSERT INTO locations (name, latitude, longitude) VALUES (?, ?, ?)");
    $stmt->execute([$name, $lat, $lng]);
    $message = "✅ تم إضافة الموقع الجديد بنجاح.";
  } else {
    $message = "❌ جميع الحقول مطلوبة لإضافة الموقع.";
  }
}

// جلب المواقع
$stmt = $conn->query("SELECT * FROM locations ORDER BY id ASC");
$locations = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>إدارة المواقع</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    body {
      background-color: <?= $userThemeColor ?> !important;
      color: <?= $userThemeTextColor ?> !important;
    }
    nav, .main-card, .card {
      background-color: <?= $userThemeNavColor ?> !important;
    }
    th, td, h1, h2, h3, input, button, select, a {
      color: <?= $userThemeTextColor ?> !important;
    }
    input, button {
      background-color: white !important;
    }
    .btn {
      border-radius: 8px;
      padding: 6px 12px;
      font-size: 14px;
    }
    .btn-save {
      background-color: #2563eb;
      color: white;
    }
    .btn-gps {
      background-color: #9333ea;
      color: white;
    }
    .btn:hover {
      opacity: 0.9;
    }
  </style>
</head>
<body class="text-sm text-right leading-relaxed">

<?php include $_SERVER['DOCUMENT_ROOT'] . '/erp_task_system/navbar/navbar.php'; ?>
<div class="h-20"></div>

<div class="max-w-6xl mx-auto mb-6">

<!-- زر إضافة موقع + النموذج -->
<div class="mb-6">
  <button onclick="document.getElementById('addLocationForm').classList.toggle('hidden')"
          class="bg-green-600 text-white px-4 py-2 rounded hover:bg-green-700">
    ➕ إضافة موقع جديد
  </button>
  <div id="addLocationForm" class="hidden mt-4 p-4 rounded shadow text-right main-card">
    <form method="post" onsubmit="return fillNewLocation(this);">
      <div class="grid grid-cols-1 md:grid-cols-3 gap-4 items-center">
        <input type="text" name="new_name" placeholder="🗺️ اسم الموقع" required class="p-2 border rounded">
        <input type="text" name="new_latitude" id="new-lat" placeholder="📍 خط العرض" required class="p-2 border rounded">
        <input type="text" name="new_longitude" id="new-lng" placeholder="📍 خط الطول" required class="p-2 border rounded">
      </div>
      <div class="flex gap-2 mt-4">
        <button type="button" onclick="getNewLocation()" class="btn btn-gps">📡 تحديد موقعي</button>
        <button type="submit" name="add_location" class="btn btn-save">💾 حفظ الموقع</button>
      </div>
    </form>
  </div>
</div>
</div>

<div class="max-w-6xl mx-auto bg-white p-6 rounded shadow main-card">
  <h1 class="text-xl font-bold mb-4 text-center">📍 إدارة المواقع الجغرافية</h1>

  <?php if (isset($message)): ?>
    <?php
      $isSuccess = str_starts_with($message, '✅');
      $bg = $isSuccess ? 'bg-green-100 border-green-400 text-green-700' : 'bg-red-100 border-red-400 text-red-700';
      $icon = $isSuccess ? '✅' : '❌';
    ?>
    <div class="border <?= $bg ?> px-4 py-3 rounded relative mb-4 text-sm">
      <span class="absolute right-4 top-2 text-xl"><?= $icon ?></span>
      <span class="block pr-8"><?= $message ?></span>
    </div>
  <?php endif; ?>

  <table class="w-full border border-gray-300 text-center rounded overflow-hidden text-sm">
    <thead class="bg-gray-200">
      <tr>
        <th class="border p-2">#</th>
        <th class="border p-2">اسم الموقع</th>
        <th class="border p-2">Latitude</th>
        <th class="border p-2">Longitude</th>
        <th class="border p-2">📡 GPS</th>
        <th class="border p-2">💾 تحديث</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($locations as $loc): ?>
        <tr class="border-t">
          <form method="post">
            <td class="border p-2"><?= $loc['id'] ?></td>
            <td class="border p-2">
              <input type="text" name="name" value="<?= htmlspecialchars($loc['name']) ?>" class="border p-1 rounded w-full">
            </td>
            <td class="border p-2">
              <input type="text" name="latitude" id="lat-<?= $loc['id'] ?>" value="<?= $loc['latitude'] ?>" class="border p-1 rounded w-full">
            </td>
            <td class="border p-2">
              <input type="text" name="longitude" id="lng-<?= $loc['id'] ?>" value="<?= $loc['longitude'] ?>" class="border p-1 rounded w-full">
            </td>
            <td class="border p-2">
              <button type="button" onclick="setCurrentLocation(<?= $loc['id'] ?>)" class="btn btn-gps">📍 موقعي</button>
            </td>
            <td class="border p-2">
              <input type="hidden" name="id" value="<?= $loc['id'] ?>">
              <button type="submit" name="update" class="btn btn-save">💾 حفظ</button>
            </td>
          </form>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>

<script>
  function setCurrentLocation(id) {
    if (navigator.geolocation) {
      navigator.geolocation.getCurrentPosition(function(position) {
        document.getElementById('lat-' + id).value = position.coords.latitude;
        document.getElementById('lng-' + id).value = position.coords.longitude;
      }, function() {
        alert("❌ لم نتمكن من تحديد موقعك.");
      });
    } else {
      alert("❌ المتصفح لا يدعم GPS.");
    }
  }

  function getNewLocation() {
    if (navigator.geolocation) {
      navigator.geolocation.getCurrentPosition(function(position) {
        document.getElementById('new-lat').value = position.coords.latitude;
        document.getElementById('new-lng').value = position.coords.longitude;
      }, function() {
        alert("❌ لم يتم تحديد الموقع.");
      });
    } else {
      alert("❌ المتصفح لا يدعم GPS.");
    }
  }

  function fillNewLocation(form) {
    const lat = document.getElementById('new-lat').value;
    const lng = document.getElementById('new-lng').value;
    if (!lat || !lng) {
      alert("❌ الرجاء تحديد الموقع أو تعبئة الإحداثيات يدوياً.");
      return false;
    }
    return true;
  }
</script>

</body>
</html>
