<?php
session_start();
require_once '../config/db.php';

if (!isset($_SESSION['user'])) { header("Location: login.php"); exit; }

$user  = $_SESSION['user'];
$user_id = intval($user['id']);
$today = date('Y-m-d');

$stmt = $conn->prepare("SELECT * FROM attendance WHERE user_id = ? AND `date` = ?");
$stmt->execute([$user_id, $today]);
$attendance = $stmt->fetch(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8" />
  <title>تسجيل الحضور والانصراف</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 p-6">
  <div class="max-w-md mx-auto bg-white p-6 rounded shadow text-center">
    <h1 class="text-xl font-bold mb-4">تسجيل الحضور والانصراف</h1>

    <div id="gpsStatus" class="text-sm text-gray-600 mb-3">جاري طلب إذن الموقع…</div>

    <?php if (!$attendance): ?>
      <form method="post" action="mark_attendance.php" onsubmit="return ensureGPS()">
        <input type="hidden" name="lat" id="lat">
        <input type="hidden" name="lng" id="lng">
        <button name="type" value="check_in" class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded w-full">
          📥 تسجيل حضور
        </button>
      </form>
    <?php elseif ($attendance && empty($attendance['check_out'])): ?>
      <form method="post" action="mark_attendance.php" onsubmit="return ensureGPS()">
        <input type="hidden" name="lat" id="lat">
        <input type="hidden" name="lng" id="lng">
        <button name="type" value="check_out" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded w-full">
          📤 تسجيل انصراف
        </button>
      </form>
    <?php else: ?>
      <p class="text-gray-700">✅ تم تسجيل حضورك وانصرافك اليوم.</p>
    <?php endif; ?>
  </div>

<script>
let gotGPS = false;
function setStatus(msg, ok=false) {
  const el = document.getElementById('gpsStatus');
  el.textContent = msg;
  el.className = 'text-sm mb-3 ' + (ok ? 'text-green-700' : 'text-gray-600');
}

function ensureGPS(){
  if(!gotGPS){
    alert('نحتاج تفعيل الموقع لتسجيل الحضور/الانصراف');
    return false;
  }
  return true;
}

if ('geolocation' in navigator) {
  navigator.geolocation.getCurrentPosition(
    pos => {
      document.getElementById('lat').value = pos.coords.latitude.toFixed(8);
      document.getElementById('lng').value = pos.coords.longitude.toFixed(8);
      gotGPS = true;
      setStatus('تم جلب الموقع بنجاح ✅', true);
    },
    err => {
      setStatus('تعذر جلب الموقع. اسمح للمتصفح بالوصول للموقع ثم أعد المحاولة.', false);
      console.warn(err);
    },
    { enableHighAccuracy:true, timeout:10000, maximumAge:0 }
  );
} else {
  setStatus('هذا المتصفح لا يدعم GPS', false);
}
</script>
</body>
</html>
