<?php
session_start();
require_once '../config/db.php';

if (!isset($_SESSION['user'])) { header("Location: login.php"); exit; }

$user_id   = intval($_SESSION['user']['id']);
$first_day = date('Y-m-01');
$last_day  = date('Y-m-t');

$sql = "SELECT a.`date`, a.check_in, a.check_out, a.status, a.method, a.note,
               l.name AS location_name
        FROM attendance a
        LEFT JOIN locations l ON l.id = a.location_id
        WHERE a.user_id = ? AND a.`date` BETWEEN ? AND ?
        ORDER BY a.`date` ASC";
$stmt = $conn->prepare($sql);
$stmt->execute([$user_id, $first_day, $last_day]);
$records = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>سجل الحضور الشهري</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 p-8">
  <div class="max-w-4xl mx-auto bg-white rounded shadow p-6">
    <h2 class="text-2xl font-bold mb-4 text-center">📅 سجل الحضور لشهر <?= date('F Y') ?></h2>

    <table class="w-full border border-gray-300 text-center text-sm">
      <thead class="bg-gray-200">
        <tr>
          <th class="py-2 border">📆 التاريخ</th>
          <th class="py-2 border">🏢 الموقع</th>
          <th class="py-2 border">🕐 الحضور</th>
          <th class="py-2 border">🕔 الانصراف</th>
          <th class="py-2 border">📌 الحالة</th>
          <th class="py-2 border">⚙️ الطريقة</th>
        </tr>
      </thead>
      <tbody>
        <?php if (!$records): ?>
          <tr><td colspan="6" class="py-4 text-gray-500">لا يوجد حضور لهذا الشهر.</td></tr>
        <?php else: foreach ($records as $r): ?>
          <tr class="border-t">
            <td class="py-2 border"><?= htmlspecialchars($r['date']) ?></td>
            <td class="py-2 border"><?= htmlspecialchars($r['location_name'] ?? '—') ?></td>
            <td class="py-2 border"><?= $r['check_in']  ? htmlspecialchars($r['check_in'])  : '—' ?></td>
            <td class="py-2 border"><?= $r['check_out'] ? htmlspecialchars($r['check_out']) : '—' ?></td>
            <td class="py-2 border"><?= htmlspecialchars($r['status'] ?? '—') ?></td>
            <td class="py-2 border"><?= htmlspecialchars($r['method'] ?? '—') ?></td>
          </tr>
        <?php endforeach; endif; ?>
      </tbody>
    </table>
  </div>
</body>
</html>
