<?php
$employee_number = $_GET['id'] ?? null;
$folder_path = "../users/employee_files/" . $employee_number;
$html = '';
if (!$employee_number || !is_dir($folder_path)) {
    $html = '<div class="text-gray-400 text-center">لا توجد ملفات لهذا الموظف.</div>';
} else {
    $files = array_diff(scandir($folder_path), ['.', '..']);
    if (empty($files)) {
        $html = '<div class="text-gray-400 text-center">لا توجد ملفات لهذا الموظف.</div>';
    } else {
        // هنا نخليهم بشكل أفقي
        $html .= '<div class="flex gap-4 overflow-x-auto p-2">';
        foreach ($files as $file) {
            $url = '/users/employee_files/' . urlencode($employee_number) . '/' . urlencode($file);
            $html .= '<div class="min-w-[150px] bg-gray-100 p-3 rounded shadow flex flex-col items-center justify-between">';
            $html .= '<span class="truncate w-full block text-center text-xs mb-2">' . htmlspecialchars($file) . '</span>';
            $html .= '<a href="' . $url . '" target="_blank" class="text-blue-600 underline">🔽 تحميل</a>';
            $html .= '</div>';
        }
        $html .= '</div>';
    }
}
echo $html;
?>
