<?php
require_once '../config/db.php';
require_once '../authorize.php';

// تأكد من وصول رقم الموظف
$employee_number = $_GET['id'] ?? null;

if (!$employee_number) {
    echo '<div class="text-red-500 text-center">لم يتم تحديد الموظف.</div>';
    exit;
}

// إذا تستخدم id داخلي للموظف غيّر الاستعلام حسبه
$stmt = $conn->prepare("
    SELECT t.*, u.name AS employee_name
    FROM employee_trainings t
    JOIN users u ON t.employee_id = u.id
    WHERE u.employee_number = ? OR u.id = ?
    ORDER BY t.course_date DESC
");
$stmt->execute([$employee_number, $employee_number]);
$trainings = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (!$trainings) {
    echo '<div class="text-gray-400 text-center">لا توجد دورات لهذا الموظف.</div>';
    exit;
}
?>

<table class="w-full text-sm border">
    <thead class="bg-gray-100">
        <tr>
            <th class="p-2">اسم الدورة</th>
            <th>الجهة</th>
            <th>التاريخ</th>
            <th>الساعات</th>
            <th>ملاحظات</th>
            <th>الشهادة</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($trainings as $t): ?>
        <tr class="border-b hover:bg-gray-50">
            <td class="p-2"><?= htmlspecialchars($t['course_name']) ?></td>
            <td><?= htmlspecialchars($t['provider']) ?></td>
            <td><?= htmlspecialchars($t['course_date']) ?></td>
            <td><?= (int)$t['hours'] ?> ساعة</td>
            <td><?= nl2br(htmlspecialchars($t['employee_feedback'])) ?></td>
            <td>
                <?php if (!empty($t['certificate_path'])): ?>
                    <a href="../<?= htmlspecialchars($t['certificate_path']) ?>" target="_blank" class="text-blue-600 underline">عرض</a>
                <?php else: ?>
                    <span class="text-gray-400">—</span>
                <?php endif; ?>
            </td>
        </tr>
        <?php endforeach; ?>
    </tbody>
</table>
