<?php
require_once '../config/db.php';
require_once '../authorize.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// أول شي نتأكد فيه جلسة تسجيل دخول

if (!isset($_SESSION['user']) || !isset($_SESSION['user']['name']) || !isset($_SESSION['user']['email']) || !isset($_SESSION['user']['role']) || !in_array($_SESSION['user']['role'], ['admin', 'manager', 'user'])) {
  session_unset();
  session_destroy();
  header('Location: ../unauthorized.php');
  exit;
}

$user = $_SESSION['user'];
$role = $user['role'];
$locations = $conn->query("SELECT id, name FROM locations ORDER BY name ASC")->fetchAll(PDO::FETCH_ASSOC);
$locationsMap = array_column($locations, 'name', 'id');
$department_id = $user['department_id'];
$user_id = $user['id'];
$user_secret_level = $user['secret_level'];
$color = $user['color'];
$userThemeColor = $color['hex_code'];
$userThemeSecondTextColor = $color['second_text_color'];
$userThemeTextColor = $color['text_color'];
$userThemeNavColor = $color['nav_color'];
$allColors = $user['colors'];
$chartColor = $color['chart_color'];
$currentUserColorId = $user['color_id'];


if ($role === 'admin') {
  // عرض كل المستخدمين للإدمن
  $stmt = $conn->prepare("
    SELECT users.*, departments.name AS department_name 
    FROM users 
    LEFT JOIN departments ON users.department_id = departments.id
    ORDER BY users.id DESC
  ");
  $stmt->execute();
  $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
} else {
  // جلب الإدارات المرتبطة (الرئيسية + الفرعية)
  $stmt_deps = $conn->prepare("SELECT id FROM departments WHERE id = ? OR parent_id = ?");
  $stmt_deps->execute([$department_id, $department_id]);
  $allowed_dept_ids = $stmt_deps->fetchAll(PDO::FETCH_COLUMN);

  // بناء placeholders بعدد الإدارات
  $placeholders = implode(',', array_fill(0, count($allowed_dept_ids), '?'));

  $stmt = $conn->prepare("
    SELECT users.*, departments.name AS department_name 
    FROM users 
    LEFT JOIN departments ON users.department_id = departments.id
    WHERE users.department_id IN ($placeholders)
    ORDER BY users.id DESC
  ");
  $stmt->execute($allowed_dept_ids);
  $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
}


// توزيع الموظفين حسب المواقع
$grouped_by_location = [];
$location_counts = [];

foreach ($users as $u) {
  $loc_id = $u['location_id'] ?? 0;
  if ($loc_id) {
    $grouped_by_location[$loc_id][] = $u;
    $location_counts[$loc_id] = ($location_counts[$loc_id] ?? 0) + 1;
  }
}
// جلب الإدارات
$departments_all = $conn->query("SELECT id, name, parent_id FROM departments ORDER BY name ASC")->fetchAll(PDO::FETCH_ASSOC);
$departmentNamesMap = array_column($departments_all, 'name', 'id');

// توزيع الموظفين حسب الإدارات
$grouped_by_department = [];
$department_counts = [];

foreach ($users as $u) {
  $dep_id = $u['department_id'] ?? 0;
  if ($dep_id) {
    $grouped_by_department[$dep_id][] = $u;
    $department_counts[$dep_id] = ($department_counts[$dep_id] ?? 0) + 1;
  }
}

// جلب المدراء المختصين (مدراء العهدة مثلاً)
$managers_stmt = $conn->prepare("
  SELECT u.id, u.name, d.name AS department_name
  FROM users u
  LEFT JOIN departments d ON u.department_id = d.id
  WHERE u.role = 'manager'
  ORDER BY u.name ASC
");
$managers_stmt->execute();
$managers = $managers_stmt->fetchAll(PDO::FETCH_ASSOC);


$pending_stmt = $conn->prepare("
  SELECT lr.*, u.name AS employee_name, d.name AS department_name
  FROM leave_requests lr
  JOIN users u ON lr.user_id = u.id
  LEFT JOIN departments d ON u.department_id = d.id
  WHERE lr.status LIKE 'بانتظار%'
  ORDER BY lr.created_at DESC
");
$pending_stmt->execute();
$pending_leaves = $pending_stmt->fetchAll(PDO::FETCH_ASSOC);

$today = date('Y-m-d');

$on_leave_stmt = $conn->prepare("
  SELECT lr.*, u.name AS employee_name, d.name AS department_name
  FROM leave_requests lr
  JOIN users u ON lr.user_id = u.id
  LEFT JOIN departments d ON u.department_id = d.id
  WHERE lr.start_date <= :today
    AND lr.end_date   >= :today
    AND lr.status IN ('مقبولة','في إجازة')
  ORDER BY lr.start_date ASC
");
$on_leave_stmt->execute(['today' => $today]);
$on_leave = $on_leave_stmt->fetchAll(PDO::FETCH_ASSOC);
$conn->prepare("
  UPDATE leave_requests
  SET status = 'منتهية'
  WHERE status IN ('مقبولة','في إجازة')
    AND end_date < CURDATE()
")->execute();

// جلب طلبات العهدة بانتظار الموارد البشرية
$pending_assets_stmt = $conn->prepare("
  SELECT ar.*, u.name AS employee_name, d.name AS department_name
  FROM asset_requests ar
  JOIN users u ON ar.user_id = u.id
  LEFT JOIN departments d ON u.department_id = d.id
  WHERE ar.status = 'بانتظار الموارد البشرية'
  ORDER BY ar.created_at DESC
");
$pending_assets_stmt->execute();
$pending_assets = $pending_assets_stmt->fetchAll(PDO::FETCH_ASSOC);


?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
  <meta charset="UTF-8">
  <title>إدارة المستخدمين</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <!-- Include Select2 CSS -->
  <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

  <!-- Include jQuery (required by Select2) -->
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

  <!-- Include Select2 JS -->
  <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

  <style>
    /* Custom styles to make the Select2 dropdown larger */
    .select2-container .select2-selection--single {
      height: 48px;
      /* Increase height of the select box */
      line-height: 48px;
      /* Align text vertically */
      font-size: 13px;
      /* Larger font size for selected item */
    }

    .select2-container--default .select2-selection--single {
      background-color: <?php echo $userThemeNavColor; ?> !important;
      border: none;
    }

    .select2-container--default .select2-selection--single .select2-selection__rendered {
      line-height: 48px;
      color: <?php echo $userThemeTextColor; ?> !important;
      /* Ensure text aligns with height */
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow {
      height: 48px;
      /* Adjust arrow height to match */
    }

    .select2-dropdown {
      font-size: 12px;
      /* Larger font size for dropdown options */
    }

    .select2-results__option {
      padding: 12px;
      /* More padding for larger options */
      line-height: 24px;
      /* Adjust line height for larger square and text */
    }

    /* Optional: Ensure the select takes full width or a specific width */
    .select2-container {
      width: 100% !important;
      /* Full width, or set a specific width like 300px */
    }

    body,
    .main-card,
    tr:hover,
    a:hover {
      background-color: <?php echo $userThemeColor; ?> !important;
    }

    nav,
    .select2-results__option,
    .select2-search,
    .select2-selection--multiple,
    li,
    .card {
      background-color: <?php echo $userThemeNavColor; ?> !important;
    }

    .text,
    label,
    h3,
    option,
    h2,
    th,
    td,
    li,
    select,
    input,
    a {
      color: <?php echo $userThemeTextColor; ?> !important;
    }

    option {
      text-align: center;
    }


    .text-button {
      color: #ffffff !important;
    }

    .move-button {
      background-color: #4d70f4;
      border-radius: 15px !important;
    }

    .card-blue-list {
      background-color: #4d70f4;
      color:rgb(255, 255, 255) !important;
    }

    .card-green-list {
      background-color: #8BFB75 !important;
      color: #0e162a !important;
    }

    .move-button:hover,
    .view-tasks:hover {
      background-color: rgb(19, 11, 57) !important;
    }

    .view-button {
      background-color: #4d70f4;
      color: #FFFFFF !important;
      width: 70px !important;
      border-radius: 15px !important;
      display: inline-block;
      text-align: center;
      padding: 5px 5px;
      text-decoration: none;
      box-sizing: border-box;

    }


    .edit-button:hover,
    .view-button:hover,
    .download-button:hover,
    .delete-button:hover {
      color: <?= isset($currentUserColorId) && $currentUserColorId == 3 ? '#FFFFFF' : '#000000'; ?> !important;
    }

    .edit-button {
      background-color: #8BFB75 !important;
      color: #0e162a !important;

      width: 70px !important;
      border-radius: 15px !important;
      display: inline-block;
      text-align: center;
      padding: 5px 5px;
      text-decoration: none;
      box-sizing: border-box;

    }

    .delete-button {
      background-color: #FD7474 !important;
      color: #FFFFFF !important;

      width: 70px !important;
      border-radius: 15px !important;
      display: inline-block;
      text-align: center;
      padding: 5px 5px;
      text-decoration: none;
      box-sizing: border-box;

    }
  </style>
</head>

<body class=" text-right">

  <?php include $_SERVER['DOCUMENT_ROOT'] . '/erp_task_system/navbar/navbar.php'; ?>


  <script>


    $(document).ready(function() {
      $('#theme_color_select').select2({
        templateResult: formatColorOption,
        templateSelection: formatColorOption
      });

      // Function to format the dropdown option and selected item
      function formatColorOption(option) {
        if (!option.id) {
          return option.text; // Placeholder or "No colors available"
        }
        // Get the hex code from the data-hex attribute
        var hexCode = $(option.element).data('hex');
        // Create a colored square and append the color name
        var $option = $(
          '<span><span style="display: inline-block; width: 20px; height: 20px; background-color: ' + hexCode + '; margin-right: 12px; vertical-align: middle; border: 1px solid #ccc;"></span>' + option.text + '</span>'
        );
        return $option;
      }

      // Ensure form submission still works
      $('#theme_color_select').on('select2:select', function(e) {
        $(this).closest('form').submit();
      });
    });
  </script>

  <!-- تعويض ارتفاع الناف بار -->
  <div class="h-20"></div>
  <?php if (isset($_SESSION['error'])): ?>
    <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4">
      <?= $_SESSION['error'];
      unset($_SESSION['error']); ?>
    </div>
  <?php endif; ?>

  <?php if (isset($_SESSION['success'])): ?>
    <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4">
      <?= $_SESSION['success'];
      unset($_SESSION['success']); ?>
    </div>
  <?php endif; ?>

  <!-- ✅ عرض تفاصيل الموظف -->
  <div id="employeeDetails" class="card hidden mb-6 p-4 bg-white rounded shadow max-w-5xl mx-auto">
    <div class="flex justify-between items-center mb-4">
      <h2 class="text text-lg font-bold">📄 تفاصيل الموظف</h2>
      <button onclick="hideEmployeeDetails()" class="text-red-600 hover:underline text-sm">❌ إغلاق</button>
    </div>

    <div class="flex gap-6 items-center">
      <img id="empImage" src="" class="w-32 h-32 object-cover rounded-full border">
      <div class="grid grid-cols-2 gap-4 flex-1 text-sm">
        <div class="text"><strong>الاسم:</strong> <span id="empName"></span></div>
        <div class="text"><strong>الرقم الوظيفي:</strong> <span id="empNumber"></span></div>
        <div class="text"><strong>البريد:</strong> <span id="empEmail"></span></div>
        <div class="text"><strong>المسمى الوظيفي:</strong> <span id="empJob"></span></div>
        <div class="text"><strong>الإدارة:</strong> <span id="empDept"></span></div>
        <div class="text"><strong>الموقع:</strong> <span id="empLocation"></span></div>
        <div class="text"><strong>الحالة:</strong> <span id="empStatus"></span></div>
      </div>
    </div>

    <div class="mt-4 flex flex-wrap gap-2 text-left">
  <a id="empEditBtn" href="#" class="move-button text-button px-4 py-2 rounded text-sm">✏️ تعديل</a>
<a id="empFilesBtn" href="#" onclick="openEmployeeFilesModal(currentEmployeeNumber); return false;" class="bg-gray-700 text-white px-4 py-2 rounded hover:bg-gray-800 text-sm">📂 ملفات الموظف</a>


  <a id="empEvalBtn" href="#" target="_blank" class="bg-yellow-500 text-white px-4 py-2 rounded hover:bg-yellow-600 text-sm">⭐ تقييم الموظف</a>
<a id="empTrainingBtn" href="#" onclick="openTrainingsModal(currentEmployeeNumber); return false;" class="bg-green-500 text-white px-4 py-2 rounded hover:bg-green-600 text-sm">🎓 تدريبات الموظف</a>

<a id="empLateBtn"
   href="#"
   onclick="openLateModal(currentEmployeeId, document.getElementById('empName').textContent); return false;"
   class="bg-red-600 text-white px-4 py-2 rounded hover:bg-red-700 text-sm">
  ⏱️ التأخير/الغياب
</a>
</div>


  </div>

  <div class="max-w-5xl mx-auto">
<div class="flex justify-between items-center mb-6 flex-wrap gap-2">
  <h1 class="text text-xl font-bold">👥 قائمة المستخدمين</h1>
<div class="flex gap-2">
  <a href="add.php" class="move-button text-button text-white px-4 py-2 rounded">➕ إضافة مستخدم</a>

  <a href="/erp_task_system/users/asset_requests_list.php"
     class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold px-4 py-2 rounded shadow">
    📦 إدارة العهد
  </a>

  <a href="/erp_task_system/users/social_insurance/index.php"
     class="bg-emerald-600 hover:bg-emerald-700 text-white font-bold px-4 py-2 rounded shadow">
    🧾 التأمينات الاجتماعية
  </a>

  <a href="/erp_task_system/users/salaries/index.php"
     class="bg-pink-600 hover:bg-pink-700 text-white font-bold px-4 py-2 rounded shadow">
    💰 إدارة الرواتب
  </a>
</div>
</div>

    <table class="card w-full text-sm border">
      <thead class="">
        <tr>
          <th class="p-2 border">الاسم</th>
          <th class="p-2 border">البريد</th>
          <th class="p-2 border">الدور</th>
          <th class="p-2 border">درجة السرية</th>
          <th class="p-2 border">الإدارة</th>
          <th class="p-2 border">تحويل المهام</th>
          <th class="p-2 border">التوقيع</th>
          <th class="p-2 border">عرض التوقيع</th>

          <th class="p-2 border">الإجراءات</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($users as $user): ?>
          <tr class="cursor-pointer"
            onclick='showEmployeeDetails(<?= json_encode([
                                            'id' => $user['id'],
                                            'name' => $user['name'],
                                            'employee_number' => $user['employee_number'],
                                            'email' => $user['email'],
                                            'job_title' => $user['job_title'],
                                            'department_name' => $user['department_name'],
                                            'location_name' => isset($locationsMap[$user['location_id']]) ? $locationsMap[$user['location_id']] : '',
                                            'employment_status' => $user['employment_status'],
                                            'profile_image' => $user['profile_image'] ?? '',
                                          ]) ?>)'>
            <td class="p-2 border"><?= htmlspecialchars($user['name']) ?></td>
            <td class="p-2 border"><?= htmlspecialchars($user['email']) ?></td>
            <td class="p-2 border"><?= $user['role'] ?></td>
            <td class="p-2 border"><?= $user['secret_level'] ?? '—' ?></td>
            <td class="p-2 border"><?= $user['department_name'] ?? '—' ?></td>
            <td class="p-2 border text-center">
              <?= $user['can_transfer_tasks'] ? '✅' : '—' ?>
            </td>
            <td class="p-2 border text-center">
              <?= $user['can_sign'] ? '✅' : '—' ?>
            </td>
            <td class="p-2 border text-center">
              <?php if (!empty($user['signature_path'])): ?>
                <a href="<?= $user['signature_path'] ?>" target="_blank" class="text-blue-600 view-button">عرض</a>
              <?php else: ?>
                —
              <?php endif; ?>
            </td>

            <td class="p-2 border">
  <div class="flex items-center gap-2">
    <a href="edit.php?id=<?= $user['id'] ?>" class="edit-button">تعديل</a>
    <span class="text-gray-400 text-lg">|</span>
    <a href="delete.php?id=<?= $user['id'] ?>" onclick="return confirm('هل أنت متأكد؟')" class="delete-button">حذف</a>
  </div>
</td>

          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>



  <?php if (count($pending_leaves) > 0): ?>
    <div class="max-w-4xl mx-auto mt-10">
      <h2 class="text text-lg font-bold mb-4 text-red-600">📌 طلبات إجازة بانتظار الموافقة</h2>
      <table class=" card w-full  text-sm border rounded shadow">
        <thead class="">
          <tr>
            <th class="p-2 border">الموظف</th>
            <th class="p-2 border">الإدارة</th>
            <th class="p-2 border">النوع</th>
            <th class="p-2 border">من</th>
            <th class="p-2 border">إلى</th>
            <th class="p-2 border">الحالة</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($pending_leaves as $leave): ?>
            <tr>
              <td class="p-2 border"><?= htmlspecialchars($leave['employee_name']) ?></td>
              <td class="p-2 border"><?= htmlspecialchars($leave['department_name']) ?></td>
              <td class="p-2 border"><?= htmlspecialchars($leave['type']) ?></td>
              <td class="p-2 border"><?= $leave['start_date'] ?></td>
              <td class="p-2 border"><?= $leave['end_date'] ?></td>
              <td class="p-2 border text-orange-600 font-semibold">
                <?= $leave['status'] ?>

                <?php
                $isManager = ($role === 'manager' && $leave['department_name'] === $user['department_name']);
                $isHR = ($role === 'manager' && $user['department_name'] === 'إدارة الموارد البشرية');
                $isAdmin = ($role === 'admin');

                $canManagerApprove = $isManager && is_null($leave['manager_status']);
                $canHRApprove = $isHR && is_null($leave['hr_status']);
                ?>

                <?php if ($canManagerApprove || $canHRApprove || $isAdmin): ?>
                  <form method="POST" action="update_leave_status.php" class="mt-2 space-y-1">
                    <input type="hidden" name="id" value="<?= $leave['id'] ?>">
                    <textarea name="note" class="w-full text-xs border rounded px-2 py-1" placeholder="ملاحظة ..."></textarea>
                    <input type="hidden" name="actor" value="<?= $canHRApprove ? 'hr' : ($canManagerApprove ? 'manager' : 'admin') ?>">
                    <div class="flex gap-1 mt-1">
                      <button name="action" value="accept" class="bg-green-600 text-white text-xs px-2 py-1 rounded">موافقة</button>
                      <button name="action" value="reject" class="bg-red-600 text-white text-xs px-2 py-1 rounded">رفض</button>
                    </div>
                  </form>
                <?php endif; ?>
              </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  <?php endif; ?>

  <?php if (count($on_leave) > 0): ?>
    <div class="max-w-4xl mx-auto mt-10">
      <h2 class="text-lg font-bold mb-4 text-green-700">🌴 الموظفون في إجازة حالياً</h2>
      <table class="w-full card text-sm border rounded shadow">
        <thead class="">
          <tr>
            <th class="p-2 border">الموظف</th>
            <th class="p-2 border">الإدارة</th>
            <th class="p-2 border">نوع الإجازة</th>
            <th class="p-2 border">تاريخ البداية</th>
            <th class="p-2 border">تاريخ النهاية</th>
            <th class="p-2 border">ملاحظة</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($on_leave as $row): ?>
            <tr>
              <td class="p-2 border"><?= htmlspecialchars($row['employee_name']) ?></td>
              <td class="p-2 border"><?= htmlspecialchars($row['department_name']) ?></td>
              <td class="p-2 border"><?= htmlspecialchars($row['type']) ?></td>
              <td class="p-2 border"><?= $row['start_date'] ?></td>
              <td class="p-2 border"><?= $row['end_date'] ?></td>
              <td class="p-2 border"><?= nl2br(htmlspecialchars($row['reason'])) ?></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  <?php endif; ?>
  
  
  
  <?php if (count($pending_assets) > 0): ?>
  <div class="max-w-4xl mx-auto mt-10">
    <h2 class="text-lg font-bold mb-4 text-red-600">📌 طلبات عهدة بانتظار موافقة الموارد البشرية</h2>
    <table class="card w-full text-sm border rounded shadow">
      <thead>
        <tr>
          <th class="p-2 border">الموظف</th>
          <th class="p-2 border">الإدارة</th>
          <th class="p-2 border">نوع العهدة</th>
          <th class="p-2 border">تفاصيل</th>
          <th class="p-2 border">التاريخ</th>
          <th class="p-2 border">الإجراءات</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($pending_assets as $asset): ?>
          <tr>
            <td class="p-2 border"><?= htmlspecialchars($asset['employee_name']) ?></td>
            <td class="p-2 border"><?= htmlspecialchars($asset['department_name']) ?></td>
            <td class="p-2 border"><?= htmlspecialchars($asset['asset_type_name']) ?></td>
            <td class="p-2 border"><?= nl2br(htmlspecialchars($asset['details'])) ?></td>
            <td class="p-2 border"><?= $asset['created_at'] ?></td>
            <td class="p-2 border text-orange-600 font-semibold">
  <form method="POST" action="update_asset_status.php" class="mt-2 space-y-1 asset-approval-form">
    <input type="hidden" name="id" value="<?= $asset['id'] ?>">
    <textarea name="note" class="w-full text-xs border rounded px-2 py-1" placeholder="ملاحظة ..."></textarea>
    <!-- قائمة المدراء (تظهر فقط بعد الضغط على موافقة) -->
<div class="manager-select-area hidden mt-2">
  <select name="assigned_manager_id" class="w-full rounded border p-2 mb-2" required>
    <option value="">اختر المدير المختص</option>
    <?php foreach ($managers as $manager): ?>
      <option value="<?= $manager['id'] ?>">
        <?= htmlspecialchars($manager['name']) ?> (<?= htmlspecialchars($manager['department_name']) ?>)
      </option>
    <?php endforeach; ?>
  </select>
  <select name="approved_by_manager" class="w-full rounded border p-2 mb-2" required>
    <option value="">اختر المدير المعتمد</option>
    <?php foreach ($managers as $manager): ?>
      <option value="<?= $manager['id'] ?>">
        <?= htmlspecialchars($manager['name']) ?> (<?= htmlspecialchars($manager['department_name']) ?>)
      </option>
    <?php endforeach; ?>
  </select>
</div>

    <div class="flex gap-1 mt-1">
      <button type="button" class="bg-green-600 text-white text-xs px-2 py-1 rounded show-managers-btn">موافقة</button>
      <button name="action" value="reject" class="bg-red-600 text-white text-xs px-2 py-1 rounded">رفض</button>
    </div>
    <!-- زر إرسال بعد اختيار المدير -->
    <button name="action" value="accept" class="submit-approval-btn bg-green-700 text-white text-xs px-2 py-1 rounded mt-2 hidden w-full">تحويل للمدير المختص</button>
  </form>
</td>

          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
<?php endif; ?>


  <!-- ✅ كانبان الموظفين حسب الإدارة -->
  <h2 class="text-xl font-bold text-center my-6 text-green-800">🏢 الموظفون حسب الإدارات</h2>

  <div class="px-4 sm:px-6 lg:px-8">
    <div class="flex gap-4 overflow-x-auto mb-16 mt-10 px-4 sm:px-6 lg:px-8">
      <?php foreach ($departments_all as $dept): ?>
        <div class="card bg-white rounded shadow w-72 flex-shrink-0">
          <h2 class="card-green-list text-white p-2 rounded-t text-center "><?= htmlspecialchars($dept['name']) ?></h2>

          <?php if ($dept['parent_id']): ?>
            <div class="text text-xs text-center text-gray-500 p-1 border-b border-gray-200">
              ↪ تابعة لـ <?= htmlspecialchars($departmentNamesMap[$dept['parent_id']] ?? '—') ?>
            </div>
          <?php endif; ?>

          <div class="p-2 space-y-2 min-h-[200px]"
            ondragover="event.preventDefault()"
            ondrop="onDeptDrop(event, <?= $dept['id'] ?>)">
            <?php foreach ($grouped_by_department[$dept['id']] ?? [] as $emp): ?>
              <div class="main-card task-card p-2 rounded shadow hover:bg-green-50"
                draggable="true"
                ondragstart="onDeptDragStart(event)"
                data-user-id="<?= $emp['id'] ?>">
                <div class="text font-bold"><?= htmlspecialchars($emp['name']) ?></div>
                <div class="text text-sm text-gray-600"><?= htmlspecialchars($emp['job_title'] ?? '') ?></div>
                <div class="text text-xs text-gray-500"><?= htmlspecialchars($emp['email']) ?></div>
              </div>

            <?php endforeach; ?>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  </div>

  <!-- ✅ رسم بياني عدد الموظفين حسب الإدارة -->
  <div class="max-w-5xl mx-auto main-card task p-4 rounded shadow mb-10">
    <canvas id="departmentChart" height="90"></canvas>
  </div>

  <div class="px-4 sm:px-6 lg:px-8">

<a href="add_location.php" class="bg-purple-600 text-white px-4 py-2 rounded hover:bg-purple-700 inline-block mb-4">
  📍 إدارة المواقع
</a>
</div>

  <!-- ✅ تغليف الكانبان والرسم البياني داخل حاوية موحدة -->
  <h2 class="text-xl font-bold text-center my-6 text-blue-800">📍 الموظفون حسب المواقع</h2>

  <div class="px-4 sm:px-6 lg:px-8">


    <!-- ✅ كانبان الموظفين حسب الموقع -->
    <div class="flex gap-4 overflow-x-auto mb-16 mt-10 px-4 sm:px-6 lg:px-8">
      <?php foreach ($locations as $loc): ?>
        <div class="card bg-white rounded shadow w-72 flex-shrink-0">
          <h2 class="card-blue-list text-white p-2 rounded-t text-center "><?= htmlspecialchars($loc['name']) ?></h2>
          <div class="p-2 space-y-2 min-h-[200px]"
            ondragover="event.preventDefault()"
            ondrop="onDrop(event, <?= $loc['id'] ?>)">
            <?php foreach ($grouped_by_location[$loc['id']] ?? [] as $emp): ?>
              <div class="main-card task-card p-2 rounded shadow hover:bg-blue-50"
                draggable="true"
                ondragstart="onDragStart(event)"
                data-user-id="<?= $emp['id'] ?>">
                <div class="text font-bold"><?= htmlspecialchars($emp['name']) ?></div>
                <div class="text text-sm text-gray-600"><?= htmlspecialchars($emp['job_title'] ?? '') ?></div>
                <div class="text text-xs text-gray-500"><?= htmlspecialchars($emp['email']) ?></div>
              </div>
            <?php endforeach; ?>
          </div>
        </div>
      <?php endforeach; ?>
    </div>

  </div>
  <!-- ✅ الرسم البياني -->
  <div class="max-w-5xl mx-auto main-card task p-4 rounded shadow mb-10 mt-10">
    <canvas id="locationChart" height="90"></canvas>
  </div>


  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <script>
    const ctx = document.getElementById('locationChart').getContext('2d');
    const locationLabels = <?= json_encode(array_column($locations, 'name')) ?>;
    const locationCounts = <?= json_encode(array_map(fn($loc) => $location_counts[$loc['id']] ?? 0, $locations)) ?>;

    new Chart(ctx, {
      type: 'bar',
      data: {
        labels: locationLabels,
        datasets: [{
          label: 'عدد الموظفين',
          data: locationCounts,
          backgroundColor: '<?= $chartColor ?>',
          borderColor: 'rgb(255, 255, 255)',
          borderWidth: 1
        }]
      },
      options: {
        responsive: true,
        plugins: {
          legend: {
            display: false
          },
          tooltip: {
            callbacks: {
              label: function(context) {
                return context.dataset.label + ': ' + context.parsed.y;
              }
            },
            titleColor: '<?= htmlspecialchars($userThemeSecondTextColor, ENT_QUOTES, 'UTF-8') ?>',
            bodyColor: '<?= htmlspecialchars($userThemeSecondTextColor, ENT_QUOTES, 'UTF-8') ?>'
          }
        },
        scales: {
          x: {
            ticks: {
              color: '<?= htmlspecialchars($userThemeSecondTextColor, ENT_QUOTES, 'UTF-8') ?>'
            }
          },
          y: {
            beginAtZero: true,
            ticks: {
              color: '<?= htmlspecialchars($userThemeSecondTextColor, ENT_QUOTES, 'UTF-8') ?>'
            }
          }
        }
        // scales: {
        //   y: {
        //     beginAtZero: true,
        //     ticks: {
        //       stepSize: 1
        //     }
        //   }
        // }
      }
    });


    const depLabels = <?= json_encode(array_column($departments_all, 'name')) ?>;
    const depCounts = <?= json_encode(array_map(fn($d) => $department_counts[$d['id']] ?? 0, $departments_all)) ?>;

    new Chart(document.getElementById('departmentChart').getContext('2d'), {
      type: 'bar',
      data: {
        labels: depLabels,
        datasets: [{
          label: 'عدد الموظفين بالإدارة',
          data: depCounts,
          backgroundColor: '<?= $chartColor ?>',
          borderColor: 'rgb(255, 255, 255)',
          borderWidth: 1
        }]
      },
      options: {
        responsive: true,
        plugins: {
          legend: {
            display: false
          },
          tooltip: {
            callbacks: {
              label: function(context) {
                return context.dataset.label + ': ' + context.parsed.y;
              }
            },
            titleColor: '<?= htmlspecialchars($userThemeSecondTextColor, ENT_QUOTES, 'UTF-8') ?>',
            bodyColor: '<?= htmlspecialchars($userThemeSecondTextColor, ENT_QUOTES, 'UTF-8') ?>'
          }
        },
        scales: {
          x: {
            ticks: {
              color: '<?= htmlspecialchars($userThemeSecondTextColor, ENT_QUOTES, 'UTF-8') ?>'
            }
          },
          y: {
            beginAtZero: true,
            ticks: {
              color: '<?= htmlspecialchars($userThemeSecondTextColor, ENT_QUOTES, 'UTF-8') ?>'
            }
          }
        }
        // scales: {
        //   y: {
        //     beginAtZero: true,
        //     ticks: {
        //       stepSize: 1
        //     }
        //   }
        // }
      }
    });
  </script>
  <script>
function showEmployeeDetails(user) {
  const box = document.getElementById('employeeDetails');
  box.classList.remove('hidden');
  currentEmployeeNumber = user.employee_number || user.id || null;
  currentEmployeeId = user.id || null;

  document.getElementById('empName').textContent = user.name || '—';
  document.getElementById('empNumber').textContent = user.employee_number || '—';
  document.getElementById('empEmail').textContent = user.email || '—';
  document.getElementById('empJob').textContent = user.job_title || '—';
  document.getElementById('empDept').textContent = user.department_name || '—';
  document.getElementById('empLocation').textContent = user.location_name || '—';
  document.getElementById('empStatus').textContent = user.employment_status || '—';

  const filesBtn = document.getElementById('empFilesBtn');
  filesBtn.href = 'employee_files.php?id=' + (user.employee_number || user.id);
  filesBtn.style.display = 'inline-block';

  // زر رفع ملف (تحقق أنه موجود قبل ما تعطيه href)
  const uploadFileBtn = document.getElementById('empUploadFileBtn');
  if (uploadFileBtn) {
    uploadFileBtn.href = 'upload_employee_file.php?id=' + (user.employee_number || user.id);
  }

  // زر تقييم الموظف
  const evalBtn = document.getElementById('empEvalBtn');
  evalBtn.href = 'add_evaluation.php?id=' + (user.employee_number || user.id);

  // زر تدريبات الموظف
  const trainingBtn = document.getElementById('empTrainingBtn');
  trainingBtn.href = 'trainings_list.php?id=' + (user.employee_number || user.id);

  // زر سجل الحضور
  const attendanceBtn = document.getElementById('empAttendanceBtn');
  attendanceBtn.href = 'attendance_log.php?id=' + (user.employee_number || user.id);

  const img = document.getElementById('empImage');
  img.src = user.profile_image && user.profile_image !== '' ? 'img/' + user.profile_image : '';

  const editBtn = document.getElementById('empEditBtn');
  editBtn.href = 'edit.php?id=' + user.id;
}

    function hideEmployeeDetails() {
      document.getElementById('employeeDetails').classList.add('hidden');
    }
  </script>

  <script>
    let draggedUserId = null;

    function onDragStart(event) {
      draggedUserId = event.target.dataset.userId;
    }

    function onDrop(event, newLocationId) {
      event.preventDefault();
      if (!draggedUserId) return;

      fetch('update_location_api.php', {
          method: 'POST',
          headers: {
            'Content-Type': 'application/json'
          },
          body: JSON.stringify({
            user_id: draggedUserId,
            location_id: newLocationId
          })
        })
        .then(res => res.json())
        .then(data => {
          if (data.success) {
            const draggedElement = document.querySelector(`[data-user-id='${draggedUserId}']`);
            const targetColumn = event.currentTarget;
            if (draggedElement && targetColumn) {
              targetColumn.appendChild(draggedElement);
            }
          } else {
            alert('حدث خطأ أثناء التحديث');
          }
        });
    }
  </script>
  <script>
    let draggedUserIdDept = null;

    function onDeptDragStart(event) {
      draggedUserIdDept = event.target.dataset.userId;
    }

    function onDeptDrop(event, newDepartmentId) {
      event.preventDefault();
      if (!draggedUserIdDept) return;

      fetch('update_department_api.php', {
          method: 'POST',
          headers: {
            'Content-Type': 'application/json'
          },
          body: JSON.stringify({
            user_id: draggedUserIdDept,
            department_id: newDepartmentId
          })
        })
        .then(res => res.json())
        .then(data => {
          if (data.success) {
            const draggedElement = document.querySelector(`[data-user-id='${draggedUserIdDept}']`);
            const targetColumn = event.currentTarget;
            if (draggedElement && targetColumn) {
              targetColumn.appendChild(draggedElement);
            }
          } else {
            alert('حدث خطأ أثناء التحديث');
          }
        });
    }
  </script>

<!-- مودال عرض ورفع ملفات الموظف -->
<div id="employeeFilesModal" class="fixed inset-0 z-50 flex items-center justify-center bg-black bg-opacity-50 hidden">
  <div class="bg-white rounded-lg shadow-lg p-6 w-full max-w-lg relative">
    <button onclick="closeEmployeeFilesModal()" class="absolute top-2 left-2 text-gray-600 text-2xl">&times;</button>
    <h2 class="font-bold mb-4 text-lg">📂 ملفات الموظف <span id="modalEmpNumber" class="text-blue-600"></span></h2>

    <!-- هنا قائمة الملفات -->
    <div id="employeeFilesList" class="mb-6">
      <div class="text-gray-400 text-center">جاري تحميل الملفات ...</div>
    </div>

    <hr class="my-4">

    <!-- نموذج رفع ملف -->
    <form id="employeeFileUploadForm" method="post" enctype="multipart/form-data" action="upload_employee_file.php" target="uploadFileFrame">
      <input type="hidden" name="employee_number" id="modalEmployeeNumberInput">
      <input type="file" name="file" required class="border p-2 w-full mb-3">
      <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">رفع الملف</button>
      <span id="employeeFileUploadResult" class="block mt-3 text-sm"></span>
    </form>
    <iframe name="uploadFileFrame" class="hidden"></iframe>
  </div>
</div>

<script>
let currentEmployeeNumber = null;

// فتح المودال وجلب الملفات
function openEmployeeFilesModal(empNumber = null) {
  if (!empNumber && !currentEmployeeNumber) {
    alert('لا يوجد موظف محدد!');
    return;
  }
  currentEmployeeNumber = empNumber || currentEmployeeNumber;
  document.getElementById('employeeFilesModal').classList.remove('hidden');
  document.getElementById('modalEmpNumber').textContent = currentEmployeeNumber;
  document.getElementById('modalEmployeeNumberInput').value = currentEmployeeNumber;
  fetchEmployeeFiles(currentEmployeeNumber);
  document.getElementById('employeeFileUploadResult').textContent = '';
}

function closeEmployeeFilesModal() {
  document.getElementById('employeeFilesModal').classList.add('hidden');
}

// جلب وعرض الملفات بالـ AJAX
function fetchEmployeeFiles(empNumber) {
  document.getElementById('employeeFilesList').innerHTML = `<div class="text-gray-400 text-center">جاري تحميل الملفات ...</div>`;
  fetch('fetch_employee_files.php?id=' + encodeURIComponent(empNumber))
    .then(res => res.text())
    .then(html => {
      document.getElementById('employeeFilesList').innerHTML = html;
    });
}

// عند رفع ملف (عرض النتيجة + تحديث القائمة)
// عرّف الحدث مرة وحدة أول ما تشتغل الصفحة
window.uploadFileFrame.onload = function() {
  var content = window.uploadFileFrame.document.body.innerText;
  document.getElementById('employeeFileUploadResult').textContent = content;
  // حدث القائمة لو نجح
  if (content.includes('نجاح') || content.includes('✔')) {
    fetchEmployeeFiles(currentEmployeeNumber);
    // امسح النص بعد كم ثانية (اختياري)
    setTimeout(() => {
      document.getElementById('employeeFileUploadResult').textContent = '';
    }, 1200);
    // امسح حقل اختيار الملف (اختياري)
    document.querySelector('#employeeFileUploadForm input[type="file"]').value = '';
  }
};

// استبدل كود onsubmit بالتالي:
document.getElementById('employeeFileUploadForm').onsubmit = function() {
  document.getElementById('employeeFileUploadResult').textContent = "جاري رفع الملف...";
  // ما يحتاج تعيد تعريف الـ onload هنا!
  return true;
}


</script>
<!-- مودال الدورات التدريبية -->
<div id="trainingsModal" class="fixed inset-0 z-50 flex items-center justify-center bg-black bg-opacity-50 hidden">
  <div class="bg-white rounded-lg shadow-lg p-6 w-full max-w-2xl relative" style="direction: rtl;">
    <button onclick="closeTrainingsModal()" class="absolute top-2 left-2 text-gray-600 text-2xl">&times;</button>
    <h2 class="font-bold mb-4 text-lg">🎓 دورات الموظف <span id="modalTrainingsEmpNumber" class="text-blue-600"></span></h2>
    <!-- قائمة الدورات -->
    <div id="employeeTrainingsList" class="mb-6">
      <div class="text-gray-400 text-center">جاري تحميل الدورات ...</div>
    </div>
    <hr class="my-4">
    <!-- فورم إضافة دورة -->
    <form id="addTrainingForm" class="space-y-2" onsubmit="return submitAddTraining(event)">
<input type="hidden" name="employee_id" id="addTrainingEmpNumber">
      <div class="grid grid-cols-1 md:grid-cols-3 gap-2">
        <input type="text" name="course_name" required placeholder="اسم الدورة" class="border p-2 rounded">
        <input type="text" name="provider" required placeholder="الجهة" class="border p-2 rounded">
        <input type="date" name="course_date" required class="border p-2 rounded">
      </div>
      <div class="grid grid-cols-1 md:grid-cols-3 gap-2">
        <input type="number" name="hours" required placeholder="عدد الساعات" class="border p-2 rounded">
        <input type="text" name="employee_feedback" placeholder="ملاحظات" class="border p-2 rounded">
        <input type="file" name="certificate" accept="application/pdf,image/*" class="border p-2 rounded">
      </div>
      <button type="submit" class="bg-green-600 text-white px-4 py-2 rounded hover:bg-green-700">➕ إضافة دورة</button>
      <span id="addTrainingResult" class="block mt-2 text-sm"></span>
    </form>
  </div>
</div>

<script>
// فتح المودال وجلب الدورات
function openTrainingsModal(empNumber = null) {
  if (!empNumber && !currentEmployeeNumber) {
    alert('لا يوجد موظف محدد!');
    return;
  }
  currentEmployeeNumber = empNumber || currentEmployeeNumber;
  document.getElementById('trainingsModal').classList.remove('hidden');
  document.getElementById('modalTrainingsEmpNumber').textContent = currentEmployeeNumber;
  document.getElementById('addTrainingEmpNumber').value = currentEmployeeNumber;
  fetchEmployeeTrainings(currentEmployeeNumber);
  document.getElementById('addTrainingResult').textContent = '';
}

// إغلاق المودال
function closeTrainingsModal() {
  document.getElementById('trainingsModal').classList.add('hidden');
}

// جلب وعرض الدورات بالـ AJAX
function fetchEmployeeTrainings(empNumber) {
  document.getElementById('employeeTrainingsList').innerHTML = `<div class="text-gray-400 text-center">جاري تحميل الدورات ...</div>`;
  fetch('fetch_employee_trainings.php?id=' + encodeURIComponent(empNumber))
    .then(res => res.text())
    .then(html => {
      document.getElementById('employeeTrainingsList').innerHTML = html;
    });
}

// عند إضافة دورة (AJAX)
function submitAddTraining(event) {
  event.preventDefault();
  var form = document.getElementById('addTrainingForm');
  var formData = new FormData(form);
  document.getElementById('addTrainingResult').textContent = "جاري الحفظ ...";
  fetch('add_training.php', {
    method: 'POST',
    body: formData
  })
  .then(res => res.text())
  .then(result => {
    document.getElementById('addTrainingResult').textContent = result;
    if (result.includes('✔') || result.includes('نجاح')) {
      fetchEmployeeTrainings(currentEmployeeNumber);
      setTimeout(() => { document.getElementById('addTrainingResult').textContent = ''; }, 1200);
      form.reset();
    }
  });
  return false;
}
</script>

<script>
document.querySelectorAll('.show-managers-btn').forEach(function(btn) {
  btn.addEventListener('click', function(e) {
    e.preventDefault();
    var form = btn.closest('.asset-approval-form');
    // أظهر قائمة المدراء وزر التحويل فقط
    form.querySelector('.manager-select-area').classList.remove('hidden');
    form.querySelector('.submit-approval-btn').classList.remove('hidden');
    btn.style.display = 'none'; // اخفي زر الموافقة الأول
  });
});
</script>

<!-- مودال التأخير/الغياب + الإضافي -->
<div id="lateAbsenceModal" class="fixed inset-0 z-50 hidden items-center justify-center bg-black/50">
  <div class="bg-white rounded-lg shadow-lg w-full max-w-5xl relative" style="max-height:85vh; overflow:auto; direction: rtl;">
    <button type="button" onclick="closeLateModal()" class="absolute top-2 left-3 text-2xl">&times;</button>

    <div class="p-4 border-b flex flex-wrap items-center gap-3">
      <div class="font-bold">تفاصيل التأخير والغياب: <span id="lateEmpName" class="text-blue-700"></span></div>

      <div class="ml-auto flex items-center gap-2">
        <label>الشهر:</label>
        <select id="lateMonth" class="border rounded px-2 py-1">
          <?php for($m=1;$m<=12;$m++): ?>
            <option value="<?=$m?>"><?=$m?></option>
          <?php endfor; ?>
        </select>

        <label>السنة:</label>
        <input type="number" id="lateYear" class="border rounded px-2 py-1 w-24" min="2000" max="2100" value="<?= date('Y') ?>">

        <button type="button" class="bg-indigo-600 text-white px-3 py-1 rounded" onclick="reloadLateDetails()">عرض</button>
      </div>
    </div>

    <div id="lateAbsenceBody" class="p-4">جاري التحميل...</div>
  </div>
</div>

<script>
  let currentEmployeeId = null;

  function openLateModal(empId, empName) {
    currentEmployeeId = empId;
    $('#lateEmpName').text(empName || '');

    // اضبط الشهر/السنة الافتراضيين مرة وحدة
    const now = new Date();
    if (!$('#lateMonth').data('set')) { $('#lateMonth').val(now.getMonth() + 1); $('#lateMonth').data('set', true); }
    if (!$('#lateYear').data('set'))  { $('#lateYear').val(now.getFullYear());    $('#lateYear').data('set',  true); }

    $('#lateAbsenceBody').html('جاري التحميل...');
    $('#lateAbsenceModal').removeClass('hidden').addClass('flex');
    reloadLateDetails();
  }

  function reloadLateDetails() {
    if (!currentEmployeeId) return;
    const m = $('#lateMonth').val();
    const y = $('#lateYear').val();

    $.get('late_absence_penalties/employee_late_details.php', { id: currentEmployeeId, month: m, year: y })
      .done(function (html) {
        $('#lateAbsenceBody').html(html);
      })
      .fail(function () {
        $('#lateAbsenceBody').html("<div class='text-red-600 p-4'>تعذر تحميل البيانات.</div>");
      });
  }

  function closeLateModal() {
    $('#lateAbsenceModal').addClass('hidden').removeClass('flex');
  }

  // زر من جدول المستخدمين
  $(document).on('click', '.open-late-modal', function (e) {
    e.preventDefault();
    const empId   = $(this).data('emp-id');
    const empName = $(this).data('emp-name') || '';
    openLateModal(empId, empName);
  });

  // إغلاق عند الضغط على خلفية المودال
  $('#lateAbsenceModal').on('click', function (e) {
    if (e.target === this) closeLateModal();
  });

  // بعض صفحات التفاصيل فيها زر إغلاق داخلي class="move-button" – نخليه يغلق هذا المودال
  $(document).on('click', '#lateAbsenceModal .move-button', function () {
    closeLateModal();
  });
</script>



</body>

</html>