<?php
session_start();
require_once '../../config/db.php';
require_once '../../auth.php'; // التأكد من تسجيل الدخول والصلاحيات

// رسالة للتنبيهات
$msg = '';

// حذف سجل
if (isset($_GET['delete_id'])) {
    $id = intval($_GET['delete_id']);
    $stmt = $conn->prepare("DELETE FROM late_absence_penalties WHERE id = ?");
    $stmt->execute([$id]);
    $msg = "تم حذف السجل بنجاح";
}

// إضافة أو تحديث سجل
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user_id         = $_POST['user_id'];
    $month           = $_POST['month'];
    $year            = $_POST['year'];
    $late_hours      = $_POST['late_hours'];
    $absent_days     = $_POST['absent_days'];
    $late_deduction  = $_POST['late_deduction'];
    $absent_deduction= $_POST['absent_deduction'];
    $note            = $_POST['note'];

    if (!empty($_POST['id'])) {
        // تحديث
        $id = intval($_POST['id']);
        $stmt = $conn->prepare("UPDATE late_absence_penalties
                                 SET user_id = ?, month = ?, year = ?, late_hours = ?, absent_days = ?, late_deduction = ?, absent_deduction = ?, note = ?
                                 WHERE id = ?");
        $stmt->execute([$user_id, $month, $year, $late_hours, $absent_days, $late_deduction, $absent_deduction, $note, $id]);
        $msg = "تم تحديث السجل بنجاح";
    } else {
        // إضافة
        $stmt = $conn->prepare("INSERT INTO late_absence_penalties
            (user_id, month, year, late_hours, absent_days, late_deduction, absent_deduction, note)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->execute([$user_id, $month, $year, $late_hours, $absent_days, $late_deduction, $absent_deduction, $note]);
        $msg = "تم إضافة السجل بنجاح";
    }
}

// جلب بيانات للتعديل إذا كان edit_id موجودًا
$edit = null;
if (isset($_GET['edit_id'])) {
    $id = intval($_GET['edit_id']);
    $stmt = $conn->prepare("SELECT * FROM late_absence_penalties WHERE id = ?");
    $stmt->execute([$id]);
    $edit = $stmt->fetch(PDO::FETCH_ASSOC);
}

// جلب الموظفين لقائمة الاختيار
$stmt = $conn->prepare("SELECT id, name FROM users WHERE employment_status = 'نشط' ORDER BY name");
$stmt->execute();
$users = $stmt->fetchAll(PDO::FETCH_ASSOC);

// جلب السجلات
$stmt = $conn->prepare("SELECT p.*, u.name
                        FROM late_absence_penalties p
                        JOIN users u ON u.id = p.user_id
                        ORDER BY p.year DESC, p.month DESC, u.name ASC");
$stmt->execute();
$penalties = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <title>إدارة خصومات التأخير والغياب</title>
    <style>
        body {font-family: Tahoma, sans-serif; direction: rtl; margin: 20px;}
        table {border-collapse: collapse; width: 100%;}
        th, td {border: 1px solid #ddd; padding: 8px;}
        th {background-color: #f2f2f2;}
        form label {display: inline-block; width: 150px; margin-bottom: 5px;}
        form input, form select, form textarea {margin-bottom: 10px; width: 200px;}
        .message {color: green; font-weight: bold; margin-bottom: 10px;}
    </style>
</head>
<body>
<?php if ($msg): ?>
    <p class="message"><?= $msg; ?></p>
<?php endif; ?>

<h2>إدارة خصومات التأخير والغياب</h2>

<!-- نموذج لإضافة/تحديث -->
<form method="post">
    <input type="hidden" name="id" value="<?= isset($edit['id']) ? $edit['id'] : ''; ?>">
    <label>الموظف:</label>
    <select name="user_id" required>
        <option value="">اختر موظف</option>
        <?php foreach ($users as $u): ?>
            <option value="<?= $u['id']; ?>" <?= (isset($edit) && $edit['user_id'] == $u['id']) ? 'selected' : ''; ?>><?= htmlspecialchars($u['name']); ?></option>
        <?php endforeach; ?>
    </select><br>
    <label>الشهر:</label>
    <input type="number" name="month" min="1" max="12" value="<?= isset($edit['month']) ? $edit['month'] : date('n'); ?>" required><br>
    <label>السنة:</label>
    <input type="number" name="year" min="2000" max="2100" value="<?= isset($edit['year']) ? $edit['year'] : date('Y'); ?>" required><br>
    <label>ساعات التأخير:</label>
    <input type="number" step="0.01" name="late_hours" value="<?= isset($edit['late_hours']) ? $edit['late_hours'] : 0; ?>"><br>
    <label>أيام الغياب:</label>
    <input type="number" name="absent_days" value="<?= isset($edit['absent_days']) ? $edit['absent_days'] : 0; ?>"><br>
    <label>قيمة الخصم بسبب التأخير:</label>
    <input type="number" step="0.01" name="late_deduction" value="<?= isset($edit['late_deduction']) ? $edit['late_deduction'] : 0; ?>"><br>
    <label>قيمة الخصم بسبب الغياب:</label>
    <input type="number" step="0.01" name="absent_deduction" value="<?= isset($edit['absent_deduction']) ? $edit['absent_deduction'] : 0; ?>"><br>
    <label>ملاحظات:</label>
    <textarea name="note"><?= isset($edit['note']) ? htmlspecialchars($edit['note']) : ''; ?></textarea><br>
    <button type="submit"><?= isset($edit) ? 'تحديث' : 'إضافة'; ?> السجل</button>
</form>

<hr>

<table>
    <tr>
        <th>الموظف</th>
        <th>الشهر</th>
        <th>السنة</th>
        <th>ساعات التأخير</th>
        <th>أيام الغياب</th>
        <th>خصم التأخير</th>
        <th>خصم الغياب</th>
        <th>ملاحظات</th>
        <th>الإجراءات</th>
    </tr>
    <?php foreach ($penalties as $p): ?>
        <tr>
            <td><?= htmlspecialchars($p['name']); ?></td>
            <td><?= $p['month']; ?></td>
            <td><?= $p['year']; ?></td>
            <td><?= $p['late_hours']; ?></td>
            <td><?= $p['absent_days']; ?></td>
            <td><?= $p['late_deduction']; ?></td>
            <td><?= $p['absent_deduction']; ?></td>
            <td><?= htmlspecialchars($p['note']); ?></td>
            <td>
                <a href="?edit_id=<?= $p['id']; ?>">تعديل</a> |
                <a href="?delete_id=<?= $p['id']; ?>" onclick="return confirm('هل أنت متأكد من الحذف؟');">حذف</a>
            </td>
        </tr>
    <?php endforeach; ?>
</table>

</body>
</html>
