<?php
// /erp_task_system/leaves/requests.php
session_start();
require_once '../config/db.php';
require_once '../auth.php';

if (!isset($_SESSION['user'])) { header("Location: ../unauthorized.php"); exit; }
$user = $_SESSION['user'];
$role = $user['role'] ?? 'employee';
$user_id = (int)($user['id'] ?? 0);

// السماح بس للمدير أو المدير العام
if (!in_array($role, ['admin', 'manager'], true)) {
  header("Location: ../unauthorized.php");
  exit;
}

// اجلب اسم إدارة المستخدم (عشان نعرف هل هو موارد بشرية)
$userDeptId = (int)($user['department_id'] ?? 0);
$userDeptName = null;
if ($userDeptId > 0) {
  $st = $conn->prepare("SELECT name FROM departments WHERE id=?");
  $st->execute([$userDeptId]);
  $userDeptName = $st->fetchColumn() ?: null;
}

// مبدئيًا: اعتبر الموارد البشرية لو الاسم واحد من هذي
$isHRDept = false;
if ($role === 'manager' && $userDeptName) {
  $hrNames = ['إدارة الموارد البشرية','الموارد البشرية','HR','Human Resources'];
  $isHRDept = in_array($userDeptName, $hrNames, true);
}

// CSRF
if (empty($_SESSION['csrf_leave'])) {
  $_SESSION['csrf_leave'] = bin2hex(random_bytes(16));
}

// جب الطلبات
$sql = "
  SELECT lr.*, u.name AS employee_name, u.department_id, d.name AS department_name
  FROM leave_requests lr
  JOIN users u ON lr.user_id = u.id
  LEFT JOIN departments d ON u.department_id = d.id
  ORDER BY lr.id DESC
";
$stmt = $conn->query($sql);
$requests = $stmt->fetchAll(PDO::FETCH_ASSOC);

// ثيم (اختياري)
$color = $user['color'] ?? ['hex_code'=>'#f8fafc','text_color'=>'#111827','nav_color'=>'#233a58'];
$bg  = htmlspecialchars($color['hex_code'] ?? '#f8fafc');
$txt = htmlspecialchars($color['text_color'] ?? '#111827');
$nav = htmlspecialchars($color['nav_color'] ?? '#233a58');
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>طلبات الإجازة</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    body { background-color: <?= $bg ?> }
    .badge { padding: 2px 8px; border-radius: 9999px; font-size: 12px; display: inline-block }
    .badge-blue  { background:#e0f2fe; color:#0369a1 }
    .badge-green { background:#dcfce7; color:#166534 }
    .badge-red   { background:#fee2e2; color:#991b1b }
    .badge-amber { background:#fef3c7; color:#92400e }
    .badge-slate { background:#e2e8f0; color:#334155 }
    .note { white-space: pre-wrap; }
  </style>
</head>
<body class="p-6">

<div class="max-w-7xl mx-auto">
  <h1 class="text-2xl font-bold mb-4">📋 طلبات الإجازة</h1>

  <?php if (!empty($_SESSION['success'])): ?>
    <div class="bg-green-100 text-green-800 px-4 py-2 rounded mb-4">
      <?= htmlspecialchars($_SESSION['success'], ENT_QUOTES, 'UTF-8'); unset($_SESSION['success']); ?>
    </div>
  <?php endif; ?>
  <?php if (!empty($_SESSION['error'])): ?>
    <div class="bg-red-100 text-red-800 px-4 py-2 rounded mb-4">
      <?= htmlspecialchars($_SESSION['error'], ENT_QUOTES, 'UTF-8'); unset($_SESSION['error']); ?>
    </div>
  <?php endif; ?>

  <div class="overflow-x-auto bg-white rounded shadow">
    <table class="w-full text-sm">
      <thead class="bg-gray-100 text-gray-700">
        <tr>
          <th class="px-4 py-2">#</th>
          <th class="px-4 py-2">الموظف</th>
          <th class="px-4 py-2">الإدارة</th>
          <th class="px-4 py-2">النوع</th>
          <th class="px-4 py-2">من</th>
          <th class="px-4 py-2">إلى</th>
          <th class="px-4 py-2">السبب</th>
          <th class="px-4 py-2">الحالة النهائية</th>
          <th class="px-4 py-2">قرار المدير</th>
          <th class="px-4 py-2">ملاحظة المدير</th>
          <th class="px-4 py-2">قرار الموارد</th>
          <th class="px-4 py-2">ملاحظة الموارد</th>
          <th class="px-4 py-2">الإجراء</th>
        </tr>
      </thead>
      <tbody>
        <?php $today = date('Y-m-d'); ?>
        <?php foreach ($requests as $i => $req): ?>
          <?php
            $manager = $req['manager_status'] ?? null; // مقبولة | مرفوضة | NULL
            $hr      = $req['hr_status']      ?? null; // مقبولة | مرفوضة | NULL
            $start   = $req['start_date'];
            $end     = $req['end_date'];

            // تحديد الحالة النهائية للعرض
            $displayStatus = '—';
            $cls = 'badge badge-slate';

            if (is_null($manager)) {
              $displayStatus = 'بانتظار موافقة المدير';
              $cls = 'badge badge-amber';
            } elseif ($manager === 'مرفوضة' || $hr === 'مرفوضة') {
              $displayStatus = 'مرفوضة';
              $cls = 'badge badge-red';
            } elseif ($manager === 'مقبولة' && is_null($hr)) {
              $displayStatus = 'بانتظار موافقة الموارد';
              $cls = 'badge badge-amber';
            } elseif ($manager === 'مقبولة' && $hr === 'مقبولة') {
              if ($today < $start) {
                $displayStatus = 'مقبولة (لم تبدأ)';
                $cls = 'badge badge-blue';
              } elseif ($today > $end) {
                $displayStatus = 'منتهية';
                $cls = 'badge badge-slate';
              } else {
                $displayStatus = 'في إجازة';
                $cls = 'badge badge-green';
              }
            } else {
              // fallback لو فيه قيم غريبة
              $st = $req['status'] ?? 'غير معروف';
              $displayStatus = $st;
              $cls = 'badge badge-slate';
            }

            // صلاحيات الإجراء
            $isAdmin = ($role === 'admin');
            $isManager = ($role === 'manager');
            $canManagerApprove = $isManager && ($req['department_id'] == $userDeptId) && is_null($manager);
            $canHRApprove = ($isHRDept || $isAdmin) && is_null($hr);

            // CSRF
            $csrf = htmlspecialchars($_SESSION['csrf_leave'], ENT_QUOTES, 'UTF-8');
          ?>
          <tr class="border-b">
            <td class="px-4 py-2"><?= $i+1 ?></td>
            <td class="px-4 py-2"><?= htmlspecialchars($req['employee_name']) ?></td>
            <td class="px-4 py-2"><?= htmlspecialchars($req['department_name'] ?? '—') ?></td>
            <td class="px-4 py-2"><?= htmlspecialchars($req['type'] ?? '') ?></td>
            <td class="px-4 py-2"><?= htmlspecialchars($start) ?></td>
            <td class="px-4 py-2"><?= htmlspecialchars($end) ?></td>
            <td class="px-4 py-2 note"><?= nl2br(htmlspecialchars($req['reason'] ?? '')) ?></td>

            <td class="px-4 py-2"><span class="<?= $cls ?>"><?= $displayStatus ?></span></td>

            <td class="px-4 py-2 <?= ($manager==='مرفوضة'?'text-red-600':($manager==='مقبولة'?'text-green-600':'text-gray-500')) ?>">
              <?= $manager ?? '—' ?>
            </td>
            <td class="px-4 py-2 text-xs note"><?= nl2br(htmlspecialchars($req['manager_note'] ?? '')) ?></td>

            <td class="px-4 py-2 <?= ($hr==='مرفوضة'?'text-red-600':($hr==='مقبولة'?'text-green-600':'text-gray-500')) ?>">
              <?= $hr ?? '—' ?>
            </td>
            <td class="px-4 py-2 text-xs note"><?= nl2br(htmlspecialchars($req['hr_note'] ?? '')) ?></td>

            <td class="px-4 py-2 min-w-56">
              <?php if ($canManagerApprove): ?>
                <form method="POST" action="update_leave_status.php" class="space-y-1">
                  <input type="hidden" name="csrf" value="<?= $csrf ?>">
                  <input type="hidden" name="id" value="<?= (int)$req['id'] ?>">
                  <input type="hidden" name="actor" value="manager">
                  <textarea name="note" class="border rounded w-full px-2 py-1 text-xs" placeholder="ملاحظة المدير..."></textarea>
                  <div class="flex gap-1 mt-1">
                    <button name="action" value="accept" class="bg-green-600 text-white text-xs px-2 py-1 rounded">موافقة</button>
                    <button name="action" value="reject" class="bg-red-600 text-white text-xs px-2 py-1 rounded">رفض</button>
                  </div>
                </form>

              <?php elseif ($canHRApprove): ?>
                <form method="POST" action="update_leave_status.php" class="space-y-1">
                  <input type="hidden" name="csrf" value="<?= $csrf ?>">
                  <input type="hidden" name="id" value="<?= (int)$req['id'] ?>">
                  <input type="hidden" name="actor" value="<?= $isAdmin ? 'admin' : 'hr' ?>">
                  <textarea name="note" class="border rounded w-full px-2 py-1 text-xs" placeholder="ملاحظة الموارد..."></textarea>
                  <div class="flex gap-1 mt-1">
                    <button name="action" value="accept" class="bg-green-600 text-white text-xs px-2 py-1 rounded">موافقة</button>
                    <button name="action" value="reject" class="bg-red-600 text-white text-xs px-2 py-1 rounded">رفض</button>
                  </div>
                </form>

              <?php else: ?>
                <span class="text-xs text-gray-400">—</span>
              <?php endif; ?>
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
</body>
</html>
