<?php
@ob_clean();
header('Content-Type: text/plain; charset=utf-8');
date_default_timezone_set('Asia/Riyadh');
session_start();
require_once '../config/db.php';

ini_set('display_errors', 1);
error_reporting(E_ALL);

/* التحقق من الجلسة */
if (!isset($_SESSION['user'])) { header("Location: login.php"); exit; }

$user_id   = (int)($_SESSION['user']['id'] ?? 0);
$todayDate = date('Y-m-d');
$nowTime   = date('H:i:s');
$nowDT     = date('Y-m-d H:i:s');

/* تطبيع نوع العملية */
$rawType = $_POST['type'] ?? '';
$typesMap = [
  'check_in'=>'check_in','check-in'=>'check_in','in'=>'check_in','signin'=>'check_in','login'=>'check_in',
  'check_out'=>'check_out','check-out'=>'check_out','out'=>'check_out','signout'=>'check_out','logout'=>'check_out'
];
$type = $typesMap[strtolower(trim($rawType))] ?? null;
if (!$type) { echo "❌ نوع العملية غير صحيح: {$rawType}"; exit; }

/* تطبيع الإحداثيات (يدعم أرقام عربية) */
function norm_num($v){
  if ($v === null || $v === '') return null;
  $arabic = ['٠','١','٢','٣','٤','٥','٦','٧','٨','٩','٫','٬'];
  $latin  = ['0','1','2','3','4','5','6','7','8','9','.', ''];
  $v = str_replace($arabic, $latin, trim((string)$v));
  return is_numeric($v) ? (float)$v : null;
}
$lat = norm_num($_POST['lat'] ?? null);
$lng = norm_num($_POST['lng'] ?? null);

if ($lat === null || $lng === null) {
  echo "❌ لا توجد إحداثيات. فعل الموقع في المتصفح وحاول مرة ثانية.";
  exit;
}

/* لو الإحداثيات مقلوبة (حدود السعودية) بدّلها */
if (($lat > 33 || $lat < 16) && ($lng >= 34 && $lng <= 56)) {
  $tmp = $lat; $lat = $lng; $lng = $tmp;
}

/* تحقق نطاق الإحداثيات العام */
if ($lat < -90 || $lat > 90 || $lng < -180 || $lng > 180) {
  echo "❌ إحداثيات غير صحيحة."; exit;
}

/* دالة المسافة (هفرساين) بالكيلومتر */
function haversine_km($lat1, $lon1, $lat2, $lon2) {
  $earth = 6371;
  $dLat = deg2rad($lat2 - $lat1);
  $dLon = deg2rad($lon2 - $lon1);
  $a = sin($dLat/2)**2 + cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * sin($dLon/2)**2;
  return 2 * $earth * asin(min(1, sqrt($a)));
}

/* جلب المواقع المصرّح بها (فعّالة) */
$sql = "SELECT l.id, l.name, l.latitude, l.longitude
        FROM user_locations ul
        JOIN locations l ON l.id = ul.location_id
        WHERE ul.user_id = ? AND COALESCE(ul.is_active,1) = 1";
$stmt = $conn->prepare($sql);
$stmt->execute([$user_id]);
$locations = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (!$locations) { echo "❌ ما عندك مواقع مصرح بها. تواصل مع الإدارة."; exit; }

/* أقرب موقع ضمن نصف قطر 50م */
$NEAR_M = 50;
$nearest = null; $nearestDistM = null;
foreach ($locations as $loc) {
  if ($loc['latitude'] === null || $loc['longitude'] === null) continue;
  $dkm = haversine_km($lat, $lng, (float)$loc['latitude'], (float)$loc['longitude']);
  $dm  = round($dkm * 1000, 2);
  if ($nearest === null || $dm < $nearestDistM) { $nearest = $loc; $nearestDistM = $dm; }
}
if (!$nearest) { echo "❌ لا توجد إحداثيات مخزّنة لمواقعك."; exit; }

if ($nearestDistM > $NEAR_M) {
  echo "❌ خارج النطاق. أقرب موقع: {$nearest['name']} على بُعد ~{$nearestDistM}م (الحد {$NEAR_M}م).";
  exit;
}

/* سجل اليوم */
$stmt = $conn->prepare("SELECT * FROM attendance WHERE user_id = ? AND `date` = ? LIMIT 1");
$stmt->execute([$user_id, $todayDate]);
$attendance = $stmt->fetch(PDO::FETCH_ASSOC);

if ($type === 'check_in') {
  if ($attendance) { echo "ℹ️ مسجل حضور اليوم مسبقًا."; exit; }
  $status = ($nowTime > '08:15:00') ? 'متأخر' : 'حاضر'; // لاحقًا اربطه بالـ shift
  $sql = "INSERT INTO attendance (user_id, `date`, check_in, status, note, method, location_id)
          VALUES (?, ?, ?, ?, CONCAT('حضور من: ', ?), 'gps', ?)";
  $conn->prepare($sql)->execute([$user_id, $todayDate, $nowDT, $status, $nearest['name'], $nearest['id']]);
  echo "✅ تم تسجيل الحضور من موقع: {$nearest['name']} (المسافة ~{$nearestDistM}م)";
} else { // check_out
  if (!$attendance) { echo "ℹ️ ما عندك حضور مفتوح اليوم."; exit; }
  if (!empty($attendance['check_out'])) { echo "ℹ️ مسجل انصراف اليوم مسبقًا."; exit; }
  $sql = "UPDATE attendance
          SET check_out = ?, note = CONCAT(IFNULL(note,''), ' - انصراف من: ', ?), location_id = ?
          WHERE id = ?";
  $conn->prepare($sql)->execute([$nowDT, $nearest['name'], $nearest['id'], (int)$attendance['id']]);
  echo "✅ تم تسجيل الانصراف من موقع: {$nearest['name']} (المسافة ~{$nearestDistM}م)";
}
