<?php
session_start();
require_once '../config/db.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// التحقق من تسجيل الدخول
if (!isset($_SESSION['user'])) {
    header("Location: login.php");
    exit;
}
$stmt = $conn->prepare("
    SELECT u.id, u.name, u.email, u.employee_number, u.job_title,
           u.hire_date, u.employment_status, u.salary, u.role, u.secret_level,
           d.name AS department_name, l.name AS location_name
    FROM users AS u
    LEFT JOIN departments AS d ON u.department_id = d.id
    LEFT JOIN locations   AS l ON u.location_id   = l.id
    WHERE u.id = ?
    LIMIT 1
");
$user = $stmt->fetch(PDO::FETCH_ASSOC);

// جلب بيانات المستخدم من السيشن
$userSession = $_SESSION['user'];

// جلب بيانات المستخدم مع اسم الإدارة واسم الموقع في استعلام واحد
if (!empty($userSession['id'])) {
    $stmt = $conn->prepare("
        SELECT u.*, d.name AS department_name, l.name AS location_name
        FROM users AS u
        LEFT JOIN departments AS d ON u.department_id = d.id
        LEFT JOIN locations   AS l ON u.location_id   = l.id
        WHERE u.id = ?
        LIMIT 1
    ");
    $stmt->execute([$userSession['id']]);
} else {
    // fallback باستخدام البريد إذا لم يتوفر الـ id في الجلسة
    $stmt = $conn->prepare("
        SELECT u.*, d.name AS department_name, l.name AS location_name
        FROM users AS u
        LEFT JOIN departments AS d ON u.department_id = d.id
        LEFT JOIN locations   AS l ON u.location_id   = l.id
        WHERE u.email = ?
        LIMIT 1
    ");
    $stmt->execute([$userSession['email']]);
}

$user = $stmt->fetch(PDO::FETCH_ASSOC);

// دمج الحقول الإضافية من السيشن (مثل الألوان والصورة)
if (!empty($userSession['color'])) {
    $user['color']      = $userSession['color'];
    $user['hex_code']   = $userSession['color']['hex_code']  ?? '#fff';
    $user['text_color'] = $userSession['color']['text_color'] ?? '#333';
    $user['nav_color']  = $userSession['color']['nav_color']  ?? '#fff';
}
if (!empty($userSession['profile_image'])) {
    $user['profile_image'] = $userSession['profile_image'];
}

// تعيين اسم الإدارة والموقع من نتيجة الاستعلام
$department_name = $user['department_name'] ?? 'غير محددة';
$location_name   = $user['location_name']   ?? '-';

// بيانات الألوان
$userThemeColor     = $user['hex_code']   ?? '#fff';
$userThemeTextColor = $user['text_color'] ?? '#333';
$userThemeNavColor  = $user['nav_color']  ?? '#fff';

// سجل الإجازات
$stmt = $conn->prepare("SELECT * FROM leave_requests WHERE user_id = ? ORDER BY created_at DESC");
$stmt->execute([$user['id']]);
$leave_requests = $stmt->fetchAll(PDO::FETCH_ASSOC);

// طلبات المدير المعتمد
$stmt_approved = $conn->prepare("
    SELECT ar.*, u.name AS employee_name
    FROM asset_requests ar
    JOIN users u ON ar.user_id = u.id
    WHERE ar.approved_by_manager = ?
      AND ar.status = 'بانتظار اعتماد المدير المعتمد'
    ORDER BY ar.created_at DESC
");
$stmt_approved->execute([$user['id']]);
$approved_manager_requests = $stmt_approved->fetchAll(PDO::FETCH_ASSOC);

// طلبات المدير المختص
$stmt_manager = $conn->prepare("
    SELECT ar.*, u.name AS employee_name
    FROM asset_requests ar
    JOIN users u ON ar.user_id = u.id
    WHERE ar.assigned_manager_id = ? AND ar.status = 'بانتظار المدير المختص'
    ORDER BY ar.created_at DESC
");
$stmt_manager->execute([$user['id']]);
$manager_asset_requests = $stmt_manager->fetchAll(PDO::FETCH_ASSOC);

// طلبات العهدة الخاصة بالموظف نفسه
$stmt_assets = $conn->prepare("
    SELECT ar.*, afh.id AS form_id
    FROM asset_requests ar
    LEFT JOIN asset_hand_over_forms afh ON afh.asset_request_id = ar.id
    WHERE ar.user_id = ?
    ORDER BY ar.created_at DESC
");
$stmt_assets->execute([$user['id']]);
$my_asset_requests = $stmt_assets->fetchAll(PDO::FETCH_ASSOC);

// طلبات العهدة التي تنتظر موافقة الموظف
$stmt_my_approval = $conn->prepare("
    SELECT ar.*, afh.id AS form_id
    FROM asset_requests ar
    LEFT JOIN asset_hand_over_forms afh ON afh.asset_request_id = ar.id
    WHERE ar.user_id = ? AND ar.status = 'بانتظار موافقة الموظف'
    ORDER BY ar.created_at DESC
");
$stmt_my_approval->execute([$user['id']]);
$handover_approval_requests = $stmt_my_approval->fetchAll(PDO::FETCH_ASSOC);

// جلب تفاصيل بنود الراتب لهذا الموظف
    $stmt = $conn->prepare("
    SELECT sc.name, sc.type, esi.value, esi.notes
    FROM employee_salary_items esi
    JOIN salary_components sc ON esi.component_id = sc.id
    WHERE esi.employee_id = ?
");

$stmt->execute([$user['id']]);
$salary_items = $stmt->fetchAll(PDO::FETCH_ASSOC);

// جلب سجل الحضور آخر 7 أيام
$stmt = $conn->prepare("
    SELECT date, check_in, check_out, status
    FROM attendance
    WHERE user_id = ?
      AND date >= DATE_SUB(CURDATE(), INTERVAL 6 DAY)
    ORDER BY date DESC
");
$stmt->execute([$user['id']]);
$attendance_records = $stmt->fetchAll(PDO::FETCH_ASSOC);

// عدد المهام غير المكتملة لهذا الموظف (مسندة له وغير محذوفة ولم تُستكمل بعد)
// عدد المهام غير المكتملة (لم تُضبط completed_at وبالتالي تظل NULL) وغير محذوفة
$stmt = $conn->prepare("
  SELECT COUNT(*)
  FROM tasks
  WHERE assigned_to = ?
    AND completed_at IS NULL
    AND (is_deleted = 0 OR is_deleted IS NULL)
");
$stmt->execute([$user['id']]);
$incomplete_tasks_count = (int)$stmt->fetchColumn();

// أسماء أيام الأسبوع بالعربي
$days_ar = ['الأحد', 'الإثنين', 'الثلاثاء', 'الأربعاء', 'الخميس', 'الجمعة', 'السبت'];
// ===== إحصائيات بسيطة للواجهة =====
$leaves_count            = isset($leave_requests) ? count($leave_requests) : 0;
$my_assets_count         = isset($my_asset_requests) ? count($my_asset_requests) : 0;
$mgr_assets_count        = isset($manager_asset_requests) ? count($manager_asset_requests) : 0;
$approved_mgr_count      = isset($approved_manager_requests) ? count($approved_manager_requests) : 0;
$handover_pending_count  = isset($handover_approval_requests) ? count($handover_approval_requests) : 0;

$attended_days_7 = 0;
$today_att = null;
foreach ($attendance_records as $r) {
    if (!empty($r['check_in'])) $attended_days_7++;
    if ($r['date'] === date('Y-m-d')) $today_att = $r;
}
$today_status_text = '-';
if ($today_att) {
    if (!empty($today_att['check_in']) && empty($today_att['check_out'])) {
        $today_status_text = 'حاضر (مسجّل دخول)';
    } elseif (!empty($today_att['check_in']) && !empty($today_att['check_out'])) {
        $today_status_text = 'تم إنهاء الدوام';
    }
}

// تجهيز مسار صورة الملف الشخصي
$profile_image_path = '../assets/user.png';
if (!empty($user['profile_image'])) {
    // إذا كانت الصورة موجودة في مجلد users/img/ واُختزن اسم الملف فقط
    if (file_exists(__DIR__ . '/img/' . $user['profile_image'])) {
        $profile_image_path = 'img/' . $user['profile_image'];
    } else {
        // قد تكون القيمة مخزنة مع مسار آخر، استخدمها كما هي
        $profile_image_path = $user['profile_image'];
    }
}
$empNo            = (isset($user['employee_number']) && $user['employee_number'] !== '' && $user['employee_number'] !== null) ? htmlspecialchars($user['employee_number']) : '-';
$jobTitle         = (isset($user['job_title'])        && $user['job_title']        !== '' && $user['job_title']        !== null) ? htmlspecialchars($user['job_title'])        : '-';
$hireDate         = (isset($user['hire_date'])        && $user['hire_date']        !== '' && $user['hire_date']        !== null) ? htmlspecialchars($user['hire_date'])        : '-';
$employmentStatus = (isset($user['employment_status'])&& $user['employment_status']!== '' && $user['employment_status']!== null) ? htmlspecialchars($user['employment_status']) : '-';
$salary           = (isset($user['salary'])           && $user['salary']           !== '' && $user['salary']           !== null) ? number_format($user['salary'], 2) . ' ريال' : '-';


?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>الملف الشخصي</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
    body, .main-card, tr:hover, a:hover { background-color: <?php echo $userThemeColor; ?> !important; }
    nav, .select2-results__option, .select2-search, .select2-selection--multiple, li, .card { background-color: <?php echo $userThemeNavColor; ?> !important; }
    .text, label, h3, option, h2, th, td, li, strong, select, input, a { color: <?php echo $userThemeTextColor; ?> !important; }
    option { text-align: center; }
    </style>
</head>
<body class="text-right">
<?php include $_SERVER['DOCUMENT_ROOT'] . '/erp_task_system/navbar/navbar.php'; ?>

<!-- حاوية عمودين: يمين (الملف الشخصي) ويسار (الإحصائيات) -->
<div class="max-w-6xl mx-auto grid grid-cols-1 md:grid-cols-5 gap-6 items-start">

  <!-- يمين: كرت الملف الشخصي -->
  <div class="card p-6 rounded shadow-md w-full md:col-span-2">
    <h2 class="text-2xl font-bold mb-4 text-center">الملف الشخصي</h2>

    <div class="mb-6 flex justify-center">
      <img src="<?= htmlspecialchars($profile_image_path) ?>" alt="صورة الموظف" class="w-32 h-32 rounded-full object-cover border shadow-md">
    </div>

    <div class="grid grid-cols-3 gap-y-4 text-sm mb-6">
      <!-- الصف الأول -->
      <div>
        <div class="font-semibold">الاسم</div>
        <div><?= htmlspecialchars($user['name'] ?? '-') ?></div>
      </div>
      <div>
        <div class="font-semibold">الرقم الوظيفي</div>
        <div><?= $empNo ?></div>
      </div>
      <div>
        <div class="font-semibold">البريد الإلكتروني</div>
        <div><?= htmlspecialchars($user['email'] ?? '-') ?></div>
      </div>

      <!-- الصف الثاني -->
      <div>
        <div class="font-semibold">الصلاحية</div>
        <div><?= htmlspecialchars($user['role'] ?? '-') ?></div>
      </div>
      <div>
        <div class="font-semibold">الإدارة</div>
        <div><?= htmlspecialchars($department_name) ?></div>
      </div>
      <div>
        <div class="font-semibold">المسمى الوظيفي</div>
        <div><?= $jobTitle ?></div>
      </div>

      <!-- الصف الثالث -->
      <div>
        <div class="font-semibold">تاريخ التوظيف</div>
        <div><?= $hireDate ?></div>
      </div>
      <div>
        <div class="font-semibold">الحالة الوظيفية</div>
        <div><?= $employmentStatus ?></div>
      </div>
      <div>
        <div class="font-semibold">الموقع</div>
        <div><?= htmlspecialchars($location_name) ?></div>
      </div>

      <!-- الصف الرابع -->
      <div>
        <div class="font-semibold">درجة السرية</div>
        <div>
          <?php
          echo match ($user['secret_level'] ?? '') {
              'normal'     => 'عادية',
              'secret'     => 'سرية',
              'top_secret' => 'سرية جدًا',
              default      => '-',
          };
          ?>
        </div>
      </div>
    </div>

    <!-- الأزرار نخليها نفس ما هي -->
    <div class="text-center my-4">
      <button id="checkInBtn" onclick="getLocationAndSend('check_in')" class="bg-green-600 text-white px-6 py-2 rounded hover:bg-green-700">تسجيل حضور</button>
      <button id="checkOutBtn" onclick="getLocationAndSend('check_out')" class="bg-blue-600 text-white px-6 py-2 rounded hover:bg-blue-700">تسجيل انصراف</button>
    </div>
    <div id="attendanceMsg" class="text-center mt-2"></div>

    <div class="mb-4 text mt-4 text-center">
      <a href="request_leave.php" class="text-blue-600 hover:underline">➕ تقديم طلب إجازة جديد</a>
    </div>
    <div class="mb-4 text mt-4 text-center">
      <a href="request_asset.php" class="text-blue-600 hover:underline">➕ رفع طلب عهدة جديدة</a>
    </div>
    <!-- داخل الكرت (يمين)، بعد روابط الإجازة/العهدة -->
<a href="logout.php"
   class="mt-2 block w-full text-center bg-red-600 text-white py-3 rounded hover:bg-red-700"
   style="background-color: rgb(220 38 38 / var(--tw-bg-opacity, 1)) !important;">
  تسجيل الخروج
</a>

  </div>

  <!-- يسار: كرت الإحصائيات البسيط -->
  <div class="card p-6 rounded shadow-md w-full md:col-span-3">
    <h2 class="text-xl font-bold mb-4">📊 إحصائيات مختصرة</h2>

<div class="grid grid-cols-2 gap-4 text-sm">
  <div class="border rounded p-3 text-center">
    <div class="text-xs opacity-80">حضور آخر 7 أيام</div>
    <div class="text-2xl font-bold"><?= (int)$attended_days_7 ?></div>
  </div>

  <div class="border rounded p-3 text-center">
    <div class="text-xs opacity-80">الإجازات المقدّمة</div>
    <div class="text-2xl font-bold"><?= (int)$leaves_count ?></div>
  </div>

  <div class="border rounded p-3 text-center">
    <div class="text-xs opacity-80">عهدتي</div>
    <div class="text-2xl font-bold"><?= (int)$my_assets_count ?></div>
  </div>

  <div class="border rounded p-3 text-center">
    <div class="text-xs opacity-80">المعاملات الغير مكتملة</div>
    <div class="text-2xl font-bold"><?= (int)$incomplete_tasks_count ?></div>
  </div>
</div>
      
    </div>

    <ul class="mt-4 text-sm list-disc pr-5">
      <li>حالة اليوم: <strong><?= htmlspecialchars($today_status_text) ?></strong></li>
      <?php if ($today_att && !empty($today_att['check_in'])): ?>
        <li>آخر دخول: <strong><?= htmlspecialchars($today_att['check_in']) ?></strong></li>
      <?php endif; ?>
      <?php if ($today_att && !empty($today_att['check_out'])): ?>
        <li>آخر خروج: <strong><?= htmlspecialchars($today_att['check_out']) ?></strong></li>
      <?php endif; ?>
    </ul>
  </div>



</div>
<!-- نهاية الحاوية ذات العمودين -->
    <div id="attendanceMsg" class="text-center mt-2"></div>
    <script>
    function getLocationAndSend(type) {
        if (!navigator.geolocation) {
            document.getElementById('attendanceMsg').textContent = 'المتصفح لا يدعم تحديد الموقع!';
            return;
        }
        navigator.geolocation.getCurrentPosition(function(pos) {
            var lat = pos.coords.latitude;
            var lng = pos.coords.longitude;
            recordAttendance(type, lat, lng);
        }, function() {
            document.getElementById('attendanceMsg').textContent = 'فشل في الحصول على الموقع، فعّل GPS!';
        });
    }

    function recordAttendance(type, lat=null, lng=null) {
        if (lat === null || lng === null) {
            getLocationAndSend(type);
            return;
        }
        var form = new FormData();
        form.append('type', type);
        form.append('lat', lat);
        form.append('lng', lng);

        fetch('mark_attendance.php', {
            method: 'POST',
            body: form
        })
        .then(res => res.text())
        .then(msg => {
            document.getElementById('attendanceMsg').textContent = msg;
            if (msg.includes('✅') || msg.includes('تم تسجيل')) {
                updateAttendanceButtons();
                setTimeout(() => window.location.reload(), 1000);
            }
        });
    }

    function updateAttendanceButtons() {
        <?php
        $today_attendance = null;
        foreach ($attendance_records as $row) {
            if ($row['date'] == date('Y-m-d')) {
                $today_attendance = $row;
                break;
            }
        }
        ?>
        var att = <?= json_encode($today_attendance) ?>;
        document.getElementById('checkInBtn').disabled  = !!(att && att.check_in);
        document.getElementById('checkOutBtn').disabled = !(att && att.check_in) || !!(att && att.check_out);
    }
    updateAttendanceButtons();
    </script>


<?php if (!empty($manager_asset_requests)): ?>
<div class="bg-white mt-8 p-6 rounded shadow-md max-w-4xl mx-auto">
    <h2 class="text-xl font-bold mb-4">📦 طلبات العهدة الموجهة لي</h2>
    <div class="overflow-x-auto">
        <table class="w-full text-sm card border rounded">
            <thead class="card text-gray-700">
                <tr>
                    <th class="px-4 py-2">الموظف</th>
                    <th class="px-4 py-2">نوع العهدة</th>
                    <th class="px-4 py-2">تفاصيل</th>
                    <th class="px-4 py-2">الحالة</th>
                    <th class="px-4 py-2">التاريخ</th>
                    <th class="px-4 py-2">الإجراءات</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($manager_asset_requests as $asset): ?>
                <tr>
                    <td class="px-4 py-2"><?= htmlspecialchars($asset['employee_name']) ?></td>
                    <td class="px-4 py-2"><?= htmlspecialchars($asset['asset_type_name']) ?></td>
                    <td class="px-4 py-2"><?= nl2br(htmlspecialchars($asset['details'])) ?></td>
                    <td class="px-4 py-2"><?= htmlspecialchars($asset['status']) ?></td>
                    <td class="px-4 py-2"><?= $asset['created_at'] ?></td>
                    <td class="px-4 py-2">
                        <?php if ($asset['status'] == 'بانتظار المدير المختص'): ?>
                            <a href="fill_asset_handover_form.php?id=<?= $asset['id'] ?>" class="bg-blue-600 text-white px-3 py-1 rounded text-xs block mb-1 text-center hover:bg-blue-700">
                                تعبئة نموذج العهدة
                            </a>
                            <form method="POST" action="update_asset_status.php" style="display:inline;">
                                <input type="hidden" name="id" value="<?= $asset['id'] ?>">
                                <button name="action" value="reject" class="bg-red-600 text-white px-3 py-1 rounded text-xs">رفض</button>
                            </form>
                        <?php elseif ($asset['status'] == 'بانتظار التنفيذ'): ?>
                            <form method="POST" action="update_asset_status.php" style="display:inline;">
                                <input type="hidden" name="id" value="<?= $asset['id'] ?>">
                                <button name="action" value="ready" class="bg-blue-600 text-white px-3 py-1 rounded text-xs">تجهيز العهدة</button>
                            </form>
                        <?php else: ?>
                            —
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>
<?php endif; ?>

<?php if (!empty($approved_manager_requests)): ?>
<div class="bg-white mt-8 p-6 rounded shadow-md max-w-4xl mx-auto">
    <h2 class="text-xl font-bold mb-4">📝 طلبات العهدة بانتظار اعتمادي كمدير معتمد</h2>
    <div class="overflow-x-auto">
        <table class="w-full text-sm card border rounded">
            <thead class="card text-gray-700">
                <tr>
                    <th class="px-4 py-2">الموظف</th>
                    <th class="px-4 py-2">نوع العهدة</th>
                    <th class="px-4 py-2">تفاصيل</th>
                    <th class="px-4 py-2">الحالة</th>
                    <th class="px-4 py-2">التاريخ</th>
                    <th class="px-4 py-2">الإجراءات</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($approved_manager_requests as $asset): ?>
                <tr>
                    <td class="px-4 py-2"><?= htmlspecialchars($asset['employee_name']) ?></td>
                    <td class="px-4 py-2"><?= htmlspecialchars($asset['asset_type_name']) ?></td>
                    <td class="px-4 py-2"><?= nl2br(htmlspecialchars($asset['details'])) ?></td>
                    <td class="px-4 py-2"><?= htmlspecialchars($asset['status']) ?></td>
                    <td class="px-4 py-2"><?= $asset['created_at'] ?></td>
                    <td class="px-4 py-2">
                        <?php if (in_array($asset['status'], ['بانتظار اعتماد المدير', 'بانتظار اعتماد المدير المعتمد'])): ?>
                            <form method="POST" action="update_asset_status.php" style="display:inline;">
                                <input type="hidden" name="id" value="<?= $asset['id'] ?>">
                                <button name="action" value="accept" class="bg-green-600 text-white px-3 py-1 rounded text-xs">اعتماد</button>
                                <button name="action" value="reject" class="bg-red-600 text-white px-3 py-1 rounded text-xs">رفض</button>
                            </form>
                        <?php elseif ($asset['status'] == 'بانتظار التنفيذ'): ?>
                            <form method="POST" action="update_asset_status.php" style="display:inline;">
                                <input type="hidden" name="id" value="<?= $asset['id'] ?>">
                                <button name="action" value="ready" class="bg-blue-600 text-white px-3 py-1 rounded text-xs">تجهيز العهدة</button>
                            </form>
                        <?php else: ?>
                            —
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>
<?php endif; ?>

<?php if (!empty($handover_approval_requests)): ?>
<div class="bg-white mt-8 p-6 rounded shadow-md max-w-4xl mx-auto">
    <h2 class="text-xl font-bold mb-4">📜 العهد المطلوب موافقتك عليها</h2>
    <div class="overflow-x-auto">
        <table class="w-full text-sm card border rounded">
            <thead class="card text-gray-700">
                <tr>
                    <th class="px-4 py-2">نوع العهدة</th>
                    <th class="px-4 py-2">تفاصيل</th>
                    <th class="px-4 py-2">الرقم التسلسلي</th>
                    <th class="px-4 py-2">القيمة</th>
                    <th class="px-4 py-2">المرفق</th>
                    <th class="px-4 py-2">تاريخ التسليم</th>
                    <th class="px-4 py-2">الإجراءات</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($handover_approval_requests as $req): ?>
                <tr>
                    <td class="px-4 py-2"><?= htmlspecialchars($req['asset_type_name'] ?? '') ?></td>
                    <td class="px-4 py-2"><?= htmlspecialchars($req['details'] ?? '') ?></td>
                    <td class="px-4 py-2"><?= htmlspecialchars($req['serial_number'] ?? '-') ?></td>
                    <td class="px-4 py-2"><?= htmlspecialchars($req['price'] ?? '-') ?></td>
                    <td class="px-4 py-2">
                        <?php if (!empty($req['invoice_filename'])): ?>
                        <a href="../users/employee_files/<?= htmlspecialchars($user['employee_number']) ?>/<?= htmlspecialchars($req['invoice_filename']) ?>" target="_blank" class="text-blue-600 underline">عرض الفاتورة</a>
                        <?php else: ?> — <?php endif; ?>
                    </td>
                    <td class="px-4 py-2"><?= htmlspecialchars($req['handover_date'] ?? '-') ?></td>
                    <td class="px-4 py-2 text-center">
                        <?php if (!empty($req['form_id'])): ?>
                        <a href="view_asset_handover_form.php?id=<?= $req['form_id'] ?>" target="_blank" class="bg-gray-600 text-white px-3 py-1 rounded text-xs hover:bg-gray-700">عرض النموذج</a>
                        <form method="post" action="employee_asset_action.php" style="display:inline-block; margin-right:5px;">
                            <input type="hidden" name="request_id" value="<?= $req['id'] ?>">
                            <button name="action" value="accept" class="bg-green-600 text-white px-3 py-1 rounded text-xs">موافقة</button>
                            <button name="action" value="reject" class="bg-red-600 text-white px-3 py-1 rounded text-xs">رفض</button>
                        </form>
                        <?php else: ?> — <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>
<?php endif; ?>


<!-- سجل الإجازات -->
<div class="bg-white mt-8 p-6 rounded shadow-md max-w-4xl mx-auto">
    <h2 class="text-xl font-bold mb-4">🗂️ سجل الإجازات</h2>
    <?php if (empty($leave_requests)): ?>
        <p class="text-gray-500 text-sm">لا توجد طلبات إجازة حتى الآن.</p>
    <?php else: ?>
    <div class="overflow-x-auto">
        <table class="w-full text-sm card border rounded">
            <thead class="card text-gray-700">
                <tr>
                    <th class="px-4 py-2">النوع</th>
                    <th class="px-4 py-2">من</th>
                    <th class="px-4 py-2">إلى</th>
                    <th class="px-4 py-2">السبب</th>
                    <th class="px-4 py-2">الحالة النهائية</th>
                    <th class="px-4 py-2">قرار المدير</th>
                    <th class="px-4 py-2">ملاحظة المدير</th>
                    <th class="px-4 py-2">قرار الموارد</th>
                    <th class="px-4 py-2">ملاحظة الموارد</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($leave_requests as $req): ?>
                <tr class="border-b">
                    <td class="px-4 py-2"><?= htmlspecialchars($req['type']) ?></td>
                    <td class="px-4 py-2"><?= $req['start_date'] ?></td>
                    <td class="px-4 py-2"><?= $req['end_date'] ?></td>
                    <td class="px-4 py-2"><?= nl2br(htmlspecialchars($req['reason'])) ?></td>
                    <td class="px-4 py-2 font-semibold <?= $req['status'] === 'في إجازة' ? 'text-green-600' : ($req['status'] === 'مرفوضة' ? 'text-red-600' : 'text-gray-600') ?>"><?= $req['status'] ?></td>
                    <td class="px-4 py-2 text-sm <?= $req['manager_status'] === 'مرفوضة' ? 'text-red-600' : ($req['manager_status'] === 'مقبولة' ? 'text-green-600' : 'text-gray-500') ?>">
                        <?= $req['manager_status'] ?? '—' ?>
                    </td>
                    <td class="px-4 py-2 text-xs"><?= nl2br(htmlspecialchars($req['manager_note'] ?? '')) ?></td>
                    <td class="px-4 py-2 text-sm <?= $req['hr_status'] === 'مرفوضة' ? 'text-red-600' : ($req['hr_status'] === 'مقبولة' ? 'text-green-600' : 'text-gray-500') ?>">
                        <?= $req['hr_status'] ?? '—' ?>
                    </td>
                    <td class="px-4 py-2 text-xs"><?= nl2br(htmlspecialchars($req['hr_note'] ?? '')) ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <?php endif; ?>
</div>

<?php if (!empty($salary_items)): ?>
<div class="bg-white mt-8 p-6 rounded shadow-md max-w-2xl mx-auto">
    <h2 class="text-xl font-bold mb-4">💰 تفاصيل الراتب</h2>
    <div class="overflow-x-auto">
        <table class="w-full text-sm card border rounded">
            <thead class="card text-gray-700">
                <tr>
                    <th class="px-4 py-2">البند</th>
                    <th class="px-4 py-2">القيمة (ريال)</th>
                    <th class="px-4 py-2">ملاحظات</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $salary_total = 0;
                foreach ($salary_items as $item):
                    // احسب الراتب الصافي: اطرح قيمة الخصومات وأضف قيمة العلاوات
                    $value = floatval($item['value']);
                    if ($item['type'] === 'deduction') {
                        $salary_total -= $value;
                    } else {
                        $salary_total += $value;
                    }
                ?>
                <tr>
                    <td class="px-4 py-2"><?= htmlspecialchars($item['name']) ?></td>
                    <td class="px-4 py-2"><?= number_format($value, 2) ?></td>
                    <td class="px-4 py-2"><?= htmlspecialchars($item['notes']) ?></td>
                </tr>
                <?php endforeach; ?>
                <tr class="bg-gray-100 font-bold">
                    <td class="px-4 py-2">الإجمالي</td>
                    <td class="px-4 py-2"><?= number_format($salary_total, 2) ?></td>
                    <td class="px-4 py-2"></td>
                </tr>
            </tbody>
        </table>
    </div>
</div>
<?php endif; ?>

<div class="bg-white mt-8 p-6 rounded shadow-md max-w-2xl mx-auto">
    <h2 class="text-xl font-bold mb-4">⏰ سجل الحضور (آخر أسبوع)</h2>
    <div class="overflow-x-auto">
        <table class="w-full text-sm card border rounded">
            <thead class="card text-gray-700">
                <tr>
                    <th class="px-4 py-2">اليوم</th>
                    <th class="px-4 py-2">التاريخ</th>
                    <th class="px-4 py-2">دخول</th>
                    <th class="px-4 py-2">خروج</th>
                    <th class="px-4 py-2">الحالة</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($attendance_records as $rec): ?>
                <tr>
                    <td class="px-4 py-2"><?= $days_ar[date('w', strtotime($rec['date']))] ?></td>
                    <td class="px-4 py-2"><?= $rec['date'] ?></td>
                    <td class="px-4 py-2"><?= $rec['check_in'] ?: '-' ?></td>
                    <td class="px-4 py-2"><?= $rec['check_out'] ?: '-' ?></td>
                    <td class="px-4 py-2"><?= $rec['status'] ?: '-' ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php if (!empty($my_asset_requests)): ?>
<div class="bg-white mt-8 p-6 rounded shadow-md max-w-4xl mx-auto">
    <h2 class="text-xl font-bold mb-4">🛠️ العهد التي رفعتها</h2>
    <div class="overflow-x-auto">
        <table class="w-full text-sm card border rounded">
            <thead class="card text-gray-700">
                <tr>
                    <th class="px-4 py-2">نوع العهدة</th>
                    <th class="px-4 py-2">تفاصيل</th>
                    <th class="px-4 py-2">الحالة</th>
                    <th class="px-4 py-2">تاريخ الطلب</th>
                    <th class="px-4 py-2">نموذج العهدة</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($my_asset_requests as $req): ?>
                <tr>
                    <td class="px-4 py-2"><?= htmlspecialchars($req['asset_type_name'] ?? '-') ?></td>
                    <td class="px-4 py-2"><?= htmlspecialchars($req['details'] ?? '-') ?></td>
                    <td class="px-4 py-2"><?= htmlspecialchars($req['status'] ?? '-') ?></td>
                    <td class="px-4 py-2"><?= htmlspecialchars($req['created_at'] ?? '-') ?></td>
                    <td class="px-4 py-2 text-center">
                        <?php if (!empty($req['form_id'])): ?>
                        <a href="view_asset_handover_form.php?id=<?= $req['form_id'] ?>" target="_blank" class="bg-gray-600 text-white px-3 py-1 rounded text-xs hover:bg-gray-700">عرض النموذج</a>
                        <?php else: ?>
                        —
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>
<?php endif; ?>

</body>
</html>