<?php
session_start();
require_once '../../config/db.php';
require_once '../auth.php'; // عدّل المسار إذا لزم

ini_set('display_errors',1); error_reporting(E_ALL);

// صلاحيات
if (!isset($_SESSION['user'])) { http_response_code(403); exit('Not authorized'); }

// Params
$payroll_id = (int)($_GET['payroll_id'] ?? 0);
$month      = (int)($_GET['month'] ?? date('n'));
$year       = (int)($_GET['year']  ?? date('Y'));
$doSnapshot = (int)($_GET['snapshot'] ?? 0); // 1 = يحدّث سناب-شوت بنك/هوية

if ($payroll_id <= 0) exit('payroll_id required');

// ===== Helpers =====
function setting(PDO $c, $k, $def){ $s=$c->prepare("SELECT setting_value FROM payroll_settings WHERE setting_key=?"); $s->execute([$k]); $r=$s->fetch(PDO::FETCH_ASSOC); return $r? (is_numeric($r['setting_value'])? (float)$r['setting_value'] : $r['setting_value']) : $def; }
function get_base_component_id(PDO $c): int { $s=$c->query("SELECT id FROM salary_components WHERE type='basic' LIMIT 1"); $r=$s->fetch(PDO::FETCH_ASSOC); return $r?(int)$r['id']:0; }
function get_base_salary(PDO $c, int $emp_id, int $base_cid): float {
  $s=$c->prepare("SELECT value FROM employee_salary_items WHERE employee_id=? AND component_id=? LIMIT 1"); $s->execute([$emp_id,$base_cid]);
  $r=$s->fetch(PDO::FETCH_ASSOC); return (float)($r['value']??0);
}
function month_bounds(int $m,int $y): array {
  $num=cal_days_in_month(CAL_GREGORIAN,$m,$y); $Y=(int)date('Y'); $M=(int)date('n'); $D=(int)date('j');
  if($y>$Y || ($y==$Y && $m>$M)) return [0,0,true];
  $last=$num; if($y==$Y && $m==$M) $last=max(0,$D-1); return [$num,$last,false];
}
function get_work_weekdays(PDO $c,int $emp_id): array {
  $s=$c->prepare("SELECT department_id,day_off FROM users WHERE id=?"); $s->execute([$emp_id]); $u=$s->fetch(PDO::FETCH_ASSOC);
  $dept=(int)($u['department_id']??0); $day_off=$u['day_off']??null;
  $s=$c->prepare("SELECT day_of_week FROM department_work_days WHERE department_id=? AND is_working=1"); $s->execute([$dept]);
  $names=$s->fetchAll(PDO::FETCH_COLUMN);
  $map=['monday'=>1,'tuesday'=>2,'wednesday'=>3,'thursday'=>4,'friday'=>5,'saturday'=>6,'sunday'=>7];
  $wd=[]; foreach($names as $n){ $l=strtolower(trim($n)); if(isset($map[$l])) $wd[]=$map[$l]; }
  if($day_off!==null && $day_off!=='') $wd=array_values(array_diff($wd,[(int)$day_off]));
  return $wd;
}
function get_leave_dates(PDO $c,int $emp_id,int $m,int $y,int $last): array {
  if($last<=0) return [];
  $q=$c->prepare("SELECT start_date,end_date FROM leave_requests
                  WHERE user_id=? AND status='مقبولة' AND (
                    (MONTH(start_date)=? AND YEAR(start_date)=?) OR
                    (MONTH(end_date)=? AND YEAR(end_date)=?) OR
                    (start_date<=LAST_DAY(CONCAT(?, '-', ?, '-01')) AND end_date>=CONCAT(?, '-', ?, '-01'))
                  )");
  $q->execute([$emp_id,$m,$y,$m,$y,$y,$m,$y,$m]);
  $rows=$q->fetchAll(PDO::FETCH_ASSOC);
  $from=new DateTime(sprintf('%04d-%02d-01',$y,$m)); $to=new DateTime(sprintf('%04d-%02d-%02d',$y,$m,$last));
  $dates=[]; foreach($rows as $lv){ try{$s=new DateTime($lv['start_date']);$e=new DateTime($lv['end_date']);}catch(Exception $e){continue;}
    if($s<$from)$s=clone $from; if($e>$to)$e=clone $to; while($s<=$e){ $dates[]=$s->format('Y-m-d'); $s->modify('+1 day'); } }
  return $dates;
}
function get_shift_times(PDO $c,int $emp_id): array {
  $q=$c->prepare("SELECT ws.start_time,ws.end_time FROM users u LEFT JOIN work_shifts ws ON ws.id=u.work_shift_id WHERE u.id=?");
  $q->execute([$emp_id]); $r=$q->fetch(PDO::FETCH_ASSOC)?:[]; return [($r['start_time']??'08:00:00')?:'08:00:00', ($r['end_time']??'16:00:00')?:'16:00:00'];
}
function get_month_attendance(PDO $c,int $emp_id,int $m,int $y): array {
  $q=$c->prepare("SELECT DATE(`date`) AS day, MIN(TIME(`check_in`)) AS in_time, MAX(TIME(`check_out`)) AS out_time, MAX(status) AS status
                  FROM attendance WHERE user_id=? AND MONTH(`date`)=? AND YEAR(`date`)=? GROUP BY DATE(`date`) ORDER BY day");
  $q->execute([$emp_id,$m,$y]); $out=[]; while($r=$q->fetch(PDO::FETCH_ASSOC)){ $worked=0; if($r['in_time'] && $r['out_time']) $worked=max(0,(int)round((strtotime($r['out_time'])-strtotime($r['in_time']))/60)); $r['worked_minutes']=$worked; $out[$r['day']]=$r; }
  return $out;
}
function get_employee_absent_days(PDO $c,int $emp_id,int $m,int $y,int $halfM): float {
  [$_,$last,$future]=month_bounds($m,$y); if($future||$last<=0) return 0.0;
  $wd=get_work_weekdays($c,$emp_id); $att=get_month_attendance($c,$emp_id,$m,$y); $lv=get_leave_dates($c,$emp_id,$m,$y,$last);
  $abs=0.0; for($d=1;$d<=$last;$d++){ $date=sprintf('%04d-%02d-%02d',$y,$m,$d); $dow=(int)date('N',strtotime($date));
    if(!in_array($dow,$wd,true)) continue; if(in_array($date,$lv,true)) continue; $row=$att[$date]??null;
    if(!$row){ $abs+=1.0; continue; } $worked=(int)($row['worked_minutes']??0); if($worked<$halfM) $abs+=0.5;
  } return $abs;
}

// يحسب ملخص الحضور/الخصومات/الإضافي
function calcAttendanceSummary(PDO $conn,int $emp_id,int $month,int $year): array {
  $halfDayMinutes=(int)setting($conn,'half_day_minutes',240);
  $workDaysMonth =(int)setting($conn,'work_days_month',30);
  $workHoursDay  =(int)setting($conn,'work_hours_day',8);
  $rate_working  =(float)setting($conn,'ot_rate_working',1.5);
  $rate_offday   =(float)setting($conn,'ot_rate_offday',2.0);

  [$num,$last,$future]=month_bounds($month,$year); if($future || $last<=0) return [0,0,0,0,0,0,0,0];

  $base_cid = get_base_component_id($conn);
  $baseSalary = get_base_salary($conn,$emp_id,$base_cid);
  $salaryDay  = $workDaysMonth ? ($baseSalary / $workDaysMonth) : 0;
  $dedPerAbs  = $salaryDay * 1.5;
  $dedPerHour = $workHoursDay ? ($dedPerAbs / $workHoursDay) : 0;
  $hourly     = ($workDaysMonth && $workHoursDay) ? $baseSalary / ($workDaysMonth * $workHoursDay) : 0;

  [$shift_start,$shift_end]=get_shift_times($conn,$emp_id);
  $weekdays = get_work_weekdays($conn,$emp_id);
  $att      = get_month_attendance($conn,$emp_id,$month,$year);
  $leaves   = get_leave_dates($conn,$emp_id,$month,$year,$last);

  $total_late_minutes=0; $total_late_deduction=0;
  $ot_work_mins=0; $ot_off_mins=0; $ot_work_amount=0.0; $ot_off_amount=0.0;

  for($d=1;$d<=$last;$d++){
    $date=sprintf('%04d-%02d-%02d',$year,$month,$d); $dow=(int)date('N',strtotime($date));
    $row=$att[$date]??null; $in=$row['in_time']??null; $out=$row['out_time']??null; $worked=(int)($row['worked_minutes']??0);

    // يوم غير عمل
    if(!in_array($dow,$weekdays,true)){
      if($row && $worked>0){
        $ot_m=$worked; $ot_amt = ($hourly*$rate_offday)*($ot_m/60);
        $ot_off_mins += $ot_m; $ot_off_amount += $ot_amt;
      }
      continue;
    }
    // إجازة
    if(in_array($date,$leaves,true)) continue;
    // غياب كامل
    if(!$row) continue;
    // نص يوم؟
    if($worked<$halfDayMinutes) continue;

    // تأخير
    if($in && $in>$shift_start && in_array(($row['status']??''),['حاضر','متأخر'],true)){
      $mins=(int)round((strtotime($in)-strtotime($shift_start))/60);
      if($mins>0){ $total_late_minutes += $mins; $total_late_deduction += $dedPerHour*($mins/60); }
    }

    // OT يوم عمل (بعد نهاية الشفت وبسقف ساعات اليوم)
    if($out && strtotime($out)>strtotime($shift_end)){
      $after_end = (int)round((strtotime($out)-strtotime($shift_end))/60);
      $cap       = max(0, $worked - ($workHoursDay*60));
      $ot_m      = max(0, min($after_end,$cap));
      if($ot_m>0){ $ot_work_mins += $ot_m; $ot_work_amount += ($hourly*$rate_working)*($ot_m/60); }
    }
  }

  $absentDays = get_employee_absent_days($conn,$emp_id,$month,$year,$halfDayMinutes);
  $absenceDed = $absentDays * $dedPerAbs;

  return [
    $total_late_minutes,    // 0
    round($total_late_deduction,2), // 1
    $absentDays,            // 2
    round($absenceDed,2),   // 3
    $ot_work_mins,          // 4
    $ot_off_mins,           // 5
    round($ot_work_amount,2), // 6
    round($ot_off_amount,2)   // 7
  ];
}

// === ابدأ العمل على المسير
// جهّز مكوّناتنا
function compId(PDO $c, $code){ $s=$c->prepare("SELECT id FROM salary_components WHERE code=? LIMIT 1"); $s->execute([$code]); $r=$s->fetch(PDO::FETCH_ASSOC); return $r?(int)$r['id']:0; }
$CID_LATE = compId($conn,'LATE_DED');
$CID_ABS  = compId($conn,'ABSENCE_DED');
$CID_OTW  = compId($conn,'OT_WORK');
$CID_OTO  = compId($conn,'OT_OFF');

// بنجيب عناصر المسير
$q = $conn->prepare("SELECT id AS payroll_item_id, user_id FROM payroll_items WHERE payroll_id=?");
$q->execute([$payroll_id]);
$items = $q->fetchAll(PDO::FETCH_ASSOC);
if(!$items){ exit('لا يوجد عناصر في هذا المسير'); }

// نحذف القيود القديمة لهالمكونات ثم نضيف الجديدة (عشان ما يتكرر)
$del = $conn->prepare("DELETE pic FROM payroll_item_components pic JOIN salary_components sc ON sc.id=pic.component_id WHERE pic.payroll_item_id=? AND sc.code IN ('LATE_DED','ABSENCE_DED','OT_WORK','OT_OFF')");
$ins = $conn->prepare("INSERT INTO payroll_item_components (payroll_item_id, component_id, amount) VALUES (?,?,?)");

$count=0;
foreach($items as $it){
  $emp_id = (int)$it['user_id'];
  [$lateM,$lateDed,$absDays,$absDed,$otWM,$otOM,$otWA,$otOA] = calcAttendanceSummary($conn,$emp_id,$month,$year);

  $del->execute([$it['payroll_item_id']]);

  if($CID_LATE) $ins->execute([$it['payroll_item_id'],$CID_LATE,$lateDed]);
  if($CID_ABS ) $ins->execute([$it['payroll_item_id'],$CID_ABS ,$absDed ]);
  if($CID_OTW ) $ins->execute([$it['payroll_item_id'],$CID_OTW ,$otWA  ]);
  if($CID_OTO ) $ins->execute([$it['payroll_item_id'],$CID_OTO ,$otOA  ]);

  // خزّن absent_days في payroll_items (مفيد للتقارير)
  $u = $conn->prepare("UPDATE payroll_items SET absent_days=? WHERE id=?");
  $u->execute([$absDays, $it['payroll_item_id']]);

  $count++;
}

// حدّث إجماليات المسير من تفاصيل البنود
$agg = $conn->prepare("
  UPDATE payroll_items pi
  JOIN (
    SELECT pc.payroll_item_id,
           SUM(CASE WHEN sc.type='basic' THEN pc.amount ELSE 0 END) AS base_salary,
           SUM(CASE WHEN sc.type IN ('allowance','earning') THEN pc.amount ELSE 0 END) AS total_allowances,
           SUM(CASE WHEN sc.type='deduction' THEN pc.amount ELSE 0 END) AS total_deductions,
           SUM(CASE WHEN sc.type='overtime' THEN pc.amount ELSE 0 END) AS overtime_total
    FROM payroll_item_components pc
    JOIN salary_components sc ON sc.id=pc.component_id
    JOIN payroll_items pi2 ON pi2.id=pc.payroll_item_id
    WHERE pi2.payroll_id=?
    GROUP BY pc.payroll_item_id
  ) x ON x.payroll_item_id=pi.id
  SET pi.base_salary=x.base_salary,
      pi.total_allowances=x.total_allowances,
      pi.total_deductions=x.total_deductions,
      pi.overtime_total=x.overtime_total,
      pi.net_salary = x.base_salary + x.total_allowances + x.overtime_total - x.total_deductions
");
$agg->execute([$payroll_id]);

// سناب-شوت البنك/الهوية (اختياري)
if($doSnapshot){
  $snap=$conn->prepare("
    UPDATE payroll_items pi
    JOIN users u ON u.id=pi.user_id
    SET pi.snapshot_name            = u.name,
        pi.snapshot_employee_number = u.employee_number,
        pi.snapshot_national_id     = u.national_id,
        pi.snapshot_bank_account    = u.bank_account,
        pi.snapshot_iban            = u.iban,
        pi.snapshot_currency        = COALESCE(u.salary_currency,'AED')
    WHERE pi.payroll_id=?
  ");
  $snap->execute([$payroll_id]);
}

header('Content-Type: application/json; charset=utf-8');
echo json_encode(['ok'=>true,'updated_items'=>$count,'payroll_id'=>$payroll_id,'month'=>$month,'year'=>$year,'snapshot'=>$doSnapshot]);
