<?php
session_start();
require_once '../config/db.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (!isset($_SESSION['user'])) {
    header("Location: login.php");
    exit;
}

$user = $_SESSION['user'];
$user_id = $user['id'];
$color = $user['color'];
$userThemeColor = $color['hex_code'];
$userThemeTextColor = $color['text_color'];
$userThemeNavColor = $color['nav_color'];

// متغيرات افتراضية للقيم
$asset_type_name = '';
$details = '';
$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $asset_type_name = trim($_POST['asset_type_name'] ?? '');
    $details = trim($_POST['details'] ?? '');

    if ($asset_type_name == '') {
        $error = "يجب كتابة نوع العهدة.";
    } else {
        $status = 'بانتظار الموارد البشرية';
        $stmt = $conn->prepare("INSERT INTO asset_requests (user_id, asset_type_name, details, status) VALUES (?, ?, ?, ?)");
        if ($stmt->execute([$user_id, $asset_type_name, $details, $status])) {
            $success = "✅ تم رفع طلب العهدة بنجاح!";
            $asset_type_name = '';
            $details = '';
        } else {
            $error = "❌ حصل خطأ أثناء رفع الطلب. حاول مرة أخرى.";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>رفع طلب عهدة</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
    body, .main-card, tr:hover, a:hover {background-color: <?= $userThemeColor ?> !important;}
    nav, .select2-results__option, .select2-search, .select2-selection--multiple, li, .card {
        background-color: <?= $userThemeNavColor ?> !important;}
    .text, label, h3, option, h2, th, td, li, strong, select, input, a {
        color: <?= $userThemeTextColor ?> !important;}
    option {text-align: center;}
    </style>
</head>
<body class=" text-right">

<?php include $_SERVER['DOCUMENT_ROOT'] . '/erp_task_system/navbar/navbar.php'; ?>

<div class="card p-6 rounded shadow-md max-w-md mx-auto mt-10">
    <h2 class="text-2xl text font-bold mb-4 text-center">رفع طلب عهدة جديدة</h2>
    <?php if ($error): ?>
        <div class="text-red-600 mb-3"><?= $error ?></div>
    <?php elseif ($success): ?>
        <div class="text-green-600 mb-3"><?= $success ?></div>
    <?php endif; ?>
    <form method="POST" class="space-y-4" autocomplete="off">
        <div>
            <label class="block mb-2 font-semibold">نوع العهدة</label>
            <input name="asset_type_name" type="text" class="w-full rounded border p-2 mb-2" placeholder="مثال: سيارة، جوال، شريحة، لابتوب" value="<?= htmlspecialchars($asset_type_name) ?>">
            <small class="block mb-3 text-gray-500">أمثلة: سيارة، جوال، شريحة، لابتوب، أخرى...</small>
        </div>
        <div>
            <label class="block mb-2 font-semibold">تفاصيل العهدة</label>
            <textarea name="details" class="w-full rounded border p-2 mb-3" rows="3" placeholder="اكتب هنا تفاصيل العهدة..."><?= htmlspecialchars($details) ?></textarea>
        </div>
        <button class="w-full bg-blue-600 text-white rounded p-2 font-bold hover:bg-blue-700">إرسال الطلب</button>
    </form>
    <div class="mt-6 text-center">
        <a href="profile.php" class="text-blue-600 hover:underline">الرجوع للملف الشخصي</a>
    </div>
</div>

</body>
</html>
