<?php
session_start();
require_once '../../config/db.php';
require_once '../../auth.php';
require_once '../../authorize.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

/* السماح فقط للمدير */
allow_roles(['admin']);

/* دالة هروب آمن للنصوص */
function e($v){ return htmlspecialchars(is_null($v)?'':(string)$v, ENT_QUOTES, 'UTF-8'); }

/* ألوان المستخدم والثيم */
$user = $_SESSION['user'] ?? [];
$role = $user['role'] ?? 'employee';
$color = $user['color'] ?? ['hex_code'=>'#f8fafc','text_color'=>'#111827','nav_color'=>'#233a58'];
$userThemeColor      = $color['hex_code']      ?? '#f8fafc';
$userThemeTextColor  = $color['text_color']    ?? '#111827';
$userThemeNavColor   = $color['nav_color']     ?? '#233a58';
$allColors           = $user['colors']         ?? [];
$currentUserColorId  = $user['color_id']       ?? null;

/* جلب المستخدمين */
$usersStmt = $conn->prepare("
  SELECT id, COALESCE(name,'') AS name
  FROM users
  ORDER BY name ASC
");
$usersStmt->execute();
$users = $usersStmt->fetchAll(PDO::FETCH_ASSOC);

/* جلب البنود المالية (المفعلة فقط) – بدون عمود status */
$compStmt = $conn->prepare("
  SELECT id, COALESCE(name,'') AS name, COALESCE(type,'') AS type
  FROM salary_components
  WHERE is_active = 1
  ORDER BY type, id ASC
");
$compStmt->execute();
$salaryComponents = $compStmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>بنود الرواتب للموظفين</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
  <style>
    body, .main-card, tr:hover, a:hover { background-color: <?= e($userThemeColor) ?> !important; }
    nav, .card, .toolbar { background-color: <?= e($userThemeNavColor) ?> !important; }
    .text, label, h1, h2, select, a, th, td { color: <?= e($userThemeTextColor) ?> !important; }

    .select2-container { min-width: 260px !important; width: 100% !important; }
    .select2-selection--single { height: 48px !important; padding-top: 8px !important; font-size: 16px !important; }
    .select2-container--default .select2-selection--single { background-color: <?= e($userThemeNavColor) ?> !important; border: none; }
    .select2-container--default .select2-selection--single .select2-selection__rendered { color: <?= e($userThemeTextColor) ?> !important; }
    .select2-dropdown { font-size: 15px !important; text-align: right; }
    .select2-results__option { padding: 12px; line-height: 24px; }
    .select2-selection__arrow { top: 10px !important; }
    .custom-select2 { width: 280px !important; min-width: 220px; }

    .main-card { background:#fff; border-radius:1.25rem; box-shadow:0 2px 12px #0001; }
    .btn { padding:.6rem 1rem; border-radius:.75rem; color:#fff !important; display:inline-block; }
  </style>
</head>
<body>

<!-- ناف بار -->
<nav class="bg-white shadow-md fixed w-full z-50">
  <div class="max-w-7xl mx-auto px-4">
    <div class="flex justify-between items-center h-18">
      <form method="POST" action="../../tasks/update_color.php" style=" width: 220px;display: flex;">
        <label class="text-lg font-bold py-2 ml-2">النمط:</label>
        <select name="theme_color_id" id="theme_color_select" class="card" onchange="this.form.submit()">
          <?php if (!empty($allColors)): foreach ($allColors as $c): ?>
            <option value="<?= e($c['id']) ?>" data-hex="<?= e($c['hex_code']) ?>" <?= ($c['id'] == $currentUserColorId ? 'selected' : '') ?>>
              <?= e($c['color_name']) ?>
            </option>
          <?php endforeach; else: ?>
            <option value="">No colors available</option>
          <?php endif; ?>
        </select>
      </form>
      <div class="flex items-center space-x-4 rtl:space-x-reverse">
        <a href="/erp_task_system/tasks/dashboard/index.php" class="flex items-center space-x-2 rtl:space-x-reverse">
          <img src="<?php if ($currentUserColorId != 3) echo '/erp_task_system/assets/logo.png'; else echo '/erp_task_system/assets/logo-dark.png'; ?>" alt="شعار أسرع" class="h-16 w-auto mt-2">
        </a>
      </div>
    </div>
  </div>
</nav>
<div class="h-20"></div>

<script>
$(function(){
  $('#theme_color_select').select2({
    templateResult: formatColorOption,
    templateSelection: formatColorOption
  });
  function formatColorOption(option){
    if(!option.id) return option.text;
    var hex = $(option.element).data('hex');
    return $('<span><span style="display:inline-block;width:20px;height:20px;background:'+hex+';margin-right:12px;vertical-align:middle;border:1px solid #ccc;"></span>'+option.text+'</span>');
  }
});
</script>

<!-- شريط أدوات الصفحة -->
<div class="toolbar w-full py-3">
  <div class="max-w-5xl mx-auto px-4 flex items-center justify-between">
    <h1 class="text font-bold text-xl">👥 إدارة بنود الرواتب للموظفين</h1>
    <div class="flex gap-2">
      <a href="index.php" class="btn bg-blue-600 hover:bg-blue-700">⬅ مسيرات الرواتب</a>
      <a href="salary_components.php" class="btn bg-purple-600 hover:bg-purple-700">💰 إدارة البنود المالية</a>
    </div>
  </div>
</div>

<!-- الكرت الرئيسي -->
<div class="max-w-5xl mx-auto main-card p-8 mt-6">
  <!-- اختيار الموظف -->
  <form id="selectUserForm" class="mb-6 flex items-center gap-4">
    <label class="font-bold">الموظف:</label>
    <select id="employee_id" name="employee_id" class="custom-select2" required>
      <option value="">اختر الموظف</option>
      <?php foreach($users as $u): ?>
        <option value="<?= (int)$u['id'] ?>"><?= e($u['name']) ?></option>
      <?php endforeach; ?>
    </select>
  </form>

  <!-- عرض البنود المرتبطة -->
  <div id="salaryItemsSection"></div>

  <!-- إضافة بند جديد -->
  <div id="addSalaryItemSection" class="hidden">
    <h2 class="text-xl font-semibold mt-8 mb-4">إضافة بند مالي جديد</h2>
    <form id="addSalaryItemForm" class="flex flex-wrap gap-4">
      <input type="hidden" name="employee_id" id="add_employee_id">
      <select name="component_id" id="component_id" class="custom-select2" required>
        <option value="">اختر البند</option>
        <?php foreach($salaryComponents as $c): ?>
          <option value="<?= (int)$c['id'] ?>"><?= e($c['name']) ?></option>
        <?php endforeach; ?>
      </select>
      <input type="number" name="value" id="value" class="border rounded px-2 py-2 w-32" min="0" step="0.01" placeholder="القيمة" required>
      <input type="text" name="notes" id="notes" class="border rounded px-2 py-2 w-56" placeholder="ملاحظات">
      <button type="submit" class="bg-blue-700 text-white px-6 py-2 rounded-xl hover:bg-blue-900">➕ إضافة</button>
    </form>
    <div id="addResult" class="mt-2 text-sm"></div>
  </div>
</div>

<script>
$(document).ready(function() {
  $('#employee_id').select2({ placeholder: "اختر الموظف", width: 'resolve' });
  $('#component_id').select2({ placeholder: "اختر البند", width: 'resolve' });

  // تحميل البنود عند اختيار موظف
  $('#employee_id').on('change', function() {
    let empId = $(this).val();
    $('#add_employee_id').val(empId);
    if(empId) {
      loadSalaryItems(empId);
      $('#addSalaryItemSection').removeClass('hidden');
    } else {
      $('#salaryItemsSection').html('');
      $('#addSalaryItemSection').addClass('hidden');
    }
  });

  // إضافة بند جديد
  $('#addSalaryItemForm').on('submit', function(e) {
    e.preventDefault();
    $.post('api/add_employee_salary_item.php', $(this).serialize(), function(res) {
      $('#addResult').html(res.message || '');
      if(res && res.success){
        loadSalaryItems($('#employee_id').val());
        $('#addSalaryItemForm')[0].reset();
        $('#component_id').val('').trigger('change');
        setTimeout(()=>$('#addResult').html(''),1200);
      }
    }, 'json').fail(function(){
      $('#addResult').html('<span class="text-red-600">تعذر الحفظ.</span>');
    });
  });
});

// جلب البنود المالية للموظف
function loadSalaryItems(empId) {
  $('#salaryItemsSection').html('<div class="text-gray-400">جاري التحميل ...</div>');
  $.get('api/get_employee_salary_items.php', {employee_id: empId}, function(html) {
    $('#salaryItemsSection').html(html);
  }).fail(function(){
    $('#salaryItemsSection').html("<div class='text-red-600'>تعذر تحميل البيانات.</div>");
  });
}

// حذف بند
function deleteSalaryItem(itemId, empId) {
  if(confirm('هل أنت متأكد من حذف هذا البند؟')) {
    $.post('api/delete_employee_salary_item.php', {id: itemId}, function(res){
      if(res && res.success) {
        loadSalaryItems(empId);
      } else {
        alert(res.message || 'حدث خطأ');
      }
    }, 'json').fail(function(){
      alert('تعذر تنفيذ العملية');
    });
  }
}
</script>
</body>
</html>