<?php
session_start();
require_once '../../config/db.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (!isset($_SESSION['user'])) {
    header("Location: ../../login.php");
    exit;
}

$payroll_id = intval($_GET['id'] ?? 0);
$type       = $_GET['type'] ?? 'excel'; // الافتراضي Excel

if (!$payroll_id) die("رقم المسير غير صحيح.");

$stmt = $conn->prepare("SELECT p.*, u.name AS creator_name FROM payrolls p LEFT JOIN users u ON p.created_by = u.id WHERE p.id = ?");
$stmt->execute([$payroll_id]);
$payroll = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$payroll) die("المسير غير موجود!");

// ثوابت مطابقة لما في create.php
$WORK_DAYS_MONTH = 30;
$ABS_MULTIPLIER  = 1.5;

// جلب تفاصيل الموظفين من payroll_items
$stmt = $conn->prepare("
    SELECT pi.*, u.name, u.job_title
    FROM payroll_items pi
    JOIN users u ON u.id = pi.user_id
    WHERE pi.payroll_id = ?
    ORDER BY u.name
");
$stmt->execute([$payroll_id]);
$employees = $stmt->fetchAll(PDO::FETCH_ASSOC);

// أسماء الأعمدة
$cols = [
    'اسم الموظف', 'المسمى الوظيفي', 'الراتب الأساسي',
    'البدلات', 'الخصومات', 'أيام غياب', 'الراتب الصافي'
];

// تجهيز البيانات
$rows = [];
foreach($employees as $emp) {
    $base      = (float)$emp['base_salary'];
    $allowance = (float)$emp['total_allowances'];
    $deduction = (float)$emp['total_deductions'];
    $absent    = (float)$emp['absent_days'];

    // حساب خصم الغياب
    $salary_day  = $WORK_DAYS_MONTH ? ($base / $WORK_DAYS_MONTH) : 0.0;
    $absence_ded = $absent * ($salary_day * $ABS_MULTIPLIER);

    $net = ($base + $allowance) - $deduction - $absence_ded;

    $rows[] = [
        $emp['name'],
        $emp['job_title'],
        number_format($base, 2),
        number_format($allowance, 2),
        number_format($deduction, 2),
        number_format($absent, 1),
        number_format($net, 2),
    ];
}

// --------- تصدير Excel ---------
if($type == 'excel') {
    header("Content-Type: application/vnd.ms-excel; charset=utf-8");
    header("Content-Disposition: attachment; filename=payroll_{$payroll_id}.xls");
    echo "\xEF\xBB\xBF"; // لتصحيح ترميز العربية

    // ملف HTML مع اتجاه RTL
    echo "<html dir='rtl'><body>";
    echo "<table border='1' style='direction:rtl;text-align:right;'>";
    echo "<tr>";
    foreach($cols as $col) echo "<th>{$col}</th>";
    echo "</tr>";
    foreach($rows as $row) {
        echo "<tr>";
        foreach($row as $val) echo "<td>{$val}</td>";
        echo "</tr>";
    }
    echo "</table>";
    echo "</body></html>";
    exit;
}

// --------- طباعة عبر المتصفح ---------
if($type == 'print') {
    echo '<!DOCTYPE html><html lang="ar" dir="rtl"><head><meta charset="UTF-8">';
    echo '<title>كشف رواتب المسير '.$payroll_id.'</title>';
    echo '<style>table{border-collapse:collapse;width:100%;text-align:center;} th,td{border:1px solid #ddd;padding:8px;} th{background:#eee;}</style>';
    echo '</head><body>';
    echo '<h3 style="text-align:center;font-family:Tahoma;">كشف رواتب المسير رقم '.$payroll_id.'</h3>';
    echo '<table>';
    echo '<tr>';
    foreach($cols as $col) echo '<th>'.$col.'</th>';
    echo '</tr>';
    foreach($rows as $row){
        echo '<tr>';
        foreach($row as $val) echo '<td>'.$val.'</td>';
        echo '</tr>';
    }
    echo '</table>';
    // فتح مربع الطباعة تلقائياً
    echo '<script>window.print();</script>';
    echo '</body></html>';
    exit;
}

// --------- تصدير PDF ---------
if($type == 'pdf') {
    // يحتاج تثبيت مكتبة mPDF أو تغييرها بمكتبة بديلة
    require_once __DIR__ . '/../../vendor/autoload.php';
    $html = '<h3 style="text-align:center;font-family:Tahoma;">كشف رواتب المسير رقم '.$payroll_id.'</h3>';
    $html .= '<table border="1" width="100%" style="border-collapse:collapse;text-align:center;direction:rtl;">';
    $html .= '<tr>';
    foreach($cols as $col) $html .= "<th style='background:#eee'>{$col}</th>";
    $html .= '</tr>';
    foreach($rows as $row) {
        $html .= '<tr>';
        foreach($row as $val) $html .= "<td>{$val}</td>";
        $html .= '</tr>';
    }
    $html .= '</table>';

    $mpdf = new \Mpdf\Mpdf(['mode' => 'utf-8', 'format' => 'A4', 'orientation'=>'L']);
    $mpdf->WriteHTML($html);
    $mpdf->Output('payroll_'.$payroll_id.'.pdf', 'I');
    exit;
}

die("نوع التصدير غير مدعوم.");
?>