<?php
session_start();
require_once '../../config/db.php';
require_once '../../auth.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// جلب بيانات المستخدم والألوان
$user = $_SESSION['user'];
$role = $user['role'];
$color = $user['color'];
$userThemeColor      = $color['hex_code'];
$userThemeTextColor  = $color['text_color'];
$userThemeNavColor   = $color['nav_color'] ?? '#233a58';
$allColors = $user['colors'];
$currentUserColorId = $user['color_id'];

// جلب كل المسيرات
$stmt = $conn->prepare("SELECT * FROM payrolls ORDER BY year DESC, month DESC");
$stmt->execute();
$payrolls = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>مسيرات الرواتب</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <style>
      body { background-color: <?= $userThemeColor ?> !important; color: <?= $userThemeTextColor ?> !important; }
      .main-card { background: #fff; border-radius: 1.25rem; box-shadow: 0 2px 12px 0 #0001; }
      table th, table td { color: #222 !important; }
      nav, .card { background-color: <?= $userThemeNavColor ?> !important; }
      .text, label, option, h2, select, a { color: <?= $userThemeTextColor ?> !important; }
      option { text-align: center; }
      .select2-container .select2-selection--single { height: 48px; line-height: 48px; font-size: 12px;}
      .select2-container--default .select2-selection--single { background-color: <?= $userThemeNavColor ?> !important; border: none;}
      .select2-container--default .select2-selection--single .select2-selection__rendered { line-height: 48px; color: <?= $userThemeTextColor ?> !important; }
      .select2-container--default .select2-selection--single .select2-selection__arrow { height: 48px; }
      .select2-dropdown { font-size: 12px; }
      .select2-results__option { padding: 12px; line-height: 24px; }
      .select2-container { width: 100% !important; }
    </style>
</head>
<body>
<!-- ناف بار -->
<nav class="bg-white shadow-md fixed w-full z-50">
  <div class="max-w-7xl mx-auto px-4">
    <div class="flex justify-between items-center h-18">
      <form method="POST" action="../../tasks/update_color.php" style=" width: 200px;display: flex;">
        <label class="text-lg font-bold py-2 ml-2">النمط:</label>
        <select name="theme_color_id" id="theme_color_select" class="card" onchange="this.form.submit()">
          <?php if (!empty($allColors)): ?>
            <?php foreach ($allColors as $color): ?>
              <option
                value="<?php echo htmlspecialchars($color['id']); ?>"
                data-hex="<?php echo htmlspecialchars($color['hex_code']); ?>"
                <?php echo ($color['id'] == $currentUserColorId) ? 'selected' : ''; ?>>
                <?php echo htmlspecialchars($color['color_name']); ?>
              </option>
            <?php endforeach; ?>
          <?php else: ?>
            <option value="">No colors available</option>
          <?php endif; ?>
        </select>
      </form>
      <div class="hidden md:flex items-center space-x-6 rtl:space-x-reverse text-base font-medium">
        <?php if (in_array($role, ['employee', 'manager', 'admin'])): ?>
          <div class="relative inline-block text-right">
            <button id="taskMenu" class="text text-lg hover:text-indigo-700">📋 المعاملات </button>
            <div id="taskDropdown" class="card hidden absolute right-0 mt-2 w-56 bg-white shadow-lg rounded-md py-2 text-right z-50">
              <a href="/erp_task_system/tasks/kanban_new.php" class="block px-4 py-2 hover:bg-gray-100">🔄 بالمراحل</a>
              <a href="/erp_task_system/tasks/list.php" class="block px-4 py-2 hover:bg-gray-100">📋 قائمة المعاملات</a>
              <?php if (in_array($role, ['manager', 'admin'])): ?>
                <a href="/erp_task_system/tasks/archive_tasks.php" class="block px-4 py-2 hover:bg-gray-100">📦 الأرشيف</a>
              <?php endif; ?>
              <?php if (in_array($role, ['admin'])): ?>
                <a href="/erp_task_system/tasks/archived_tasks.php" class="block px-4 py-2 hover:bg-gray-100">🗑️ المعاملات المحذوفة</a>
              <?php endif; ?>
            </div>
          </div>
        <?php endif; ?>
        <?php if ($role === 'admin'): ?>
          <div class="relative inline-block text-right">
            <button id="formMenu" class="text text-lg hover:text-indigo-700">📄 النماذج </button>
            <div id="formDropdown" class="card hidden absolute right-0 mt-2 w-56 bg-white shadow-lg rounded-md py-2 text-right z-50">
              <a href="/erp_task_system/templates/index.php" class="block px-4 py-2 hover:bg-gray-100">📄 إدارة نماذج المراحل</a>
              <a href="/erp_task_system/custom_forms/manage_portal_forms.php" class="block px-4 py-2 hover:bg-gray-100">🧾 نماذج الإدارات</a>
              <a href="/erp_task_system/custom_forms/portal.php" class="block px-4 py-2 hover:bg-gray-100">📝 بوابة الطلبات</a>
            </div>
          </div>
        <?php endif; ?>
        <?php if ($role === 'admin'): ?>
          <div class="relative inline-block text-right">
            <button id="adminMenu" class="text text-lg hover:text-indigo-700">🏢 الإدارات </button>
            <div id="adminDropdown" class="card hidden absolute right-0 mt-2 w-56 bg-white shadow-lg rounded-md py-2 text-right z-50">
              <a href="/erp_task_system/departments/index.php" class="block px-4 py-2 hover:bg-gray-100">📁 الإدارات</a>
              <a href="/erp_task_system/tasks/task_types.php" class="block px-4 py-2 hover:bg-gray-100">🏷️ إدارة التصنيفات</a>
              <a href="/erp_task_system/projects/projects.php" class="block px-4 py-2 hover:bg-gray-100">📁 إدارة المشاريع</a>
              <a href="/erp_task_system/users/index.php" class="block px-4 py-2 hover:bg-gray-100">👥 الموارد البشرية</a>
              <a href="/erp_task_system/fields/index.php" class="block px-4 py-2 hover:bg-gray-100">📑 حقول المعاملات</a>
              <a href="/erp_task_system/stages/index.php" class="block px-4 py-2 hover:bg-gray-100">📌 المراحل</a>
            </div>
          </div>
        <?php endif; ?>
        <?php if ($role === 'admin'): ?>
          <div class="relative inline-block text-right">
            <button id="integrationMenu" class="text text-lg hover:text-indigo-700">🔗 الربط </button>
            <div id="integrationDropdown" class="card hidden absolute right-0 mt-2 w-56 bg-white shadow-lg rounded-md py-2 text-right z-50">
              <a href="/erp_task_system/Integration/settings.php" class="block px-4 py-2 hover:bg-gray-100">⚙️ إعدادات الربط</a>
              <a href="/erp_task_system/Integration/index.php" class="block px-4 py-2 hover:bg-gray-100">🔗 إدارة الربط الخارجي</a>
              <a href="/erp_task_system/Integration/logs.php" class="block px-4 py-2 hover:bg-gray-100">📄 سجل الطلبات</a>
              <a href="/erp_task_system/Integration/webhook_tasks.php" class="block px-4 py-2 hover:bg-gray-100">📥 معاملات Webhook</a>
            </div>
          </div>
        <?php endif; ?>
        <?php if (in_array($role, ['manager', 'admin'])): ?>
          <a href="/erp_task_system/tasks/dashboard/index.php" class="text-lg hover:text-indigo-700">🏠 لوحة التحكم</a>
        <?php endif; ?>
        <?php if (in_array($role, ['manager', 'admin'])): ?>
          <a href="/erp_task_system/reports/report_builder.php" class="text-lg hover:text-indigo-700">📈 التقارير</a>
        <?php endif; ?>
      </div>
      <div class="relative inline-block text-left">
        <button id="userMenuButton" class="text text-lg flex items-center  text-gray-800 font-bold py-2 px-4 rounded">
          <?= htmlspecialchars($user['name'] ?? 'مستخدم') ?>
        </button>
        <div id="userDropdown" class="card origin-top-left absolute left-0 mt-2 w-48 rounded-md shadow-lg bg-white ring-1 ring-black ring-opacity-5 hidden z-50 text-right px-2">
          <a href="/erp_task_system/users/profile.php" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">👤 الملف الشخصي</a>
          <a href="/erp_task_system/users/logout.php" class="block px-4 py-2 text-sm text-red-600 hover:bg-gray-100">🚪 تسجيل خروج</a>
        </div>
      </div>
      <div class="flex items-center space-x-4 rtl:space-x-reverse">
        <a href="/erp_task_system/tasks/dashboard/index.php" class="flex items-center space-x-2 rtl:space-x-reverse">
          <img src="<?php if ($currentUserColorId != 3) echo '/erp_task_system/assets/logo.png';
                    else echo '/erp_task_system/assets/logo-dark.png'; ?> " alt="شعار أسرع" class="h-16 w-auto mt-2">
        </a>
      </div>
    </div>
  </div>
</nav>
<div class="h-20"></div>

<script>
  const menus = [{
      button: 'taskMenu',
      dropdown: 'taskDropdown'
    },
    {
      button: 'formMenu',
      dropdown: 'formDropdown'
    },
    {
      button: 'adminMenu',
      dropdown: 'adminDropdown'
    },
    {
      button: 'integrationMenu',
      dropdown: 'integrationDropdown'
    },
    {
      button: 'userMenuButton',
      dropdown: 'userDropdown'
    },
  ];
  menus.forEach(currentMenu => {
    const btn = document.getElementById(currentMenu.button);
    const dd = document.getElementById(currentMenu.dropdown);
    if (btn && dd) {
      btn.addEventListener('click', e => {
        e.stopPropagation();
        menus.forEach(menu => {
          const otherDd = document.getElementById(menu.dropdown);
          if (menu.dropdown !== currentMenu.dropdown && otherDd) {
            otherDd.classList.add('hidden');
          }
        });
        dd.classList.toggle('hidden');
      });
      window.addEventListener('click', e => {
        if (!dd.contains(e.target) && !btn.contains(e.target)) {
          dd.classList.add('hidden');
        }
      });
    }
  });
  $(document).ready(function() {
    $('#theme_color_select').select2({
      templateResult: formatColorOption,
      templateSelection: formatColorOption
    });
    function formatColorOption(option) {
      if (!option.id) {
        return option.text;
      }
      var hexCode = $(option.element).data('hex');
      var $option = $(
        '<span><span style="display: inline-block; width: 20px; height: 20px; background-color: ' + hexCode + '; margin-right: 12px; vertical-align: middle; border: 1px solid #ccc;"></span>' + option.text + '</span>'
      );
      return $option;
    }
    $('#theme_color_select').on('select2:select', function(e) {
      $(this).closest('form').submit();
    });
  });
</script>

<!-- كرت عرض مسيرات الرواتب -->
<div class="max-w-5xl mx-auto mt-6 main-card p-8">
<div class="flex justify-between items-center mb-6">
  <h1 class="text-2xl font-bold">مسيرات الرواتب</h1>
  <div class="flex gap-2">
    <a href="create.php" class="bg-blue-600 text-white px-6 py-2 rounded-xl hover:bg-blue-800 transition">➕ إنشاء مسير جديد</a>
    <a href="employee_salary_items.php" class="bg-green-600 text-white px-6 py-2 rounded-xl hover:bg-green-700 transition">👥 إدارة بنود الرواتب</a>
    <a href="salary_components.php" class="bg-purple-600 text-white px-6 py-2 rounded-xl hover:bg-purple-700 transition">💰 إدارة البنود المالية</a>
  </div>
</div>
    <table class="w-full text-center border rounded-xl overflow-hidden">
        <thead>
            <tr class="bg-gray-100">
                <th class="py-2">#</th>
                <th>الشهر</th>
                <th>السنة</th>
                <th>الحالة</th>
                <th>تاريخ الإنشاء</th>
                <th>إجراءات</th>
            </tr>
        </thead>
        <tbody
<?php foreach ($payrolls as $row): ?>
    <tr class="border-b hover:bg-gray-50 transition">
        <td><?= $row['id'] ?></td>
        <td><?= $row['month'] ?></td>
        <td><?= $row['year'] ?></td>
        <td>
            <?php
            if ($row['status'] == 'draft') {
                echo '<span class="text-yellow-600 font-bold">مسودة</span>';
            } elseif ($row['status'] == 'approved') {
                echo '<span class="text-green-700 font-bold">معتمد</span>';
            } elseif ($row['status'] == 'sent') {
                echo '<span class="text-blue-700 font-bold">مرسل للبنك</span>';
            }
            ?>
        </td>
        <td><?= $row['created_at'] ?></td>
        <td>
            <a href="view.php?id=<?= $row['id'] ?>" class="text-blue-600 hover:underline font-semibold">عرض التفاصيل</a>
            |
            <a href="generate.php?id=<?= $row['id'] ?>" class="text-green-600 hover:underline font-semibold">ملف البنك</a>
            |
            <a href="generate.php?id=<?= $row['id'] ?>&full=1" class="text-purple-600 hover:underline font-semibold">ملف كامل</a>
            |
            <a href="recalc_run.php?payroll_id=<?= $row['id'] ?>&month=<?= $row['month'] ?>&year=<?= $row['year'] ?>&snapshot=1"
               class="text-red-600 hover:underline font-semibold">إعادة الاحتساب</a>
        </td>
    </tr>
<?php endforeach ?>
        </tbody>
    </table>
    <?php if (count($payrolls) == 0): ?>
        <div class="text-center py-8 text-gray-400 font-bold">لا يوجد مسيرات رواتب حتى الآن.</div>
    <?php endif ?>
</div>
</body>
</html>
