<?php
session_start();
require_once '../../config/db.php';
require_once '../../auth.php';
require_once '../../authorize.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

/* يسمح فقط للمشرف */
allow_roles(['admin']);

/* هروب آمن */
function e($v){ return htmlspecialchars(is_null($v)?'':(string)$v, ENT_QUOTES, 'UTF-8'); }

/* ثيم المستخدم */
$user = $_SESSION['user'] ?? [];
$role = $user['role'] ?? 'employee';
$color = $user['color'] ?? ['hex_code'=>'#f8fafc','text_color'=>'#111827','nav_color'=>'#233a58'];
$userThemeColor      = $color['hex_code']      ?? '#f8fafc';
$userThemeTextColor  = $color['text_color']    ?? '#111827';
$userThemeNavColor   = $color['nav_color']     ?? '#233a58';
$allColors           = $user['colors']         ?? [];
$currentUserColorId  = $user['color_id']       ?? null;

/* جلب البنود – مطابق لهيكل الجدول اللي بالصورة */
$sql = "
  SELECT
    id,
    COALESCE(name,'')          AS name,
    COALESCE(type,'')          AS type,         -- allowance | deduction | overtime | basic
    COALESCE(is_active,0)      AS is_active,
    COALESCE(is_automatic,0)   AS is_automatic,
    COALESCE(notes,'')         AS notes,
    COALESCE(code,'')          AS code
  FROM salary_components
  ORDER BY type, id ASC
";
$stmt = $conn->prepare($sql);
$stmt->execute();
$components = $stmt->fetchAll(PDO::FETCH_ASSOC);

/* بادجات بسيطة */
function badge($text,$class){ return '<span class="px-2 py-1 text-xs rounded '.$class.'">'.e($text).'</span>'; }
function typeBadge($t){
  switch ($t) {
    case 'allowance': return badge('بدل','bg-green-100 text-green-700');
    case 'deduction': return badge('خصم','bg-red-100 text-red-700');
    case 'overtime':  return badge('أوفر تايم','bg-blue-100 text-blue-700');
    case 'basic':     return badge('أساسي','bg-indigo-100 text-indigo-700');
    default:          return badge($t ?: 'غير محدد','bg-gray-100 text-gray-600');
  }
}
function statusBadgeFromBool($active){
  return $active ? badge('مفعل','bg-emerald-100 text-emerald-700')
                 : badge('معطل','bg-gray-200 text-gray-700');
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>💰 إدارة البنود المالية</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <!-- jQuery + Select2 لاختيار النمط -->
  <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
  <style>
    body, .card { background-color: <?= e($userThemeColor) ?> !important; }
    nav, .toolbar { background-color: <?= e($userThemeNavColor) ?> !important; }
    .text, th, td, a, label, h1, h2 { color: <?= e($userThemeTextColor) ?> !important; }
    .main-card { background:#fff; border-radius:1rem; box-shadow:0 2px 12px #0000001a; }
    .btn { padding:.55rem 1rem; border-radius:.75rem; color:#fff !important; display:inline-block; }
    .table th, .table td { color:#222 !important; }
    .select2-container--default .select2-selection--single { background-color: <?= e($userThemeNavColor) ?> !important; border: none; height: 42px; }
    .select2-container--default .select2-selection--single .select2-selection__rendered { color: <?= e($userThemeTextColor) ?> !important; line-height: 42px; }
    .select2-container { width: 100% !important; }
  </style>
</head>
<body class="text-right">
    
<!-- ناف بار -->
<nav class="bg-white shadow-md fixed w-full z-50">
  <div class="max-w-7xl mx-auto px-4">
    <div class="flex justify-between items-center h-18">
      <!-- قائمة اختيار الألوان -->
      <form method="POST" action="../../tasks/update_color.php" style=" width: 200px;display: flex;">
        <label class="text-lg font-bold py-2 ml-2">النمط:</label>
        <select name="theme_color_id" id="theme_color_select" class="card" onchange="this.form.submit()">
          <?php if (!empty($allColors)): ?>
            <?php foreach ($allColors as $color): ?>
              <option
                value="<?php echo htmlspecialchars($color['id']); ?>"
                data-hex="<?php echo htmlspecialchars($color['hex_code']); ?>"
                <?php echo ($color['id'] == $currentUserColorId) ? 'selected' : ''; ?>>
                <?php echo htmlspecialchars($color['color_name']); ?>
              </option>
            <?php endforeach; ?>
          <?php else: ?>
            <option value="">No colors available</option>
          <?php endif; ?>
        </select>
      </form>
      <div class="hidden md:flex items-center space-x-6 rtl:space-x-reverse text-base font-medium">
        <?php if (in_array($role, ['employee', 'manager', 'admin'])): ?>
          <div class="relative inline-block text-right">
            <button id="taskMenu" class="text text-lg hover:text-indigo-700">📋 المعاملات </button>
            <div id="taskDropdown" class="card hidden absolute right-0 mt-2 w-56 bg-white shadow-lg rounded-md py-2 text-right z-50">
              <a href="/erp_task_system/tasks/kanban_new.php" class="block px-4 py-2 hover:bg-gray-100">🔄 بالمراحل</a>
              <a href="/erp_task_system/tasks/list.php" class="block px-4 py-2 hover:bg-gray-100">📋 قائمة المعاملات</a>
              <?php if (in_array($role, ['manager', 'admin'])): ?>
                <a href="/erp_task_system/tasks/archive_tasks.php" class="block px-4 py-2 hover:bg-gray-100">📦 الأرشيف</a>
              <?php endif; ?>
              <?php if (in_array($role, ['admin'])): ?>
                <a href="/erp_task_system/tasks/archived_tasks.php" class="block px-4 py-2 hover:bg-gray-100">🗑️ المعاملات المحذوفة</a>
              <?php endif; ?>
            </div>
          </div>
        <?php endif; ?>
        <?php if ($role === 'admin'): ?>
          <div class="relative inline-block text-right">
            <button id="formMenu" class="text text-lg hover:text-indigo-700">📄 النماذج </button>
            <div id="formDropdown" class="card hidden absolute right-0 mt-2 w-56 bg-white shadow-lg rounded-md py-2 text-right z-50">
              <a href="/erp_task_system/templates/index.php" class="block px-4 py-2 hover:bg-gray-100">📄 إدارة نماذج المراحل</a>
              <a href="/erp_task_system/custom_forms/manage_portal_forms.php" class="block px-4 py-2 hover:bg-gray-100">🧾 نماذج الإدارات</a>
              <a href="/erp_task_system/custom_forms/portal.php" class="block px-4 py-2 hover:bg-gray-100">📝 بوابة الطلبات</a>
            </div>
          </div>
        <?php endif; ?>
        <?php if ($role === 'admin'): ?>
          <div class="relative inline-block text-right">
            <button id="adminMenu" class="text text-lg hover:text-indigo-700">🏢 الإدارات </button>
            <div id="adminDropdown" class="card hidden absolute right-0 mt-2 w-56 bg-white shadow-lg rounded-md py-2 text-right z-50">
              <a href="/erp_task_system/departments/index.php" class="block px-4 py-2 hover:bg-gray-100">📁 الإدارات</a>
              <a href="/erp_task_system/tasks/task_types.php" class="block px-4 py-2 hover:bg-gray-100">🏷️ إدارة التصنيفات</a>
              <a href="/erp_task_system/projects/projects.php" class="block px-4 py-2 hover:bg-gray-100">📁 إدارة المشاريع</a>
              <a href="/erp_task_system/users/index.php" class="block px-4 py-2 hover:bg-gray-100">👥 الموارد البشرية</a>
              <a href="/erp_task_system/fields/index.php" class="block px-4 py-2 hover:bg-gray-100">📑 حقول المعاملات</a>
              <a href="/erp_task_system/stages/index.php" class="block px-4 py-2 hover:bg-gray-100">📌 المراحل</a>
            </div>
          </div>
        <?php endif; ?>
        <?php if ($role === 'admin'): ?>
          <div class="relative inline-block text-right">
            <button id="integrationMenu" class="text text-lg hover:text-indigo-700">🔗 الربط </button>
            <div id="integrationDropdown" class="card hidden absolute right-0 mt-2 w-56 bg-white shadow-lg rounded-md py-2 text-right z-50">
              <a href="/erp_task_system/Integration/settings.php" class="block px-4 py-2 hover:bg-gray-100">⚙️ إعدادات الربط</a>
              <a href="/erp_task_system/Integration/index.php" class="block px-4 py-2 hover:bg-gray-100">🔗 إدارة الربط الخارجي</a>
              <a href="/erp_task_system/Integration/logs.php" class="block px-4 py-2 hover:bg-gray-100">📄 سجل الطلبات</a>
              <a href="/erp_task_system/Integration/webhook_tasks.php" class="block px-4 py-2 hover:bg-gray-100">📥 معاملات Webhook</a>
            </div>
          </div>
        <?php endif; ?>
        <?php if (in_array($role, ['manager', 'admin'])): ?>
          <a href="/erp_task_system/tasks/dashboard/index.php" class="text-lg hover:text-indigo-700">🏠 لوحة التحكم</a>
        <?php endif; ?>
        <?php if (in_array($role, ['manager', 'admin'])): ?>
          <a href="/erp_task_system/reports/report_builder.php" class="text-lg hover:text-indigo-700">📈 التقارير</a>
        <?php endif; ?>
      </div>
      <div class="relative inline-block text-left">
        <button id="userMenuButton" class="text text-lg flex items-center  text-gray-800 font-bold py-2 px-4 rounded">
          <?= htmlspecialchars($user['name'] ?? 'مستخدم') ?>
        </button>
        <div id="userDropdown" class="card origin-top-left absolute left-0 mt-2 w-48 rounded-md shadow-lg bg-white ring-1 ring-black ring-opacity-5 hidden z-50 text-right px-2">
          <a href="/erp_task_system/users/profile.php" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">👤 الملف الشخصي</a>
          <a href="/erp_task_system/users/logout.php" class="block px-4 py-2 text-sm text-red-600 hover:bg-gray-100">🚪 تسجيل خروج</a>
        </div>
      </div>
      <div class="flex items-center space-x-4 rtl:space-x-reverse">
        <a href="/erp_task_system/tasks/dashboard/index.php" class="flex items-center space-x-2 rtl:space-x-reverse">
          <img src="<?php if ($currentUserColorId != 3) echo '/erp_task_system/assets/logo.png';
                    else echo '/erp_task_system/assets/logo-dark.png'; ?> " alt="شعار أسرع" class="h-16 w-auto mt-2">
        </a>
      </div>
    </div>
  </div>
</nav>
<div class="h-20"></div>

<script>
  // أكواد الناف بار المنسدلة + select2 للألوان
  const menus = [
    { button: 'taskMenu', dropdown: 'taskDropdown' },
    { button: 'formMenu', dropdown: 'formDropdown' },
    { button: 'adminMenu', dropdown: 'adminDropdown' },
    { button: 'integrationMenu', dropdown: 'integrationDropdown' },
    { button: 'userMenuButton', dropdown: 'userDropdown' },
  ];
  menus.forEach(currentMenu => {
    const btn = document.getElementById(currentMenu.button);
    const dd = document.getElementById(currentMenu.dropdown);
    if (btn && dd) {
      btn.addEventListener('click', e => {
        e.stopPropagation();
        menus.forEach(menu => {
          const otherDd = document.getElementById(menu.dropdown);
          if (menu.dropdown !== currentMenu.dropdown && otherDd) {
            otherDd.classList.add('hidden');
          }
        });
        dd.classList.toggle('hidden');
      });
      window.addEventListener('click', e => {
        if (!dd.contains(e.target) && !btn.contains(e.target)) {
          dd.classList.add('hidden');
        }
      });
    }
  });
  $(document).ready(function() {
    $('#theme_color_select').select2({
      templateResult: formatColorOption,
      templateSelection: formatColorOption
    });
    function formatColorOption(option) {
      if (!option.id) return option.text;
      var hexCode = $(option.element).data('hex');
      var $option = $(
        '<span><span style="display: inline-block; width: 20px; height: 20px; background-color: ' + hexCode + '; margin-right: 12px; vertical-align: middle; border: 1px solid #ccc;"></span>' + option.text + '</span>'
      );
      return $option;
    }
    $('#theme_color_select').on('select2:select', function(e) {
      $(this).closest('form').submit();
    });
  });
</script>

<div class="max-w-6xl mx-auto main-card p-8 mt-8">
  <div class="flex justify-between items-center mb-6">
    <h1 class="text-2xl font-bold">إدارة البنود المالية (البدلات والخصومات)</h1>
    <div class="flex gap-2">
      <a href="index.php" class="btn bg-blue-600 hover:bg-blue-700">⬅ مسيرات الرواتب</a>
      <a href="employee_salary_items.php" class="btn bg-green-600 hover:bg-green-700">👥 بنود الموظفين</a>
      <button onclick="openComponentModal()" class="btn bg-purple-600 hover:bg-purple-700">➕ إضافة بند</button>
    </div>
  </div>

  <div class="overflow-x-auto">
    <table class="w-full border text-center table">
      <thead>
        <tr class="bg-gray-100">
          <th class="p-2 border">#</th>
          <th class="p-2 border">اسم البند</th>
          <th class="p-2 border">النوع</th>
          <th class="p-2 border">آلي؟</th>
          <th class="p-2 border">الحالة</th>
          <th class="p-2 border">الكود</th>
          <th class="p-2 border">ملاحظات</th>
          <th class="p-2 border">إجراءات</th>
        </tr>
      </thead>
      <tbody>
        <?php if (!$components): ?>
          <tr><td colspan="8" class="p-6 text-gray-500">ما فيه بنود حالياً.</td></tr>
        <?php else: foreach($components as $row): ?>
          <tr class="border-b hover:bg-gray-50">
            <td class="p-2 border"><?= (int)$row['id'] ?></td>
            <td class="p-2 border"><?= e($row['name']) ?></td>
            <td class="p-2 border"><?= typeBadge($row['type']) ?></td>
            <td class="p-2 border"><?= ((int)$row['is_automatic'] === 1) ? '✔️' : 'يدوي' ?></td>
            <td class="p-2 border"><?= statusBadgeFromBool((int)$row['is_active'] === 1) ?></td>
            <td class="p-2 border"><?= e($row['code']) ?></td>
            <td class="p-2 border"><?= e($row['notes']) ?></td>
            <td class="p-2 border">
              <button
                onclick='openComponentModal(<?= json_encode($row, JSON_HEX_TAG|JSON_HEX_APOS|JSON_HEX_QUOT|JSON_HEX_AMP) ?>)'
                class="bg-yellow-500 text-white px-3 py-1 rounded hover:bg-yellow-600">تعديل</button>
              <a href="delete_component.php?id=<?= (int)$row['id'] ?>"
                 onclick="return confirm('حذف البند؟')"
                 class="bg-red-600 text-white px-3 py-1 rounded hover:bg-red-700 inline-block ml-1">حذف</a>
            </td>
          </tr>
        <?php endforeach; endif; ?>
      </tbody>
    </table>
  </div>
</div>

<!-- مودال إضافة/تعديل بند -->
<div id="componentModal" class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden flex items-center justify-center">
  <div class="bg-white rounded-lg p-6 max-w-md w-full">
    <div class="flex justify-between items-center mb-4">
      <h2 class="text-xl font-bold" id="modalTitle">إضافة بند مالي</h2>
      <button onclick="closeComponentModal()" class="text-xl">&times;</button>
    </div>
    <form method="POST" id="componentForm" action="save_salary_component.php">
      <input type="hidden" name="id" id="compId">
      <div class="mb-3">
        <label>اسم البند</label>
        <input type="text" name="name" id="compName" class="border rounded w-full px-2 py-2" required>
      </div>
      <div class="mb-3">
        <label>النوع</label>
        <select name="type" id="compType" class="border rounded w-full px-2 py-2" required>
          <option value="allowance">بدل</option>
          <option value="deduction">خصم</option>
          <option value="overtime">أوفر تايم</option>
          <option value="basic">أساسي</option>
        </select>
      </div>
      <div class="mb-3">
        <label>هل هو آلي؟</label>
        <select name="is_automatic" id="compAutomatic" class="border rounded w-full px-2 py-2">
          <option value="0">يدوي</option>
          <option value="1">آلي (يُحسب تلقائياً)</option>
        </select>
      </div>
      <div class="mb-3">
        <label>الكود</label>
        <input type="text" name="code" id="compCode" class="border rounded w-full px-2 py-2">
      </div>
      <div class="mb-3">
        <label>ملاحظات</label>
        <input type="text" name="notes" id="compNotes" class="border rounded w-full px-2 py-2">
      </div>
      <div class="mb-3">
        <label>الحالة</label>
        <select name="is_active" id="compActive" class="border rounded w-full px-2 py-2">
          <option value="1">مفعل</option>
          <option value="0">معطل</option>
        </select>
      </div>
      <div class="mt-4 text-center">
        <button type="submit" class="bg-blue-700 text-white px-8 py-2 rounded-xl hover:bg-blue-900">حفظ</button>
      </div>
    </form>
  </div>
</div>

<script>
  function openComponentModal(row = null) {
    document.getElementById('componentModal').classList.remove('hidden');
    document.getElementById('modalTitle').textContent = row ? "تعديل بند مالي" : "إضافة بند مالي";
    document.getElementById('componentForm').reset();

    if (row) {
      document.getElementById('compId').value         = row.id || '';
      document.getElementById('compName').value       = row.name || '';
      document.getElementById('compType').value       = row.type || 'allowance';
      document.getElementById('compAutomatic').value  = (row.is_automatic !== undefined && row.is_automatic !== null) ? row.is_automatic : '0';
      document.getElementById('compCode').value       = row.code || '';
      document.getElementById('compNotes').value      = row.notes || '';
      document.getElementById('compActive').value     = (row.is_active !== undefined && row.is_active !== null) ? row.is_active : '1';
    }
  }

  function closeComponentModal() {
    document.getElementById('componentModal').classList.add('hidden');
  }

  // إغلاق عند الضغط خارج المودال
  document.addEventListener('click', function(e){
    let modal = document.getElementById('componentModal');
    if(!modal.classList.contains('hidden') && e.target === modal) closeComponentModal();
  });
</script>
</body>
</html>