<?php
require_once '../../config/db.php';
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
 
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    die(json_encode(['success' => false, 'message' => 'غير مصرح']));
}

$id         = intval($_POST['id'] ?? 0);
$name       = trim($_POST['name'] ?? '');
$type       = $_POST['type'] ?? '';
$is_active  = isset($_POST['is_active']) ? 1 : 0;
$is_automatic = isset($_POST['is_automatic']) ? 1 : 0;
$notes      = trim($_POST['notes'] ?? '');

if ($name == '' || !in_array($type, ['allowance','deduction','basic'])) {
    die(json_encode(['success' => false, 'message' => 'البيانات ناقصة']));
}

if ($id > 0) {
    // تعديل بند مالي
    $stmt = $conn->prepare("UPDATE salary_components SET name=?, type=?, is_active=?, is_automatic=?, notes=? WHERE id=?");
    $res = $stmt->execute([$name, $type, $is_active, $is_automatic, $notes, $id]);
    $msg = 'تم التعديل بنجاح';
} else {
    // إضافة جديد
    $stmt = $conn->prepare("INSERT INTO salary_components (name, type, is_active, is_automatic, notes) VALUES (?, ?, ?, ?, ?)");
    $res = $stmt->execute([$name, $type, $is_active, $is_automatic, $notes]);
    $msg = 'تمت الإضافة بنجاح';
}

echo json_encode(['success' => $res, 'message' => $msg]);
