<?php
session_start();
require_once '../../config/db.php';
require_once '../../auth.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// التحقق من صلاحية الدخول
if (!isset($_SESSION['user'])) {
    header("Location: ../../login.php");
    exit;
}

$user = $_SESSION['user'];
$role = $user['role'];
$color = $user['color'];
$userThemeColor      = $color['hex_code'];
$userThemeTextColor  = $color['text_color'];
$userThemeNavColor   = $color['nav_color'] ?? '#233a58';
$allColors           = $user['colors'];
$currentUserColorId  = $user['color_id'];

// ثوابت لحساب الخصم — يجب أن توافق ما هو موجود في create.php
$WORK_DAYS_MONTH = 30;
$ABS_MULTIPLIER  = 1.5;

// جلب بيانات المسير
$payroll_id = intval($_GET['id'] ?? 0);
if (!$payroll_id) die("رقم المسير غير صحيح.");

$stmt = $conn->prepare("
    SELECT p.*, u.name AS creator_name
    FROM payrolls p
    LEFT JOIN users u ON p.created_by = u.id
    WHERE p.id = ?
");
$stmt->execute([$payroll_id]);
$payroll = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$payroll) die("المسير غير موجود!");

// جلب تفاصيل الموظفين في هذا المسير من payroll_items (عرض القيم المحفوظة فقط)
$stmt = $conn->prepare("
    SELECT d.*, u.name, u.job_title, u.profile_image
    FROM payroll_items d
    JOIN users u ON u.id = d.user_id
    WHERE d.payroll_id = ?
    ORDER BY u.name
");
$stmt->execute([$payroll_id]);
$employees = $stmt->fetchAll(PDO::FETCH_ASSOC);

// حساب الإجماليات من القيم المخزّنة
$total_base        = 0.0;
$total_allow       = 0.0;
$total_deduct      = 0.0;
$total_absent      = 0.0;
$total_absence_ded = 0.0;
$total_net         = 0.0;

foreach ($employees as $emp) {
    $row_base   = (float)$emp['base_salary'];
    $row_allow  = (float)$emp['total_allowances'];
    $row_deduct = (float)$emp['total_deductions'];
    $row_absent = (float)($emp['absent_days'] ?? 0.0);

    // حساب خصم الغياب
    $salary_day   = $WORK_DAYS_MONTH ? ($row_base / $WORK_DAYS_MONTH) : 0.0;
    $absence_ded  = $row_absent * ($salary_day * $ABS_MULTIPLIER);

    // حساب الصافي شاملاً خصم الغياب
    $net = ($row_base + $row_allow) - $row_deduct - $absence_ded;

    $total_base        += $row_base;
    $total_allow       += $row_allow;
    $total_deduct      += $row_deduct;
    $total_absent      += $row_absent;
    $total_absence_ded += $absence_ded;
    $total_net         += $net;
}

// وسوم الحالة
$status_label = [
    'draft'    => '<span class="px-3 py-1 rounded-xl bg-yellow-100 text-yellow-700 font-bold">مسودة</span>',
    'approved' => '<span class="px-3 py-1 rounded-xl bg-green-100 text-green-800 font-bold">معتمد</span>',
    'sent'     => '<span class="px-3 py-1 rounded-xl bg-blue-100 text-blue-800 font-bold">مرسل للبنك</span>'
];
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>تفاصيل مسير رواتب #<?= htmlspecialchars((string)$payroll['id']) ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <style>
      body { background-color: <?= $userThemeColor ?> !important; color: <?= $userThemeTextColor ?> !important; }
      .main-card { background: #fff; border-radius: 1.25rem; box-shadow: 0 2px 12px 0 #0001; }
      table th, table td { color: #222 !important; }
      nav, .card { background-color: <?= $userThemeNavColor ?> !important; }
      .text, label, option, h2, select, a { color: <?= $userThemeTextColor ?> !important; }
      option { text-align: center; }
      .select2-container .select2-selection--single { height: 48px; line-height: 48px; font-size: 12px;}
      .select2-container--default .select2-selection--single { background-color: <?= $userThemeNavColor ?> !important; border: none;}
      .select2-container--default .select2-selection--single .select2-selection__rendered { line-height: 48px; color: <?= $userThemeTextColor ?> !important; }
      .select2-container--default .select2-selection--single .select2-selection__arrow { height: 48px; }
      .select2-dropdown { font-size: 12px; }
      .select2-results__option { padding: 12px; line-height: 24px; }
      .select2-container { width: 100% !important; }

      /* إخفاء عناصر معينة أثناء الطباعة */
      @media print {
        .print-hide { display: none !important; }
        @media print {
  .h-20 {
    height: 0 !important;
  }
}
      }
    </style>
</head>
<body>

<!-- شريط التنقّل مع فئة print-hide لإخفائه في الطباعة -->
<nav class="bg-white shadow-md fixed w-full z-50 print-hide">
  <div class="max-w-7xl mx-auto px-4">
    <div class="flex justify-between items-center h-18">
      <!-- قائمة اختيار الألوان -->
      <form method="POST" action="../../tasks/update_color.php" style=" width: 200px;display: flex;">
        <label class="text-lg font-bold py-2 ml-2">النمط:</label>
        <select name="theme_color_id" id="theme_color_select" class="card" onchange="this.form.submit()">
          <?php if (!empty($allColors)): ?>
            <?php foreach ($allColors as $color): ?>
              <option
                value="<?php echo htmlspecialchars($color['id']); ?>"
                data-hex="<?php echo htmlspecialchars($color['hex_code']); ?>"
                <?php echo ($color['id'] == $currentUserColorId) ? 'selected' : ''; ?>>
                <?php echo htmlspecialchars($color['color_name']); ?>
              </option>
            <?php endforeach; ?>
          <?php else: ?>
            <option value="">No colors available</option>
          <?php endif; ?>
        </select>
      </form>
      <div class="hidden md:flex items-center space-x-6 rtl:space-x-reverse text-base font-medium">
        <?php if (in_array($role, ['employee', 'manager', 'admin'])): ?>
          <div class="relative inline-block text-right">
            <button id="taskMenu" class="text text-lg hover:text-indigo-700">📋 المعاملات </button>
            <div id="taskDropdown" class="card hidden absolute right-0 mt-2 w-56 bg-white shadow-lg rounded-md py-2 text-right z-50">
              <a href="/erp_task_system/tasks/kanban_new.php" class="block px-4 py-2 hover:bg-gray-100">🔄 بالمراحل</a>
              <a href="/erp_task_system/tasks/list.php" class="block px-4 py-2 hover:bg-gray-100">📋 قائمة المعاملات</a>
              <?php if (in_array($role, ['manager', 'admin'])): ?>
                <a href="/erp_task_system/tasks/archive_tasks.php" class="block px-4 py-2 hover:bg-gray-100">📦 الأرشيف</a>
              <?php endif; ?>
              <?php if (in_array($role, ['admin'])): ?>
                <a href="/erp_task_system/tasks/archived_tasks.php" class="block px-4 py-2 hover:bg-gray-100">🗑️ المعاملات المحذوفة</a>
              <?php endif; ?>
            </div>
          </div>
        <?php endif; ?>
        <?php if ($role === 'admin'): ?>
          <div class="relative inline-block text-right">
            <button id="formMenu" class="text text-lg hover:text-indigo-700">📄 النماذج </button>
            <div id="formDropdown" class="card hidden absolute right-0 mt-2 w-56 bg-white shadow-lg rounded-md py-2 text-right z-50">
              <a href="/erp_task_system/templates/index.php" class="block px-4 py-2 hover:bg-gray-100">📄 إدارة نماذج المراحل</a>
              <a href="/erp_task_system/custom_forms/manage_portal_forms.php" class="block px-4 py-2 hover:bg-gray-100">🧾 نماذج الإدارات</a>
              <a href="/erp_task_system/custom_forms/portal.php" class="block px-4 py-2 hover:bg-gray-100">📝 بوابة الطلبات</a>
            </div>
          </div>
        <?php endif; ?>
        <?php if ($role === 'admin'): ?>
          <div class="relative inline-block text-right">
            <button id="adminMenu" class="text text-lg hover:text-indigo-700">🏢 الإدارات </button>
            <div id="adminDropdown" class="card hidden absolute right-0 mt-2 w-56 bg-white shadow-lg rounded-md py-2 text-right z-50">
              <a href="/erp_task_system/departments/index.php" class="block px-4 py-2 hover:bg-gray-100">📁 الإدارات</a>
              <a href="/erp_task_system/tasks/task_types.php" class="block px-4 py-2 hover:bg-gray-100">🏷️ إدارة التصنيفات</a>
              <a href="/erp_task_system/projects/projects.php" class="block px-4 py-2 hover:bg-gray-100">📁 إدارة المشاريع</a>
              <a href="/erp_task_system/users/index.php" class="block px-4 py-2 hover:bg-gray-100">👥 الموارد البشرية</a>
              <a href="/erp_task_system/fields/index.php" class="block px-4 py-2 hover:bg-gray-100">📑 حقول المعاملات</a>
              <a href="/erp_task_system/stages/index.php" class="block px-4 py-2 hover:bg-gray-100">📌 المراحل</a>
            </div>
          </div>
        <?php endif; ?>
        <?php if ($role === 'admin'): ?>
          <div class="relative inline-block text-right">
            <button id="integrationMenu" class="text text-lg hover:text-indigo-700">🔗 الربط </button>
            <div id="integrationDropdown" class="card hidden absolute right-0 mt-2 w-56 bg-white shadow-lg rounded-md py-2 text-right z-50">
              <a href="/erp_task_system/Integration/settings.php" class="block px-4 py-2 hover:bg-gray-100">⚙️ إعدادات الربط</a>
              <a href="/erp_task_system/Integration/index.php" class="block px-4 py-2 hover:bg-gray-100">🔗 إدارة الربط الخارجي</a>
              <a href="/erp_task_system/Integration/logs.php" class="block px-4 py-2 hover:bg-gray-100">📄 سجل الطلبات</a>
              <a href="/erp_task_system/Integration/webhook_tasks.php" class="block px-4 py-2 hover:bg-gray-100">📥 معاملات Webhook</a>
            </div>
          </div>
        <?php endif; ?>
        <?php if (in_array($role, ['manager', 'admin'])): ?>
          <a href="/erp_task_system/tasks/dashboard/index.php" class="text-lg hover:text-indigo-700">🏠 لوحة التحكم</a>
        <?php endif; ?>
        <?php if (in_array($role, ['manager', 'admin'])): ?>
          <a href="/erp_task_system/reports/report_builder.php" class="text-lg hover:text-indigo-700">📈 التقارير</a>
        <?php endif; ?>
      </div>
      <div class="relative inline-block text-left">
        <button id="userMenuButton" class="text text-lg flex items-center  text-gray-800 font-bold py-2 px-4 rounded">
          <?= htmlspecialchars($user['name'] ?? 'مستخدم') ?>
        </button>
        <div id="userDropdown" class="card origin-top-left absolute left-0 mt-2 w-48 rounded-md shadow-lg bg-white ring-1 ring-black ring-opacity-5 hidden z-50 text-right px-2">
          <a href="/erp_task_system/users/profile.php" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">👤 الملف الشخصي</a>
          <a href="/erp_task_system/users/logout.php" class="block px-4 py-2 text-sm text-red-600 hover:bg-gray-100">🚪 تسجيل خروج</a>
        </div>
      </div>
      <div class="flex items-center space-x-4 rtl:space-x-reverse">
        <a href="/erp_task_system/tasks/dashboard/index.php" class="flex items-center space-x-2 rtl:space-x-reverse">
          <img src="<?php if ($currentUserColorId != 3) echo '/erp_task_system/assets/logo.png';
                    else echo '/erp_task_system/assets/logo-dark.png'; ?> " alt="شعار أسرع" class="h-16 w-auto mt-2">
        </a>
      </div>
    </div>
  </div>
</nav>
<div class="h-20"></div>

<script>
  const menus = [
    {button: 'taskMenu', dropdown: 'taskDropdown'},
    {button: 'formMenu', dropdown: 'formDropdown'},
    {button: 'adminMenu', dropdown: 'adminDropdown'},
    {button: 'integrationMenu', dropdown: 'integrationDropdown'},
    {button: 'userMenuButton', dropdown: 'userDropdown'},
  ];
  menus.forEach(currentMenu => {
    const btn = document.getElementById(currentMenu.button);
    const dd = document.getElementById(currentMenu.dropdown);
    if (btn && dd) {
      btn.addEventListener('click', e => {
        e.stopPropagation();
        menus.forEach(menu => {
          const otherDd = document.getElementById(menu.dropdown);
          if (menu.dropdown !== currentMenu.dropdown && otherDd) {
            otherDd.classList.add('hidden');
          }
        });
        dd.classList.toggle('hidden');
      });
      window.addEventListener('click', e => {
        if (!dd.contains(e.target) && !btn.contains(e.target)) {
          dd.classList.add('hidden');
        }
      });
    }
  });
  $(document).ready(function() {
    $('#theme_color_select').select2({
      templateResult: formatColorOption,
      templateSelection: formatColorOption
    });
    function formatColorOption(option) {
      if (!option.id) {
        return option.text;
      }
      var hexCode = $(option.element).data('hex');
      var $option = $(
        '<span><span style="display: inline-block; width: 20px; height: 20px; background-color: ' + hexCode + '; margin-right: 12px; vertical-align: middle; border: 1px solid #ccc;"></span>' + option.text + '</span>'
      );
      return $option;
    }
    $('#theme_color_select').on('select2:select', function(e) {
      $(this).closest('form').submit();
    });
  });
</script>
  </div>
</nav>
<div class="h-20"></div>

<div class="max-w-5xl mx-auto mt-6 main-card p-8">
    <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-6 gap-4">
        <div>
            <h1 class="text-2xl font-bold mb-1">تفاصيل مسير الرواتب رقم #<?= htmlspecialchars((string)$payroll['id']) ?></h1>
            <div class="mb-1 text-lg">الشهر: <b><?= htmlspecialchars((string)$payroll['month']) ?></b> - السنة: <b><?= htmlspecialchars((string)$payroll['year']) ?></b></div>
            <div class="mb-1 text-lg">الحالة: <?= $status_label[$payroll['status']] ?? htmlspecialchars((string)$payroll['status']) ?></div>
            <div class="mb-1 text-sm text-gray-500">أنشئ بواسطة: <?= htmlspecialchars((string)$payroll['creator_name']) ?> في <?= date('Y-m-d H:i', strtotime($payroll['created_at'])) ?></div>
        </div>
        <!-- مجموعة الأزرار بداخل فئة print-hide لإخفائها عند الطباعة -->
        <div class="flex gap-2 flex-wrap print-hide">
            <?php if ($role == 'admin' && $payroll['status'] == 'draft'): ?>
                <a href="approve.php?id=<?= $payroll['id'] ?>" class="bg-green-600 text-white px-4 py-2 rounded-lg font-bold hover:bg-green-800">اعتماد المسير</a>
            <?php endif; ?>
            <a href="export.php?id=<?= $payroll['id'] ?>&type=pdf" class="bg-indigo-600 text-white px-4 py-2 rounded-lg hover:bg-indigo-800">تصدير PDF</a>
            <a href="export.php?id=<?= $payroll['id'] ?>&type=excel" class="bg-blue-500 text-white px-4 py-2 rounded-lg hover:bg-blue-800">تصدير Excel</a>
            <button onclick="window.print()" class="bg-orange-500 text-white px-4 py-2 rounded-lg hover:bg-orange-700">🖨️ طباعة</button>
            <a href="index.php" class="bg-gray-400 text-white px-4 py-2 rounded-lg hover:bg-gray-700">عودة</a>
        </div>
    </div>

    <!-- جدول الموظفين -->
    <div class="overflow-x-auto">
        <table class="w-full text-center border rounded-xl overflow-hidden">
            <thead>
                <tr class="bg-gray-100">
                    <th>الموظف</th>
                    <th>المسمى الوظيفي</th>
                    <th>الراتب الأساسي</th>
                    <th>البدلات</th>
                    <th>الخصومات</th>
                    <th>أيام غياب</th>
                    <th class="bg-green-50">صافي الراتب</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($employees as $emp): ?>
                <?php
                  $row_base   = (float)$emp['base_salary'];
                  $row_allow  = (float)$emp['total_allowances'];
                  $row_deduct = (float)$emp['total_deductions'];
                  $row_absent = (float)($emp['absent_days'] ?? 0.0);

                  // حساب خصم الغياب بنفس معادلة صفحة الإنشاء
                  $salary_day  = $WORK_DAYS_MONTH ? ($row_base / $WORK_DAYS_MONTH) : 0.0;
                  $absence_ded = $row_absent * ($salary_day * $ABS_MULTIPLIER);

                  // صافي الراتب
                  $row_net = ($row_base + $row_allow) - $row_deduct - $absence_ded;
                ?>
                <tr class="border-b">
                    <td class="flex items-center gap-2 justify-center py-2">
                        <?php if (!empty($emp['profile_image'])): ?>
                            <img src="/erp_task_system/users/img/<?= htmlspecialchars($emp['profile_image']) ?>" class="w-9 h-9 rounded-full border" alt="صورة">
                        <?php endif; ?>
                        <?= htmlspecialchars($emp['name']) ?>
                    </td>
                    <td><?= htmlspecialchars((string)$emp['job_title']) ?></td>
                    <td><?= number_format($row_base, 2) ?></td>
                    <td><?= number_format($row_allow, 2) ?></td>
                    <td><?= number_format($row_deduct, 2) ?></td>
                    <td><?= number_format($row_absent, 1) ?></td>
                    <td class="bg-green-50 font-bold"><?= number_format($row_net, 2) ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
            <tfoot>
                <tr class="bg-gray-200 font-extrabold text-lg">
                    <td colspan="2">الإجمالي</td>
                    <td><?= number_format($total_base, 2) ?></td>
                    <td><?= number_format($total_allow, 2) ?></td>
                    <td><?= number_format($total_deduct, 2) ?></td>
                    <td><?= number_format($total_absent, 1) ?></td>
                    <td class="bg-green-100"><?= number_format($total_net, 2) ?></td>
                </tr>
            </tfoot>
        </table>
    </div>

    <?php if (!empty($payroll['notes'])): ?>
        <div class="mt-4 bg-yellow-50 border border-yellow-300 rounded-lg px-4 py-2">
            <span class="font-bold">ملاحظات:</span> <?= nl2br(htmlspecialchars($payroll['notes'])) ?>
        </div>
    <?php endif; ?>
</div>

<script>
  $(function(){
    $('#theme_color_select').select2({
      templateResult: formatColorOption,
      templateSelection: formatColorOption
    });
    function formatColorOption(option) {
      if (!option.id) return option.text;
      var hexCode = $(option.element).data('hex');
      return $('<span><span style="display:inline-block;width:20px;height:20px;background-color:'+hexCode+';margin-right:12px;vertical-align:middle;border:1px solid #ccc;"></span>'+option.text+'</span>');
    }
    $('#theme_color_select').on('select2:select', function(){ $(this).closest('form').submit(); });
  });
</script>
</body>
</html>