<?php
// /erp_task_system/users/settlements/api/add_item.php
if (session_status() === PHP_SESSION_NONE) session_start();
header('Content-Type: application/json; charset=utf-8');

require_once __DIR__ . '/../_helpers.php';

// فضّل أدوار: admin/manager/HR إن عندك
require_roles(['admin','manager','hr','HR']);

try {
  $uid = current_user_id();
  if (!$uid) throw new Exception('login');

  $sid        = (int)($_POST['settlement_id'] ?? 0);
  $item_type  = $_POST['item_type']  ?? 'addition';   // addition | deduction
  $item_code  = $_POST['item_code']  ?? 'OTHER';
  $item_label = trim($_POST['item_label'] ?? '');
  $amount     = (float)($_POST['amount'] ?? 0);

  if ($sid <= 0) throw new Exception('bad_id');
  if (!in_array($item_type, ['addition','deduction'], true)) throw new Exception('bad_type');
  if ($amount <= 0) throw new Exception('bad_amount');

  $settlement = get_settlement_row($conn, $sid);
  assert_editable($settlement);

  $conn->beginTransaction();

  $ins = $conn->prepare("INSERT INTO settlement_items
    (settlement_id,item_type,item_code,label,amount,source,created_by,created_at)
    VALUES (?,?,?,?,?,'manual',?,NOW())");
  $ins->execute([$sid, $item_type, $item_code, $item_label, $amount, $uid]);

  recalc_settlement_totals($conn, $sid);

  $conn->commit();
  echo json_encode(['ok'=>true, 'msg'=>'added']);
} catch (Exception $e) {
  if ($conn->inTransaction()) $conn->rollBack();
  echo json_encode(['ok'=>false, 'msg'=>$e->getMessage()]);
}
