<?php
// /erp_task_system/users/settlements/api/create_settlement.php
if (session_status() === PHP_SESSION_NONE) session_start();

require_once __DIR__ . '/../_helpers.php'; // يحتوي على $conn + require_roles + get_basic_salary
require_roles(['admin','manager','hr','HR']);

function bad_request(string $msg){
  http_response_code(400);
  // عرض بسيط + رجوع
  echo "<meta charset='utf-8'/><div style='font-family:Tahoma;direction:rtl;text-align:right;padding:20px'>
          <h3>خطأ في الإدخال</h3>
          <p style='color:#b91c1c'>{$msg}</p>
          <p><a href='../create.php' style='color:#1d4ed8'>رجوع لصفحة الإنشاء</a></p>
        </div>";
  exit;
}

try{
  $uid = current_user_id();
  if(!$uid) bad_request('يلزم تسجّل دخول.');

  // قراءة القيم
  $employee_id          = (int)($_POST['employee_id'] ?? 0);
  $reason               = $_POST['reason'] ?? 'termination';
  $pay_method           = $_POST['pay_method'] ?? 'bank';
  $last_working_day     = trim($_POST['last_working_day'] ?? '');
  $settlement_due_date  = trim($_POST['settlement_due_date'] ?? '');
  $basic_snapshot_input = isset($_POST['basic_salary_snapshot']) ? (float)$_POST['basic_salary_snapshot'] : 0.0;
  $iban_snapshot        = trim($_POST['bank_iban_snapshot'] ?? '');

  // فاليشِن أساسي
  if($employee_id <= 0)           bad_request('الرجاء اختيار الموظف.');
  if($last_working_day === '')     bad_request('أدخل آخر يوم عمل.');

  // حاوِل نحدّد الراتب الأساسي (BASIC) من البنود إذا المرسل <= 0
  $basic_salary_snapshot = $basic_snapshot_input;
  if($basic_salary_snapshot <= 0){
    $fromComponents = get_basic_salary($conn, $employee_id); // قد ترجع null
    if($fromComponents !== null && $fromComponents > 0){
      $basic_salary_snapshot = (float)$fromComponents;
    }
  }
  if($basic_salary_snapshot <= 0){
    bad_request('لم يتم العثور على بند راتب أساسي (BASIC) لهذا الموظف. عبِّه يدويًا أو أضِف بند BASIC للموظف.');
  }

  // لو تاريخ الاستحقاق فاضي، خلّه مثل آخر يوم أو تاريخ اليوم
  if($settlement_due_date === ''){
    $settlement_due_date = $last_working_day ?: date('Y-m-d');
  }

  // توليد كود المخالصة STL-YYYYMM-#### (حسب شهر "آخر يوم عمل")
  $ym = date('Ym', strtotime($last_working_day));
  $conn->beginTransaction();

  $cnt = $conn->prepare("SELECT COUNT(*) FROM settlements WHERE DATE_FORMAT(last_working_day,'%Y%m')=?");
  $cnt->execute([$ym]);
  $seq = (int)$cnt->fetchColumn() + 1;
  $code = sprintf('STL-%s-%04d', $ym, $seq);

  // الإدراج
  $ins = $conn->prepare("
    INSERT INTO settlements
      (code, employee_id, status, reason, last_working_day, settlement_due_date,
       pay_method, bank_iban_snapshot, basic_salary_snapshot,
       total_additions, total_deductions, net_amount,
       created_by, created_at, updated_at)
    VALUES
      (?, ?, 'draft', ?, ?, ?, ?, ?, ?, 0, 0, 0, ?, NOW(), NOW())
  ");
  $ins->execute([
    $code,
    $employee_id,
    $reason,
    $last_working_day,
    $settlement_due_date,
    $pay_method,
    $iban_snapshot ?: null,
    $basic_salary_snapshot,
    $uid
  ]);

  $newId = (int)$conn->lastInsertId();
  $conn->commit();

  // تحويل لصفحة العرض
  header("Location: ../view.php?id={$newId}");
  exit;

}catch(Exception $e){
  if($conn->inTransaction()) $conn->rollBack();
  bad_request('خطأ غير متوقّع: '.$e->getMessage());
}
