<?php
// /erp_task_system/users/settlements/api/employee_snapshot.php
if (session_status() === PHP_SESSION_NONE) session_start();
header('Content-Type: application/json; charset=utf-8');

require_once __DIR__ . '/../_helpers.php';
require_roles(['admin','manager','hr','HR']);

try{
  $eid = (int)($_POST['employee_id'] ?? 0);
  if($eid <= 0) throw new Exception('bad_employee');

  // الراتب الأساسي من البنود فقط (type='basic' أو code='BASIC')
  $basic = get_basic_salary($conn, $eid); // قد يرجع null

  // نحاول نجيب الآيبان من users (حطّينا احتمالين للاسم)
  $st = $conn->prepare("SELECT
                          COALESCE(NULLIF(iban,''), NULLIF(bank_iban,'')) AS iban,
                          hire_date
                        FROM users WHERE id=? LIMIT 1");
  $st->execute([$eid]);
  $u = $st->fetch(PDO::FETCH_ASSOC);

  echo json_encode([
    'ok' => true,
    'basic_salary' => ($basic !== null ? (float)$basic : null),
    'iban' => $u['iban'] ?? null,
    'hire_date' => $u['hire_date'] ?? null,
  ], JSON_UNESCAPED_UNICODE);
}catch(Exception $e){
  echo json_encode(['ok'=>false,'msg'=>$e->getMessage()]);
}
