<?php
/* /erp_task_system/users/settlements/create.php */
session_start();
require_once '../../config/db.php';

if (!isset($_SESSION['user'])) { header('Location: ../../login.php'); exit; }

$meRole = $_SESSION['user']['role'] ?? '';
if (!in_array($meRole, ['admin','manager','hr','HR'])) {
  header('Location: ../unauthorized.php'); exit;
}

/* قائمة الموظفين */
$emps = $conn->query("SELECT id, name FROM users ORDER BY name ASC")->fetchAll(PDO::FETCH_ASSOC);

/* تواريخ افتراضية */
$today = date('Y-m-d');
$dueDefault = $today; // تقدر تغيّرها لأي منطق ودك
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8"/>
  <title>إنشاء مخالصة</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-slate-50 min-h-screen">
  <div class="max-w-3xl mx-auto p-6">
    <a href="index.php" class="text-slate-600">&larr; رجوع</a>
    <h1 class="text-2xl font-bold mt-2 mb-6">إنشاء مخالصة جديدة</h1>

    <form id="createForm" action="api/create_settlement.php" method="post" class="bg-white rounded-xl shadow p-5 grid gap-4">
      <div>
        <label class="block text-sm mb-1">الموظف <span class="text-rose-600">*</span></label>
        <select name="employee_id" id="employee_id" class="w-full border rounded p-2" required>
          <option value="">— اختر موظف —</option>
          <?php foreach($emps as $e): ?>
            <option value="<?= (int)$e['id'] ?>"><?= htmlspecialchars($e['name']) ?></option>
          <?php endforeach; ?>
        </select>
        <p class="text-xs text-slate-500 mt-1">بعد الاختيار، النظام يجيب الراتب الأساسي تلقائي من البنود.</p>
      </div>

      <div class="grid md:grid-cols-2 gap-4">
        <div>
          <label class="block text-sm mb-1">سبب الإنهاء</label>
          <select name="reason" class="w-full border rounded p-2">
            <option value="termination">إنهاء من جهة العمل</option>
            <option value="resignation">استقالة</option>
          </select>
        </div>
        <div>
          <label class="block text-sm mb-1">طريقة الصرف</label>
          <select name="pay_method" id="pay_method" class="w-full border rounded p-2">
            <option value="bank">تحويل بنكي</option>
            <option value="cash">نقدي</option>
            <option value="transfer">حوالة داخلية</option>
          </select>
        </div>
      </div>

      <div class="grid md:grid-cols-2 gap-4">
        <div>
          <label class="block text-sm mb-1">آخر يوم عمل <span class="text-rose-600">*</span></label>
          <input type="date" name="last_working_day" class="w-full border rounded p-2" required value="<?= $today ?>">
        </div>
        <div>
          <label class="block text-sm mb-1">تاريخ الاستحقاق</label>
          <input type="date" name="settlement_due_date" class="w-full border rounded p-2" value="<?= $dueDefault ?>">
        </div>
      </div>

      <div class="grid md:grid-cols-2 gap-4">
        <div>
          <label class="block text-sm mb-1">الراتب الأساسي (سنابشوت) <span class="text-rose-600">*</span></label>
          <input type="number" step="0.01" id="basic_salary_snapshot" name="basic_salary_snapshot"
                 class="w-full border rounded p-2" required placeholder="يُجلب تلقائيًا من البنود">
          <p id="basicHint" class="text-xs mt-1 text-slate-500">بنجيبه من employee_salary_items (type=basic أو code=BASIC). </p>
        </div>
        <div>
          <label class="block text-sm mb-1">IBAN (سنابشوت)</label>
          <input type="text" id="bank_iban_snapshot" name="bank_iban_snapshot" class="w-full border rounded p-2" placeholder="اختياري">
          <p class="text-xs text-slate-500 mt-1">لو لقيناه عند الموظف بنعبّيه ونخلي طريقة الصرف = تحويل بنكي.</p>
        </div>
      </div>

      <div class="flex items-center gap-3">
        <button class="px-5 py-2 bg-emerald-600 text-white rounded">حفظ وإنشاء</button>
        <span id="msg" class="text-sm"></span>
      </div>
    </form>
  </div>

<script>
const empSel  = document.getElementById('employee_id');
const basicEl = document.getElementById('basic_salary_snapshot');
const ibanEl  = document.getElementById('bank_iban_snapshot');
const paySel  = document.getElementById('pay_method');
const hintEl  = document.getElementById('basicHint');

empSel.addEventListener('change', async ()=>{
  const id = empSel.value;
  if(!id){ basicEl.value=''; ibanEl.value=''; return; }
  hintEl.textContent = 'جاري الجلب من بنود الراتب...';
  try{
    const fd = new FormData(); fd.append('employee_id', id);
    const res = await fetch('api/employee_snapshot.php', { method:'POST', body: fd });
    const j   = await res.json();
    if(!j.ok){ hintEl.textContent = 'ما قدرنا نجيب الراتب من البنود. عبّه يدوي.'; return; }

    if(j.basic_salary !== null){
      basicEl.value = j.basic_salary;
      hintEl.textContent = 'تم جلب الراتب الأساسي من البنود.';
    }else{
      basicEl.value = '';
      hintEl.textContent = 'ما فيه BASIC عند الموظف. عبّه يدوي.';
    }

    if(j.iban){
      ibanEl.value = j.iban;
      if(paySel) paySel.value = 'bank';
    }else{
      // لا تغيّر طريقة الصرف لو ما فيه آيبان
      if(!ibanEl.value) ibanEl.value = '';
    }
  }catch(e){
    hintEl.textContent = 'خطأ اتصال. عبّه يدوي.';
  }
});

// إرسال عادي على create_settlement.php (POST)
</script>
</body>
</html>
