<?php
/* /erp_task_system/users/settlements/create.php */
session_start();
require_once '../../config/db.php';
require_once '../../authorize.php'; // لو عندك تحكم صلاحيات

$user = $_SESSION['user'] ?? [];
if (!$user) { header('Location: ../../login.php'); exit; }

$users = $conn->query("SELECT id, name FROM users ORDER BY id DESC LIMIT 50")->fetchAll(PDO::FETCH_ASSOC);
$contracts = [];
try { $contracts = $conn->query("SELECT id FROM contracts ORDER BY id DESC LIMIT 50")->fetchAll(PDO::FETCH_ASSOC); } catch(Exception $e){}
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8"/>
  <title>إنشاء مخالصة</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="min-h-screen bg-slate-50">
  <div class="max-w-5xl mx-auto p-6">
    <h1 class="text-2xl font-bold mb-6">إنشاء مخالصة (HR)</h1>

    <form id="settlementForm" class="grid md:grid-cols-2 gap-4 bg-white p-5 rounded-xl shadow">
      <div>
        <label class="block text-sm mb-1">الموظف</label>
        <select name="employee_id" class="w-full border rounded p-2" required>
          <option value="">اختر موظف</option>
          <?php foreach($users as $u): ?>
            <option value="<?= (int)$u['id'] ?>"><?= (int)$u['id'] ?> — <?= htmlspecialchars($u['name'] ?: 'بدون اسم') ?></option>
          <?php endforeach; ?>
        </select>
      </div>

      <div>
        <label class="block text-sm mb-1">العقد (اختياري)</label>
        <select name="contract_id" class="w-full border rounded p-2">
          <option value="">بدون</option>
          <?php foreach($contracts as $c): ?>
            <option value="<?= (int)$c['id'] ?>"><?= (int)$c['id'] ?></option>
          <?php endforeach; ?>
        </select>
      </div>

      <div>
        <label class="block text-sm mb-1">المنهي</label>
        <select name="initiated_by" class="w-full border rounded p-2" required>
          <option value="employee">الموظف</option>
          <option value="employer">صاحب العمل</option>
          <option value="mutual">اتفاق مشترك</option>
        </select>
      </div>

      <div>
        <label class="block text-sm mb-1">سبب الإنهاء</label>
        <select name="termination_reason" class="w-full border rounded p-2" required>
          <option value="resignation">استقالة</option>
          <option value="contract_end">انتهاء مدة العقد</option>
          <option value="termination">إنهاء من المنشأة</option>
          <option value="redundancy">ظروف تشغيلية</option>
          <option value="death">وفاة</option>
          <option value="other">أخرى</option>
        </select>
      </div>

      <div>
        <label class="block text-sm mb-1">تاريخ الإشعار (اختياري)</label>
        <input type="date" name="notice_date" class="w-full border rounded p-2">
      </div>

      <div>
        <label class="block text-sm mb-1">آخر يوم عمل</label>
        <input type="date" name="last_working_day" class="w-full border rounded p-2" required>
      </div>

      <div>
        <label class="block text-sm mb-1">الراتب الأساسي (لقطة)</label>
        <input type="number" step="0.01" name="basic_salary_snapshot" class="w-full border rounded p-2" required>
      </div>

      <div>
        <label class="block text-sm mb-1">الأجر اليومي (لقطة)</label>
        <input type="number" step="0.01" name="daily_wage_snapshot" class="w-full border rounded p-2" required>
      </div>

      <div>
        <label class="block text-sm mb-1">أيام الخدمة</label>
        <input type="number" name="service_days_total" class="w-full border rounded p-2" required>
      </div>

      <div>
        <label class="block text-sm mb-1">طريقة الصرف</label>
        <select name="pay_method" class="w-full border rounded p-2">
          <option value="bank">تحويل بنكي</option>
          <option value="cash">نقدًا</option>
          <option value="cheque">شيك</option>
        </select>
      </div>

      <div class="md:col-span-2">
        <label class="block text-sm mb-1">ملاحظة</label>
        <textarea name="reason_note" class="w-full border rounded p-2" rows="2"></textarea>
      </div>

      <div class="md:col-span-2 border-t pt-4">
        <div class="flex gap-4">
          <button type="submit" class="px-6 py-2 rounded bg-indigo-600 text-white">حفظ وإنشاء</button>
          <a href="index.php" class="px-6 py-2 rounded border">رجوع</a>
        </div>
      </div>
    </form>

    <div id="msg" class="mt-4"></div>
  </div>

<script>
document.getElementById('settlementForm').addEventListener('submit', async (e)=>{
  e.preventDefault();
  const fd = new FormData(e.target);
  const res = await fetch('api/create_settlement.php', { method:'POST', body:fd });
  const j = await res.json();
  const msg = document.getElementById('msg');
  if(j.ok){
    msg.innerHTML = `<div class="p-3 rounded bg-green-100 text-green-800">تم الإنشاء — كود: ${j.code}</div>`;
    setTimeout(()=>{ location.href = 'view.php?id='+j.id; }, 700);
  }else{
    msg.innerHTML = `<div class="p-3 rounded bg-red-100 text-red-800">خطأ: ${j.msg||'unknown'}</div>`;
  }
});
</script>
</body>
</html>