<?php
/* /erp_task_system/users/settlements/index.php */
session_start();
require_once '../../config/db.php';

$rows = $conn->query("SELECT s.id, s.code, s.status, s.last_working_day, s.net_amount, u.name AS emp_name
                      FROM settlements s
                      LEFT JOIN users u ON u.id=s.employee_id
                      ORDER BY s.id DESC LIMIT 100")->fetchAll(PDO::FETCH_ASSOC);
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8"/>
  <title>المخالصات</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-slate-50 min-h-screen">
  <div class="max-w-6xl mx-auto p-6">
    <div class="flex items-center justify-between mb-4">
      <h1 class="text-2xl font-bold">المخالصات</h1>
      <a class="px-4 py-2 rounded bg-indigo-600 text-white" href="create.php">+ مخالصة جديدة</a>
    </div>
    <div class="bg-white rounded-xl shadow overflow-x-auto">
      <table class="min-w-full text-sm">
        <thead>
          <tr class="bg-slate-100">
            <th class="p-2">#</th><th class="p-2">الكود</th><th class="p-2">الموظف</th>
            <th class="p-2">الحالة</th><th class="p-2">آخر يوم</th><th class="p-2">الصافي</th><th class="p-2">عرض</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach($rows as $r): ?>
          <tr class="border-b">
            <td class="p-2"><?= (int)$r['id'] ?></td>
            <td class="p-2"><?= htmlspecialchars($r['code']) ?></td>
            <td class="p-2"><?= htmlspecialchars($r['emp_name'] ?: '-') ?></td>
            <td class="p-2"><?= htmlspecialchars($r['status']) ?></td>
            <td class="p-2"><?= htmlspecialchars($r['last_working_day']) ?></td>
            <td class="p-2"><?= number_format((float)$r['net_amount'],2) ?></td>
            <td class="p-2"><a class="px-3 py-1 rounded bg-slate-800 text-white" href="view.php?id=<?= (int)$r['id'] ?>">فتح</a></td>
          </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</body>
</html>
