<?php
session_start();
require_once '../config/db.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (!isset($_SESSION['user'])) { header("Location: login.php"); exit; }
$user = $_SESSION['user'];
$form_id = intval($_POST['id'] ?? 0);
$action = $_POST['action'] ?? '';
if (!$form_id || !in_array($action, ['accept', 'reject'])) { die("طلب غير صحيح"); }

// تحقق أن الموظف هو صاحب النموذج
$stmt = $conn->prepare("SELECT * FROM asset_hand_over_forms WHERE id = ? AND employee_id = ?");
$stmt->execute([$form_id, $user['id']]);
$form = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$form) { die("غير مصرح"); }

if ($action == 'accept') {
    $stmt = $conn->prepare("UPDATE asset_hand_over_forms SET employee_approval = 'مقبولة', signed_at = NOW() WHERE id = ?");
    $stmt->execute([$form_id]);

    $stmt = $conn->prepare("UPDATE asset_requests SET status = 'تم التسليم' WHERE id = ?");
    $stmt->execute([$form['asset_request_id']]);

    $_SESSION['success'] = "تم توقيع النموذج وتم استلام العهدة.";
} else {
    $stmt = $conn->prepare("UPDATE asset_hand_over_forms SET employee_approval = 'مرفوضة', signed_at = NOW() WHERE id = ?");
    $stmt->execute([$form_id]);

    $stmt = $conn->prepare("UPDATE asset_requests SET status = 'مرفوض من الموظف' WHERE id = ?");
    $stmt->execute([$form['asset_request_id']]);

    $_SESSION['error'] = "تم رفض توقيع النموذج.";
}


header("Location: profile.php");
exit;