<?php
/* /erp_task_system/users/social_insurance/index.php */
session_start();
require_once '../../config/db.php';
require_once '../../authorize.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// الصلاحيات (عدّلها اذا ودك)
allow_roles(['admin','manager','user']);

$user = $_SESSION['user'] ?? [];
$color = $user['color'] ?? ['hex_code'=>'#f8fafc','text_color'=>'#111827','nav_color'=>'#233a58','second_text_color'=>'#94a3b8','chart_color'=>'#4d70f4'];
$userThemeColor            = $color['hex_code'];
$userThemeTextColor        = $color['text_color'];
$userThemeSecondTextColor  = $color['second_text_color'];
$userThemeNavColor         = $color['nav_color'];

// باراميترات بسيطة
$search = trim($_GET['q'] ?? '');
$onlyDiff = isset($_GET['diff']) && $_GET['diff'] == '1';
$perPage = max(10, min(100, (int)($_GET['pp'] ?? 20)));
$page = max(1, (int)($_GET['p'] ?? 1));
$offset = ($page - 1) * $perPage;

// فلترة اختيارية بالإدارة
$departments = $conn->query("SELECT id, name FROM departments ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);
$dept = isset($_GET['dept']) && $_GET['dept'] !== '' ? (int)$_GET['dept'] : null;

// لنفس الشكل: نجيب اسم الإدارة داخل الاستعلام
$baseSql = "
  FROM users u
  JOIN social_insurance si ON si.national_id = u.national_id
  LEFT JOIN departments d ON u.department_id = d.id
  WHERE 1
";

$params = [];
if ($search !== '') {
  $baseSql .= " AND (u.name LIKE :q OR u.email LIKE :q OR u.national_id LIKE :q OR si.gosi_number LIKE :q) ";
  $params[':q'] = '%'.$search.'%';
}
if ($dept) {
  $baseSql .= " AND u.department_id = :dept ";
  $params[':dept'] = $dept;
}
if ($onlyDiff) {
  $baseSql .= " AND (u.salary IS NOT NULL AND si.salary IS NOT NULL AND u.salary <> si.salary) ";
}

// العدّ الكلي
$countStmt = $conn->prepare("SELECT COUNT(*) ".$baseSql);
$countStmt->execute($params);
$totalRows = (int)$countStmt->fetchColumn();
$totalPages = max(1, (int)ceil($totalRows / $perPage));

// جلب البيانات
$listSql = "
  SELECT 
    u.id AS user_id, u.name, u.email, u.employee_number, u.national_id,
    u.salary AS system_salary, u.job_title,
    d.name AS department_name,
    si.gosi_number, si.salary AS gosi_salary, si.subscription_date, si.end_date, si.status, si.last_updated
  ".$baseSql."
  ORDER BY u.name ASC
  LIMIT :limit OFFSET :offset
";
$listStmt = $conn->prepare($listSql);
foreach ($params as $k=>$v) $listStmt->bindValue($k, $v);
$listStmt->bindValue(':limit',  $perPage, PDO::PARAM_INT);
$listStmt->bindValue(':offset', $offset,  PDO::PARAM_INT);
$listStmt->execute();
$rows = $listStmt->fetchAll(PDO::FETCH_ASSOC);

// تصدير CSV (إذا طلب)
if (isset($_GET['export']) && $_GET['export'] == '1') {
  header('Content-Type: text/csv; charset=UTF-8');
  header('Content-Disposition: attachment; filename="social_insurance_export.csv"');
  $out = fopen('php://output', 'w');
  // BOM لفتح عربي مضبوط في إكسل
  fprintf($out, chr(0xEF).chr(0xBB).chr(0xBF));
  fputcsv($out, ['الاسم','الهوية','الوظيفي','الإدارة','البريد','رقم المشترك','راتب النظام','راتب التأمينات','بداية الاشتراك','نهاية الاشتراك','الحالة','آخر تحديث']);
  foreach ($rows as $r) {
    fputcsv($out, [
      $r['name'], $r['national_id'], $r['employee_number'], $r['department_name'], $r['email'],
      $r['gosi_number'], $r['system_salary'], $r['gosi_salary'],
      $r['subscription_date'], $r['end_date'], $r['status'], $r['last_updated']
    ]);
  }
  fclose($out);
  exit;
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>🧾 التأمينات الاجتماعية - الموظفون المسجّلون</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    body, .main-card { background-color: <?= $userThemeColor ?> !important; }
    .card, nav { background-color: <?= $userThemeNavColor ?> !important; }
    .text, th, td, label, input, select, a { color: <?= $userThemeTextColor ?> !important; }
    .badge { padding: 2px 8px; border-radius: 8px; font-size: 12px; }
    .badge-active { background:#22c55e; color:#0e162a; }
    .badge-stopped { background:#fda4af; color:#0e162a; }
    .badge-suspended { background:#fde047; color:#0e162a; }
    .diff { background: #fff3cd; color:#0e162a; border-radius: 8px; padding: 2px 6px; font-size: 12px; }
    .toolbar a { border-radius:12px; }
  </style>
</head>
<body class="text-right">

<?php include $_SERVER['DOCUMENT_ROOT'] . '/erp_task_system/navbar/navbar.php'; ?>
<div class="h-20"></div>

<div class="max-w-7xl mx-auto main-card p-4 rounded shadow">
  <div class="flex flex-wrap items-center justify-between gap-3 mb-4 toolbar">
    <h1 class="text text-xl font-bold">🧾 الموظفون المسجّلون بالتأمينات</h1>
    <div class="flex gap-2">
      <a href="	insurance_import.php" class="bg-emerald-600 hover:bg-emerald-700 text-white px-4 py-2">⬆️ استيراد CSV/Excel</a>
      <a href="?<?= http_build_query(array_merge($_GET, ['export'=>1,'p'=>1])) ?>" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2">📤 تصدير CSV (المعروض)</a>
      <a href="/erp_task_system/users/index.php" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2">👥 رجوع للمستخدمين</a>
    </div>
  </div>

  <!-- فلاتر -->
  <form method="get" class="grid grid-cols-1 md:grid-cols-4 gap-3 mb-4">
    <input type="text" name="q" value="<?= htmlspecialchars($search,ENT_QUOTES,'UTF-8') ?>" placeholder="بحث: اسم/بريد/هوية/رقم مشترك" class="border rounded px-3 py-2">
    <select name="dept" class="border rounded px-3 py-2">
      <option value="">كل الإدارات</option>
      <?php foreach($departments as $d): ?>
        <option value="<?= $d['id'] ?>" <?= $dept===$d['id'] ? 'selected':'' ?>><?= htmlspecialchars($d['name']) ?></option>
      <?php endforeach; ?>
    </select>
    <label class="flex items-center gap-2">
      <input type="checkbox" name="diff" value="1" <?= $onlyDiff?'checked':''; ?>>
      <span>إظهار المختلف (راتب النظام ≠ التأمينات)</span>
    </label>
    <div class="flex gap-2">
      <button class="bg-indigo-600 hover:bg-indigo-700 text-white px-4 py-2 rounded">بحث</button>
      <a href="index.php" class="bg-gray-500 hover:bg-gray-600 text-white px-4 py-2 rounded">إعادة تعيين</a>
    </div>
  </form>

  <!-- الجدول -->
  <div class="overflow-x-auto">
    <table class="card w-full text-sm border rounded">
      <thead>
        <tr>
          <th class="p-2 border">الاسم</th>
          <th class="p-2 border">الهوية</th>
          <th class="p-2 border">الوظيفي</th>
          <th class="p-2 border">الإدارة</th>
          <th class="p-2 border">البريد</th>
          <th class="p-2 border">رقم المشترك</th>
          <th class="p-2 border">راتب النظام</th>
          <th class="p-2 border">راتب التأمينات</th>
          <th class="p-2 border">الحالة</th>
          <th class="p-2 border">بداية</th>
          <th class="p-2 border">نهاية</th>
          <th class="p-2 border">آخر تحديث</th>
          <th class="p-2 border">إجراءات</th>
        </tr>
      </thead>
      <tbody>
        <?php if(empty($rows)): ?>
          <tr><td class="p-3 text-center" colspan="13">ما فيه بيانات مطابقة لفلترك الحالي.</td></tr>
        <?php else: foreach($rows as $r): 
          $isDiff = is_numeric($r['system_salary']) && is_numeric($r['gosi_salary']) && ((float)$r['system_salary'] != (float)$r['gosi_salary']);
          $badge = 'badge-active';
          if ($r['status']==='stopped')   $badge = 'badge-stopped';
          if ($r['status']==='suspended') $badge = 'badge-suspended';
        ?>
          <tr class="<?= $isDiff ? '' : '' ?>">
            <td class="p-2 border">
              <div class="font-bold"><?= htmlspecialchars($r['name']) ?></div>
              <div class="text-xs opacity-80"><?= htmlspecialchars($r['job_title'] ?? '') ?></div>
              <?php if($isDiff): ?><div class="diff mt-1 inline-block">اختلاف راتب</div><?php endif; ?>
            </td>
            <td class="p-2 border"><?= htmlspecialchars($r['national_id']) ?></td>
            <td class="p-2 border"><?= htmlspecialchars($r['employee_number']) ?></td>
            <td class="p-2 border"><?= htmlspecialchars($r['department_name'] ?? '—') ?></td>
            <td class="p-2 border"><?= htmlspecialchars($r['email']) ?></td>
            <td class="p-2 border"><?= htmlspecialchars($r['gosi_number'] ?? '—') ?></td>
            <td class="p-2 border"><?= $r['system_salary'] !== null ? number_format((float)$r['system_salary'],2) : '—' ?></td>
            <td class="p-2 border"><?= $r['gosi_salary']    !== null ? number_format((float)$r['gosi_salary'],2)    : '—' ?></td>
            <td class="p-2 border">
              <span class="badge <?= $badge ?>">
                <?= $r['status']==='active'?'نشط':($r['status']==='stopped'?'موقوف':'معلق') ?>
              </span>
            </td>
            <td class="p-2 border"><?= htmlspecialchars($r['subscription_date'] ?? '—') ?></td>
            <td class="p-2 border"><?= htmlspecialchars($r['end_date'] ?? '—') ?></td>
            <td class="p-2 border"><?= htmlspecialchars($r['last_updated']) ?></td>
            <td class="p-2 border">
              <div class="flex gap-2">
                <a class="bg-green-600 hover:bg-green-700 text-white px-3 py-1 rounded"
                   href="/erp_task_system/users/edit.php?id=<?= (int)$r['user_id'] ?>">تعديل الموظف</a>
                <a class="bg-blue-600 hover:bg-blue-700 text-white px-3 py-1 rounded"
                   href="/erp_task_system/users/view.php?id=<?= (int)$r['user_id'] ?>">عرض</a>
              </div>
            </td>
          </tr>
        <?php endforeach; endif; ?>
      </tbody>
    </table>
  </div>

  <!-- ترقيم الصفحات -->
  <?php if ($totalPages > 1): ?>
    <div class="flex justify-center gap-2 mt-4">
      <?php
        // نحافظ على بقية الباراميترات
        $keep = $_GET; unset($keep['p']);
        for ($i=1; $i<=$totalPages; $i++):
          $link = '?'.http_build_query(array_merge($keep, ['p'=>$i]));
      ?>
        <a href="<?= $link ?>" class="px-3 py-1 rounded <?= $i==$page?'bg-blue-600 text-white':'bg-gray-300' ?>"><?= $i ?></a>
      <?php endfor; ?>
    </div>
  <?php endif; ?>

</div>
</body>
</html>
