<?php
require_once '../config/db.php';
require_once '../authorize.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  header("Location: add_training.php");
  exit;
}

// استقبال البيانات
$employee_id = $_POST['employee_id'] ?? null;
$course_name = trim($_POST['course_name'] ?? '');
$provider = trim($_POST['provider'] ?? '');
$course_date = $_POST['course_date'] ?? null;
$hours = $_POST['hours'] ?? 0;
$employee_feedback = trim($_POST['employee_feedback'] ?? '');
$certificate_path = null;

// التحقق من صحة البيانات
if (!$employee_id || !$course_name || !$provider || !$course_date || $hours <= 0) {
  echo "❌ بيانات ناقصة أو غير صحيحة.";
  exit;
}

// رفع الشهادة (اختياري)
if (isset($_FILES['certificate']) && $_FILES['certificate']['error'] === UPLOAD_ERR_OK) {
  $upload_dir = '../uploads/certificates/';
  if (!file_exists($upload_dir)) {
    mkdir($upload_dir, 0777, true);
  }

  $ext = pathinfo($_FILES['certificate']['name'], PATHINFO_EXTENSION);
  $new_filename = uniqid('cert_') . '.' . $ext;
  $destination = $upload_dir . $new_filename;

  if (move_uploaded_file($_FILES['certificate']['tmp_name'], $destination)) {
    $certificate_path = 'uploads/certificates/' . $new_filename;
  }
}

// حفظ الدورة
$stmt = $conn->prepare("
  INSERT INTO employee_trainings (employee_id, course_name, provider, course_date, hours, employee_feedback, certificate_path)
  VALUES (?, ?, ?, ?, ?, ?, ?)
");

$success = $stmt->execute([
  $employee_id, $course_name, $provider, $course_date, $hours, $employee_feedback, $certificate_path
]);

if ($success) {
  header("Location: add_training.php?success=1");
  exit;
} else {
  echo "❌ حصل خطأ أثناء الحفظ.";
}
