<?php
session_start();
require_once '../config/db.php';

if (!isset($_SESSION['user'])) { header("Location: login.php"); exit; }
$user = $_SESSION['user'];
$form_id = intval($_GET['id'] ?? 0);

// جلب بيانات النموذج
$stmt = $conn->prepare("SELECT 
    f.*, 
    a.asset_type_name, a.details AS request_details, a.user_id,
    u.name AS employee_name, u.employee_number
  FROM asset_hand_over_forms f
  JOIN asset_requests a ON f.asset_request_id = a.id
  JOIN users u ON a.user_id = u.id
  WHERE f.id = ?");
$stmt->execute([$form_id]);
$form = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$form) { echo "نموذج غير موجود"; exit; }
// تحقق أن المستخدم الحالي هو الموظف صاحب العهدة
if ($form['user_id'] != $user['id']) { echo "غير مصرح لك"; exit; }

// ألوان المستخدم
$color = $user['color'];
$userThemeColor = $color['hex_code'];
$userThemeTextColor = $color['text_color'];
$userThemeNavColor = $color['nav_color'];

// تجهيز رابط الفاتورة (إن وجد)
$invoice_file_url = '';
if (!empty($form['invoice_filename']) && !empty($form['employee_number'])) {
    $invoice_file_url = "../users/employee_files/{$form['employee_number']}/{$form['invoice_filename']}";
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>نموذج استلام العهدة</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    body, .main-card, tr:hover, a:hover { background-color: <?= $userThemeColor ?> !important; }
    nav, .select2-results__option, .select2-search, .select2-selection--multiple, li, .card { background-color: <?= $userThemeNavColor ?> !important; }
    .text, label, h3, option, h2, th, td, li, strong, select, input, a { color: <?= $userThemeTextColor ?> !important; }
    option { text-align: center; }
  </style>
</head>
<body class="bg-gray-50 min-h-screen text-right">
<?php include $_SERVER['DOCUMENT_ROOT'] . '/erp_task_system/navbar/navbar.php'; ?>

<div class="max-w-2xl mx-auto bg-white card rounded shadow p-8 mt-12">
    <h2 class="text-2xl font-bold mb-6 text-center">نموذج استلام العهدة</h2>

    <div class="mb-2"><b>اسم الموظف:</b> <?= htmlspecialchars($form['employee_name']) ?></div>
    <div class="mb-2">
  <b>رقم الموظف:</b>
  <?= $form['employee_number'] ? htmlspecialchars($form['employee_number']) : '(ID: ' . htmlspecialchars($form['user_id']) . ')' ?>
</div>

    <div class="mb-2"><b>رقم النموذج:</b> <?= htmlspecialchars($form['id']) ?></div>
    <div class="mb-2"><b>رقم طلب العهدة:</b> <?= htmlspecialchars($form['asset_request_id']) ?></div>
    <div class="mb-2"><b>نوع العهدة:</b> <?= htmlspecialchars($form['asset_type_name'] ?? '') ?> (ID: <?= htmlspecialchars($form['asset_type_id']) ?>)</div>
    <div class="mb-2"><b>تفاصيل الطلب:</b> <?= htmlspecialchars($form['request_details']) ?></div>
    <div class="mb-2"><b>تفاصيل العهدة:</b> <?= htmlspecialchars($form['details']) ?></div>
    <div class="mb-2"><b>الرقم التسلسلي:</b> <?= htmlspecialchars($form['serial_number']) ?></div>
    <div class="mb-2"><b>قيمة المنتج:</b> <?= $form['price'] ? htmlspecialchars($form['price']) . ' ريال' : '—' ?></div>
    <div class="mb-2"><b>الشروط:</b> <?= htmlspecialchars($form['terms']) ?></div>
    <div class="mb-2"><b>تاريخ التسليم:</b> <?= htmlspecialchars($form['handover_date']) ?></div>
    <div class="mb-2"><b>الحالة:</b> <?= htmlspecialchars($form['status']) ?></div>
    <div class="mb-2"><b>النص الاتفاقي:</b> <?= htmlspecialchars($form['agreement_text']) ?></div>
    <?php if ($invoice_file_url): ?>
      <div class="mb-2"><b>مرفق الفاتورة:</b>
        <a href="<?= $invoice_file_url ?>" target="_blank" class="text-blue-600 underline">عرض الفاتورة</a>
      </div>
    <?php endif; ?>
    <div class="mb-2"><b>تاريخ الإنشاء:</b> <?= htmlspecialchars($form['created_at']) ?></div>
    <?php if ($form['signed_at']): ?>
      <div class="mb-2 text-green-700"><b>تمت الموافقة من الموظف</b> في <?= htmlspecialchars($form['signed_at']) ?></div>
    <?php endif; ?>

    <?php if ($form['status'] === 'بانتظار موافقة الموظف' && (!$form['employee_approval'] || $form['employee_approval'] === '')): ?>
      <form method="POST" action="sign_asset_handover_form.php" class="mt-8 flex gap-4">
        <input type="hidden" name="id" value="<?= $form['id'] ?>">
        <button name="action" value="accept" class="bg-green-600 text-white px-6 py-2 rounded font-bold">أوافق</button>
        <button name="action" value="reject" class="bg-red-600 text-white px-6 py-2 rounded font-bold">أرفض</button>
      </form>
    <?php endif; ?>
</div>
</body>
</html>
