<?php
require_once '../config/db.php';

$employee_id = $_GET['employee_id'] ?? null;
$evaluation_date = $_GET['evaluation_date'] ?? null;
$period = $_GET['evaluation_period'] ?? 'monthly';

if (!$employee_id || !$evaluation_date) {
  echo "بيانات ناقصة";
  exit;
}

$end_date = $evaluation_date;
$start_date = date('Y-m-d', strtotime($period === 'monthly' ? '-1 month' : '-6 months', strtotime($evaluation_date)));

$stmt = $conn->prepare("
  SELECT title, status, updated_at 
  FROM tasks 
  WHERE assigned_to = ? AND updated_at BETWEEN ? AND ?
  ORDER BY updated_at DESC
");
$stmt->execute([$employee_id, $start_date, $end_date]);
$tasks = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="p-4">
  <h3 class="text-lg font-bold mb-3">📌 المهام المنجزة خلال الفترة (<?= $start_date ?> إلى <?= $end_date ?>)</h3>
  <?php if (count($tasks)): ?>
    <ul class="space-y-2 text-sm">
      <?php foreach ($tasks as $task): ?>
        <li class="border p-2 rounded bg-gray-100">
          <strong><?= htmlspecialchars($task['title']) ?></strong>
          <div class="text-gray-600">الحالة: <?= $task['status'] ?> | آخر تحديث: <?= $task['updated_at'] ?></div>
        </li>
      <?php endforeach; ?>
    </ul>
  <?php else: ?>
    <div class="text-gray-500">لا توجد مهام خلال هذه الفترة.</div>
  <?php endif; ?>
</div>
