<?php
session_start();
require_once '../config/db.php';
// جلب بيانات المستخدم والألوان (حسب نظامك)
$user = $_SESSION['user'];
$color = $user['color'];
$userThemeColor = $color['hex_code'];
$userThemeTextColor = $color['text_color'];
$userThemeNavColor = $color['nav_color'] ?? '#233a58';

// إضافة أو تعديل وقت الدوام
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name = $_POST['name'];
    $start_time = $_POST['start_time'];
    $end_time = $_POST['end_time'];
    $type = $_POST['type'];
    $notes = $_POST['notes'] ?? null;

    if (isset($_POST['id']) && $_POST['id']) {
        // تعديل
        $stmt = $conn->prepare("UPDATE work_shifts SET name=?, start_time=?, end_time=?, type=?, notes=? WHERE id=?");
        $stmt->execute([$name, $start_time, $end_time, $type, $notes, $_POST['id']]);
    } else {
        // إضافة جديد
        $stmt = $conn->prepare("INSERT INTO work_shifts (name, start_time, end_time, type, notes) VALUES (?, ?, ?, ?, ?)");
        $stmt->execute([$name, $start_time, $end_time, $type, $notes]);
    }
    header("Location: work_shifts.php");
    exit;
}

// حذف وقت دوام
if (isset($_GET['delete'])) {
    $stmt = $conn->prepare("DELETE FROM work_shifts WHERE id=?");
    $stmt->execute([$_GET['delete']]);
    header("Location: work_shifts.php");
    exit;
}

// جلب جميع الأوقات
$shifts = $conn->query("SELECT * FROM work_shifts ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>إدارة أوقات الدوام</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body { background: <?= $userThemeColor ?>; color: <?= $userThemeTextColor ?>;}
        .main-card { background: #fff; border-radius: 1.25rem; box-shadow: 0 2px 12px 0 #0001; }
        table th, table td { color: #222 !important; }
    </style>
</head>
<body>
    <?php include '../navbar/navbar.php'; ?>
    <div class="h-20"></div>
    <div class="max-w-3xl mx-auto mt-10 main-card p-8">
        <h1 class="text-2xl font-bold mb-6">إدارة أوقات الدوام</h1>
        <form method="post" class="mb-8 flex flex-wrap gap-4 items-end">
            <input type="hidden" name="id" id="shift_id">
            <div>
                <label class="block mb-1 font-bold">اسم الفترة</label>
                <input type="text" name="name" id="shift_name" required class="border p-2 rounded w-40">
            </div>
            <div>
                <label class="block mb-1 font-bold">بداية الدوام</label>
                <input type="time" name="start_time" id="shift_start" required class="border p-2 rounded w-32">
            </div>
            <div>
                <label class="block mb-1 font-bold">نهاية الدوام</label>
                <input type="time" name="end_time" id="shift_end" required class="border p-2 rounded w-32">
            </div>
            <div>
                <label class="block mb-1 font-bold">نوع الفترة</label>
                <select name="type" id="shift_type" class="border p-2 rounded w-28">
                    <option value="صباحي">صباحي</option>
                    <option value="مسائي">مسائي</option>
                    <option value="مخصص">مخصص</option>
                </select>
            </div>
            <div>
                <label class="block mb-1 font-bold">ملاحظات</label>
                <input type="text" name="notes" id="shift_notes" class="border p-2 rounded w-48">
            </div>
            <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded-xl hover:bg-blue-800 transition">حفظ</button>
            <button type="button" onclick="resetForm()" class="bg-gray-300 text-black px-6 py-2 rounded-xl hover:bg-gray-400 transition">جديد</button>
        </form>
        <table class="w-full text-center border rounded-xl overflow-hidden">
            <thead>
                <tr class="bg-gray-100">
                    <th>#</th>
                    <th>الاسم</th>
                    <th>البداية</th>
                    <th>النهاية</th>
                    <th>النوع</th>
                    <th>ملاحظات</th>
                    <th>إجراءات</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($shifts as $row): ?>
                <tr class="border-b hover:bg-gray-50">
                    <td><?= $row['id'] ?></td>
                    <td><?= htmlspecialchars($row['name']) ?></td>
                    <td><?= $row['start_time'] ?></td>
                    <td><?= $row['end_time'] ?></td>
                    <td><?= $row['type'] ?></td>
                    <td><?= htmlspecialchars($row['notes']) ?></td>
                    <td>
                        <button class="bg-yellow-400 px-3 py-1 rounded text-white mr-2" onclick="editShift(<?= htmlspecialchars(json_encode($row), ENT_QUOTES, 'UTF-8'); ?>)">تعديل</button>
                        <a href="?delete=<?= $row['id'] ?>" onclick="return confirm('هل أنت متأكد من حذف وقت الدوام؟')" class="bg-red-600 px-3 py-1 rounded text-white">حذف</a>
                    </td>
                </tr>
                <?php endforeach ?>
                <?php if (count($shifts) == 0): ?>
                <tr><td colspan="7" class="py-8 text-gray-400 font-bold">لا توجد أوقات دوام.</td></tr>
                <?php endif ?>
            </tbody>
        </table>
    </div>

    <script>
        function editShift(row) {
            document.getElementById('shift_id').value = row.id;
            document.getElementById('shift_name').value = row.name;
            document.getElementById('shift_start').value = row.start_time;
            document.getElementById('shift_end').value = row.end_time;
            document.getElementById('shift_type').value = row.type;
            document.getElementById('shift_notes').value = row.notes ?? '';
        }
        function resetForm() {
            document.getElementById('shift_id').value = '';
            document.getElementById('shift_name').value = '';
            document.getElementById('shift_start').value = '';
            document.getElementById('shift_end').value = '';
            document.getElementById('shift_type').value = 'صباحي';
            document.getElementById('shift_notes').value = '';
        }
    </script>
</body>
</html>
