<?php
require_once '../config/db.php';

// استقبال id الإدارة
$dep_id = $_GET['department_id'] ?? null;
if (!$dep_id) {
    header('Content-Type: application/json');
    echo json_encode(['fields' => [], 'stages' => []]);
    exit;
}

// جلب الحقول المخصصة المرتبطة بالإدارة
$fieldStmt = $conn->prepare("SELECT id, label FROM custom_fields WHERE department_id = ?");
$fieldStmt->execute([$dep_id]);
$fields = $fieldStmt->fetchAll(PDO::FETCH_ASSOC);

// جلب المراحل المرتبطة بالإدارة
$stageStmt = $conn->prepare("SELECT id, name FROM stages WHERE department_id = ?");
$stageStmt->execute([$dep_id]);
$stages = $stageStmt->fetchAll(PDO::FETCH_ASSOC);

// إرسال البيانات على هيئة JSON
header('Content-Type: application/json');
echo json_encode([
    'fields' => $fields,
    'stages' => $stages
]);
