<?php
require_once '../config/db.php';
require_once '../auth.php';

$user = $_SESSION['user'];
$role = $user['role'];
$department_id = $user['department_id'];

$defaultFields = [
    'title' => 'عنوان المهمة',
    'description' => 'وصف المهمة',
    'created_at' => 'تاريخ الإنشاء',
    'due_date' => 'تاريخ الاستحقاق',
    'assigned_to' => 'المسؤول'
];

if ($role === 'admin') {
    $departments = $conn->query("SELECT id, name FROM departments")->fetchAll(PDO::FETCH_ASSOC);
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>📊 إنشاء تقرير مخصص</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
</head>
<body class="bg-gray-100 p-6">

<h1 class="text-2xl font-bold mb-6">📊 إنشاء تقرير مخصص</h1>

<form id="reportForm" class="space-y-6 bg-white p-6 rounded shadow max-w-4xl">
<?php if ($role === 'admin'): ?>
    <div>
        <label class="block mb-2 font-medium">الإدارة</label>
        <select id="department_id" name="department_id" class="w-full border px-3 py-2 rounded" required>
            <option value="">اختر الإدارة</option>
            <?php foreach ($departments as $dep): ?>
                <option value="<?= $dep['id'] ?>"><?= htmlspecialchars($dep['name']) ?></option>
            <?php endforeach; ?>
        </select>
    </div>
<?php else: ?>
    <input type="hidden" id="department_id" name="department_id" value="<?= $department_id ?>">
<?php endif; ?>

<div id="fieldsContainer" class="mb-6">
    <label class="block mb-2 font-bold">📋 اختر الأعمدة:</label>
    <div id="fieldsGrid" class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4">
        <?php foreach ($defaultFields as $field => $label): ?>
            <label class="inline-flex items-center">
                <input type="checkbox" name="fields[]" value="<?= $field ?>" class="mr-2" checked>
                <?= $label ?>
            </label>
        <?php endforeach; ?>
    </div>
</div>

<div id="stageContainer" class="mt-4 hidden">
    <label class="block mb-2 font-bold">🎯 اختر المرحلة (اختياري)</label>
    <select name="stage_ids[]" id="stage_id" class="w-full border px-3 py-2 rounded" multiple></select>
</div>

<div class="grid grid-cols-2 gap-4">
    <div>
        <label class="block mb-2 font-medium">من تاريخ</label>
        <input type="date" name="from_date" class="w-full border px-3 py-2 rounded">
    </div>
    <div>
        <label class="block mb-2 font-medium">إلى تاريخ</label>
        <input type="date" name="to_date" class="w-full border px-3 py-2 rounded">
    </div>
</div>

<div class="flex gap-4">
  <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded hover:bg-blue-700">🔍 عرض التقرير</button>
  <button type="reset" class="bg-gray-500 text-white px-4 py-2 rounded hover:bg-gray-600">♻️ إعادة تعيين</button>
</div>
</form>

<div id="exportButtons" class="flex gap-4 mt-8"></div>
<div id="reportTable" class="mt-6"></div>

<script>
let latestReportTable = null;

$(document).ready(function() {
    $('#department_id').on('change', function() {
        const depId = $(this).val();
        if (!depId) return;

        axios.get('get_fields_api.php?department_id=' + depId)
            .then(response => {
                const { fields, stages } = response.data;

                let defaultFields = {
                    'title': 'عنوان المهمة',
                    'description': 'وصف المهمة',
                    'created_at': 'تاريخ الإنشاء',
                    'due_date': 'تاريخ الاستحقاق',
                    'assigned_to': 'المسؤول'
                };

                $('#fieldsGrid').empty();

                $.each(defaultFields, function(key, value) {
                    $('#fieldsGrid').append(`
                        <label class="inline-flex items-center">
                            <input type="checkbox" name="fields[]" value="${key}" class="mr-2" checked>
                            ${value}
                        </label>
                    `);
                });

                $.each(fields, function(index, field) {
                    $('#fieldsGrid').append(`
                        <label class="inline-flex items-center">
                            <input type="checkbox" name="fields[]" value="custom_${field.id}" class="mr-2">
                            ${field.label}
                        </label>
                    `);
                });

                $('#stage_id').empty();
                stages.forEach(stage => {
                    $('#stage_id').append(`<option value="${stage.id}">${stage.name}</option>`);
                });

                $('#stage_id').select2({ placeholder: 'اختر مرحلة أو أكثر', allowClear: true, width: '100%' });
                $('#stageContainer').removeClass('hidden');
            });
    });

    $('#reportForm').on('submit', function(e) {
        e.preventDefault();
        let form = new FormData(this);

        axios.post('run_report_api.php', form)
            .then(response => {
                $('#reportTable').html(response.data);
                latestReportTable = document.querySelector('#reportTable table');
                $('#exportButtons').html(`
                    <button onclick="exportToExcel()" class="bg-green-600 text-white px-4 py-2 rounded">📥 Excel</button>
                    <button onclick="printReport()" class="bg-gray-700 text-white px-4 py-2 rounded">🖨️ طباعة</button>
                `);
            }).catch(() => alert('❌ حدث خطأ أثناء توليد التقرير'));
    });
});

function exportToExcel() {
    if (!latestReportTable) return;
    const wb = XLSX.utils.table_to_book(latestReportTable, {sheet: 'تقرير'});
    XLSX.writeFile(wb, 'تقرير.xlsx');
}

function printReport() {
    if (!latestReportTable) return;
    const printWindow = window.open('', '_blank');
    printWindow.document.write('<html><head><title>طباعة التقرير</title></head><body>');
    printWindow.document.write(latestReportTable.outerHTML);
    printWindow.document.write('</body></html>');
    printWindow.document.close();
    printWindow.print();
}
</script>

</body>
</html>
