<?php
require_once '../config/db.php';

$department_id = $_POST['department_id'] ?? null;
$fields = $_POST['fields'] ?? [];
$from_date = $_POST['from_date'] ?? null;
$to_date = $_POST['to_date'] ?? null;
$stage_ids = $_POST['stage_ids'] ?? [];

if (!$department_id || empty($fields)) {
    echo "<p class='text-red-600'>🚫 يجب اختيار الإدارة وبعض الأعمدة لعرض التقرير.</p>";
    exit;
}

$default_fields = ['title', 'description', 'created_at', 'due_date', 'assigned_to', 'stage_id'];
$selected_default_fields = [];
$selected_custom_fields = [];

foreach ($fields as $field) {
    if (in_array($field, $default_fields)) {
        $selected_default_fields[] = $field;
    } elseif (strpos($field, 'custom_') === 0) {
        $selected_custom_fields[] = str_replace('custom_', '', $field);
    }
}

$sql = "SELECT * FROM tasks WHERE department_id = ? AND is_deleted = 0";
$params = [$department_id];

if ($from_date) {
    $sql .= " AND created_at >= ?";
    $params[] = $from_date;
}
if ($to_date) {
    $sql .= " AND created_at <= ?";
    $params[] = $to_date;
}
if (!empty($stage_ids)) {
    $placeholders = implode(',', array_fill(0, count($stage_ids), '?'));
    $sql .= " AND stage_id IN ($placeholders)";
    $params = array_merge($params, $stage_ids);
}

$stmt = $conn->prepare($sql);
$stmt->execute($params);
$tasks = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (count($tasks) === 0) {
    echo "<p class='text-gray-500'>لا توجد نتائج مطابقة للفلترة المختارة.</p>";
    exit;
}

$custom_values = [];
$custom_labels = [];
if (!empty($selected_custom_fields)) {
    $task_ids = array_column($tasks, 'id');
    $in_tasks = implode(',', array_fill(0, count($task_ids), '?'));
    $in_fields = implode(',', array_fill(0, count($selected_custom_fields), '?'));

    $stmt_custom = $conn->prepare("SELECT * FROM task_custom_values WHERE task_id IN ($in_tasks) AND field_id IN ($in_fields)");
    $stmt_custom->execute(array_merge($task_ids, $selected_custom_fields));
    $custom_rows = $stmt_custom->fetchAll();

    foreach ($custom_rows as $row) {
        $custom_values[$row['task_id']][$row['field_id']] = $row['value'];
    }

    $stmt_labels = $conn->prepare("SELECT id, label FROM custom_fields WHERE id IN ($in_fields)");
    $stmt_labels->execute($selected_custom_fields);
    foreach ($stmt_labels->fetchAll() as $row) {
        $custom_labels[$row['id']] = $row['label'];
    }
}

$user_ids = array_column($tasks, 'assigned_to');
$userMap = [];
if (!empty($user_ids)) {
    $placeholders = implode(',', array_fill(0, count($user_ids), '?'));
    $stmt_users = $conn->prepare("SELECT id, name FROM users WHERE id IN ($placeholders)");
    $stmt_users->execute($user_ids);
    foreach ($stmt_users->fetchAll(PDO::FETCH_ASSOC) as $u) {
        $userMap[$u['id']] = $u['name'];
    }
}

$field_labels = [
    'title' => 'عنوان المهمة',
    'description' => 'وصف المهمة',
    'created_at' => 'تاريخ الإنشاء',
    'due_date' => 'تاريخ الاستحقاق',
    'assigned_to' => 'المسؤول',
    'stage_id' => 'المرحلة'
];

// بداية تحسين الطباعة
echo "<div class='overflow-x-auto'>";
echo "<table class='min-w-full text-sm text-right border-collapse border mt-6'>";
echo "<thead><tr class='bg-gray-200'>";
foreach ($fields as $field) {
    if (strpos($field, 'custom_') === 0) {
        $field_id = str_replace('custom_', '', $field);
        echo "<th class='px-4 py-2 border font-bold bg-gray-100'>" . htmlspecialchars($custom_labels[$field_id] ?? 'حقل إضافي') . "</th>";
    } else {
        echo "<th class='px-4 py-2 border font-bold bg-gray-100'>" . htmlspecialchars($field_labels[$field] ?? $field) . "</th>";
    }
}
echo "</tr></thead><tbody>";

$row_index = 0;
foreach ($tasks as $task) {
    $row_class = $row_index++ % 2 == 0 ? 'bg-white' : 'bg-gray-50';
    echo "<tr class='$row_class'>";
    foreach ($fields as $field) {
        if (in_array($field, $default_fields)) {
            $value = $task[$field] ?? '—';
            if ($field === 'assigned_to') {
                $value = $userMap[$value] ?? '—';
            }
            echo "<td class='px-4 py-2 border'>" . htmlspecialchars($value) . "</td>";
        } elseif (strpos($field, 'custom_') === 0) {
            $field_id = str_replace('custom_', '', $field);
            $value = $custom_values[$task['id']][$field_id] ?? '—';
            echo "<td class='px-4 py-2 border'>" . htmlspecialchars($value) . "</td>";
        }
    }
    echo "</tr>";
}
echo "</tbody></table>";
echo "</div>";
?>
