<?php
require_once '../config/db.php';
header('Content-Type: application/json');

// فقط POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  http_response_code(405);
  echo json_encode(['success' => false, 'message' => '❌ يرجى استخدام POST فقط']);
  exit;
}

// التحقق من تفعيل webhook من الإعدادات
$stmt = $conn->prepare("SELECT value FROM integration_settings WHERE name = 'webhook_enabled'");
$stmt->execute();
$enabled = $stmt->fetchColumn();
if ($enabled != '1') {
  echo json_encode(['success' => false, 'message' => '❌ استقبال الطلبات معطّل من الإعدادات']);
  exit;
}

// جلب مفتاح API من الإعدادات
$stmt = $conn->prepare("SELECT value FROM integration_settings WHERE name = 'api_key'");
$stmt->execute();
$expected_key = $stmt->fetchColumn();

// التحقق من المفتاح المرسل
$api_key = $_POST['api_key'] ?? '';
if ($api_key !== $expected_key) {
  echo json_encode(['success' => false, 'message' => '🔒 مفتاح غير صحيح']);
  exit;
}

// قراءة البيانات
$title = $_POST['title'] ?? '';
$description = $_POST['description'] ?? '';
$department_id = $_POST['department_id'] ?? null;
$stage_id = $_POST['stage_id'] ?? null;
$requested_by = $_POST['requested_by'] ?? 'مستخدم خارجي';

// تحقق من البيانات
if (!$title || !$department_id) {
  echo json_encode(['success' => false, 'message' => '❌ بيانات غير مكتملة']);
  exit;
}

// جلب مرحلة افتراضية إذا ما تم تحديدها
if (!$stage_id) {
  $stmt = $conn->prepare("SELECT id FROM stages WHERE department_id = ? ORDER BY id ASC LIMIT 1");
  $stmt->execute([$department_id]);
  $stage_id = $stmt->fetchColumn();
}

// إنشاء المهمة
$stmt = $conn->prepare("INSERT INTO tasks (title, description, department_id, stage_id, created_at) VALUES (?, ?, ?, ?, NOW())");
$stmt->execute([$title, $description, $department_id, $stage_id]);
$task_id = $conn->lastInsertId();

// إضافة تعليق باسم مقدم الطلب
if ($requested_by && $task_id) {
  $stmt = $conn->prepare("INSERT INTO comments (task_id, user_id, comment_text, created_at) VALUES (?, NULL, ?, NOW())");
  $stmt->execute([$task_id, "الطلب مقدم بواسطة: " . $requested_by]);
}

// تسجيل في سجل الطلبات
$log_stmt = $conn->prepare("INSERT INTO webhook_logs (api_key, task_id, request_data, ip_address, status) VALUES (?, ?, ?, ?, ?)");
$request_data_json = json_encode($_POST, JSON_UNESCAPED_UNICODE);
$ip_address = $_SERVER['REMOTE_ADDR'] ?? 'UNKNOWN';
$log_stmt->execute([$api_key, $task_id, $request_data_json, $ip_address, 'success']);

// الرد
echo json_encode([
  'success' => true,
  'message' => '✅ تم إنشاء المهمة بنجاح',
  'task_id' => $task_id
]);
