<?php
/* /erp_task_system/integrations/help.php */
session_start();
ini_set('display_errors',1);
ini_set('display_startup_errors',1);
error_reporting(E_ALL);

require_once '../config/db.php';
$authz = __DIR__ . '/../authorize.php';
$auth  = __DIR__ . '/../auth.php';
if (file_exists($authz)) require_once $authz;
if (file_exists($auth))  require_once $auth;

/* يفضّل الأدمن فقط */
if (!isset($_SESSION['user']) || ($_SESSION['user']['role'] ?? '') !== 'admin') {
  header('Location: ../unauthorized.php'); exit;
}

$user  = $_SESSION['user'];
$color = $user['color'] ?? [
  'hex_code'          => '#0b1023',
  'second_text_color' => '#e9eefb',
  'text_color'        => '#e9eefb',
  'nav_color'         => '#121b35',
];
$userThemeColor           = $color['hex_code'];
$userThemeSecondTextColor = $color['second_text_color'];
$userThemeTextColor       = $color['text_color'];
$userThemeNavColor        = $color['nav_color'];

/* روابط ذكيّة للرجوع */
function firstExistingRelative(array $cands){ foreach($cands as $p){ if(file_exists(__DIR__.'/'.$p)) return $p; } return $cands[0]??'#'; }
$settingsHref = firstExistingRelative(['index.php','settings.php','integration_settings.php','integrations.php']);
$webhookHref  = firstExistingRelative(['webhook.php','hooks/webhook.php']);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8"/>
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <title>📘 تعليمات إعدادات الربط</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
:root{
  --bg:   <?= $userThemeColor ?>;
  --panel:<?= $userThemeNavColor ?>;
  --ink:  <?= $userThemeTextColor ?>;
  --ink-2:<?= $userThemeSecondTextColor ?>;
  --ring:#c7d2fe; --ok:#16a34a; --warn:#f59e0b; --err:#ef4444; --primary:#6f7dfb; --muted:#9aa3b2;
}
body{ background:var(--bg); color:var(--ink); }
.card{ background:var(--panel); border:1px solid rgba(255,255,255,.07); border-radius:1rem; }
.section{ padding:1rem; }
.h1{ font-size:1.5rem; font-weight:800; }
.h2{ font-size:1.125rem; font-weight:800; }
.lead{ color:var(--ink-2); opacity:.95 }
.toc a{ display:block; padding:.5rem .75rem; border-radius:.6rem; background:rgba(255,255,255,.05); }
.toc a:hover{ background:rgba(255,255,255,.1); }
.callout{ border-radius:.75rem; padding:.75rem .9rem; background:rgba(255,255,255,.06); border:1px dashed rgba(255,255,255,.2); }
.callout.ok{   border-color:rgba(16,185,129,.45) }
.callout.warn{ border-color:rgba(245,158,11,.45) }
.kbd{ font-family: ui-monospace, Menlo, Consolas, monospace; background:rgba(255,255,255,.08); padding:.1rem .45rem; border-radius:.4rem; font-size:.85em; }
.anchor{ scroll-margin-top:7rem }

/* طباعة A4 */
@page { size: A4 portrait; margin: 10mm 10mm 14mm 10mm; }
.print-only{ display:none; }
@media print{
  :root{ --panel:#fff; --ink:#111827; --ink-2:#374151; }
  html,body{ background:#fff!important; color:#111827!important; -webkit-print-color-adjust:exact; print-color-adjust:exact; }
  body{ font-size:11pt; line-height:1.55; counter-reset:page; }
  .no-print, nav, .navbar, [onclick], a[href^="javascript:"], #contact{ display:none!important; }
  .print-header,.print-footer{ display:block!important; position:fixed; left:0; right:0; background:#fff; color:#6b7280; }
  .print-header{ top:0; padding:6px 10mm; border-bottom:1px solid #e5e7eb; }
  .print-footer{ bottom:0; padding:6px 10mm; border-top:1px solid #e5e7eb; }
  .print-footer .page:after{ content:counter(page); }
  .print-footer .pages:after{ content:counter(pages); }
  .container-print{ margin-top:22mm!important; margin-bottom:18mm!important; }
  .max-w-5xl{ max-width:100%!important; }
  .card{ background:#fff!important; border:1px solid #e5e7eb!important; box-shadow:none!important; }
  .section{ padding:.6rem .8rem!important; }
  header.card.section{ padding:.8rem 1rem!important; }
  .h1{ font-size:16pt!important; margin:0 0 .25rem!important; }
  .h2{ font-size:13pt!important; margin:0 0 .2rem!important; }
  nav.toc{ display:block!important; columns:3; column-gap:8mm; }
  .toc a{ background:transparent!important; padding:.15rem 0!important; break-inside:avoid; }
  .callout,.card,.anchor{ break-inside:avoid; page-break-inside:avoid; }
}
  </style>
</head>
<body>
  <?php include $_SERVER['DOCUMENT_ROOT'].'/erp_task_system/navbar/navbar.php'; ?>
  <div class="h-20"></div>

<div class="max-w-5xl mx-auto px-4 space-y-6 container-print">

  <!-- طباعة -->
  <div class="print-only print-header">
    <div style="display:flex;align-items:center;justify-content:space-between;gap:12px;">
      <div style="display:flex;align-items:center;gap:10px;">
        <img src="/erp_task_system/assets/img/fav.png" alt="ASRA" style="height:24px;width:auto;">
        <strong>تعليمات إعدادات الربط</strong>
      </div>
      <div style="font-size:10pt"><?= date('Y-m-d H:i') ?></div>
    </div>
  </div>
  <div class="print-only print-footer">
    <div style="display:flex;align-items:center;justify-content:space-between;">
      <span>أسرع لتقنية المعلومات — 98RL</span>
      <span>صفحة <span class="page"></span> / <span class="pages"></span></span>
    </div>
  </div>

  <!-- رأس -->
  <header class="card section">
    <div class="flex items-start justify-between gap-3">
      <div>
        <h1 class="h1">📘 تعليمات استخدام «إعدادات الربط مع الأنظمة الخارجية»</h1>
        <p class="lead mt-1">
          من هنا تتحكم بمفتاح الـAPI وتفعيل استقبال <strong>Webhooks</strong> وربط <strong>واتساب</strong>.
          كل القيم تُخزَّن في جدول <span class="kbd">integration_settings</span>.
        </p>
      </div>
      <div class="no-print flex items-center gap-2">
        <a href="<?= htmlspecialchars($settingsHref) ?>" class="px-3 py-2 rounded-lg bg-indigo-600 hover:bg-indigo-700">⬅️ رجوع للإعدادات</a>
        <button onclick="window.print()" class="px-3 py-2 rounded-lg bg-emerald-600 hover:bg-emerald-700">🖨️ طباعة</button>
      </div>
    </div>
  </header>

  <!-- فهرس -->
  <nav class="card section toc grid sm:grid-cols-2 lg:grid-cols-3 gap-2">
    <a href="#fields">وش تعني الحقول؟</a>
    <a href="#save">حفظ الإعدادات</a>
    <a href="#db">ملاحظة على قاعدة البيانات</a>
    <a href="#webhook">ربط الـ Webhooks (مثال عملي)</a>
    <a href="#whatsapp">الربط مع واتساب</a>
    <a href="#security">نصائح أمان</a>
    <a href="#faq">أسئلة شائعة</a>
    <a href="#links">روابط سريعة</a>
  </nav>

  <!-- الحقول -->
  <section id="fields" class="card section anchor">
    <h2 class="h2 mb-2">وش تعني الحقول؟</h2>
    <ul class="list-disc pr-6 space-y-1">
      <li><strong>🔑 api_key</strong>: مفتاح سري تستخدمه الأنظمة الخارجية للوصول/التوقيع.</li>
      <li><strong>✅ webhook_enabled</strong>: إذا مفعّل نستقبل نداءات من جهات خارجية (Webhook Endpoint).</li>
      <li><strong>📱 whatsapp_enabled</strong>: تفعيل تكامل واتساب (حسب ما تبنونه من ربط لاحقاً).</li>
    </ul>
  </section>

  <!-- الحفظ -->
  <section id="save" class="card section anchor">
    <h2 class="h2 mb-2">حفظ الإعدادات</h2>
    <p>الصفحة تستخدم <span class="kbd">INSERT ... ON DUPLICATE KEY UPDATE</span> بمعنى: لو الاسم موجود، يحدّث القيمة.</p>
  </section>

  <!-- قاعدة البيانات -->
  <section id="db" class="card section anchor">
    <h2 class="h2 mb-2">ملاحظة على قاعدة البيانات</h2>
    <p>لازم يكون فيه <strong>مفتاح فريد</strong> على عمود <span class="kbd">name</span> عشان جملة <span class="kbd">ON DUPLICATE KEY</span> تشتغل صح.</p>
    <div class="callout ok mt-2">
      SQL مقترح:<br>
      <span class="kbd">ALTER TABLE integration_settings ADD UNIQUE KEY uq_name (name);</span>
    </div>
  </section>

  <!-- Webhook -->
  <section id="webhook" class="card section anchor">
    <h2 class="h2 mb-2">ربط الـ Webhooks (مثال عملي)</h2>
    <p>خلّ عندك ملف استقبال (مثال مقترح): <span class="kbd">/integrations/webhook.php</span>. داخل الملف:</p>
    <div class="callout">
      <pre class="kbd" style="white-space:pre-wrap;line-height:1.6;">
$raw = file_get_contents('php://input');
$apiKey = /* جبها من integration_settings */ '';
$theirSig = $_SERVER['HTTP_X_ASRAA_SIGNATURE'] ?? '';
$calcSig  = hash_hmac('sha256', $raw, $apiKey);
if (!hash_equals($calcSig, $theirSig)) { http_response_code(401); exit('bad sig'); }
// ✅ نفّذ المطلوب.. مثال: إنشاء مهمة/تحديث حالة.. ثم:
echo json_encode(['ok'=>true]);
      </pre>
    </div>
    <p class="mt-2">تقدر تختبر بـ cURL:</p>
    <div class="callout">
      <pre class="kbd" style="white-space:pre-wrap;line-height:1.6;">
RAW='{"event":"new_ticket","title":"طلب تجربة"}'
SIG=$(php -r "echo hash_hmac('sha256', \$argv[1], 'PUT_YOUR_API_KEY');" "$RAW")
curl -X POST <?= htmlspecialchars($webhookHref ?: '/integrations/webhook.php') ?> \
  -H "Content-Type: application/json" \
  -H "X-ASRAA-Signature: $SIG" \
  -d "$RAW"
      </pre>
    </div>
  </section>

  <!-- واتساب -->
  <section id="whatsapp" class="card section anchor">
    <h2 class="h2 mb-2">الربط مع واتساب</h2>
    <ul class="list-disc pr-6 space-y-1">
      <li>إذا بتربط WhatsApp Business (Meta)، عادة تحتاج: <span class="kbd">phone_number_id</span> + <span class="kbd">access_token</span>. ممكن تضيفها لاحقًا لنفس الجدول بأسماء مثل: <span class="kbd">wa_phone_id</span> / <span class="kbd">wa_token</span>.</li>
      <li>نفّذ الإرسال عبر Endpoint داخلي (مثال: <span class="kbd">/integrations/whatsapp_send.php</span>) ويقرأ الإعدادات من الجدول.</li>
    </ul>
  </section>

  <!-- الأمان -->
  <section id="security" class="card section anchor">
    <h2 class="h2 mb-2">نصائح أمان</h2>
    <ul class="list-disc pr-6 space-y-1">
      <li>بدّل (Rotate) مفتاح <span class="kbd">api_key</span> كل فترة، وعرّف آلية إبطال القديم.</li>
      <li>سوِّ Allowlist لعناوين IP اللي ترسلك Webhooks إذا أمكن.</li>
      <li>أضف Rate Limiting لملف الاستقبال.</li>
      <li>الواجهة هذي خليها للأدمن فقط (وهي كذلك هنا).</li>
      <li>أضف CSRF لفورم الحفظ لو بتوسع الصفحة.</li>
    </ul>
  </section>

  <!-- FAQ -->
  <section id="faq" class="card section anchor">
    <h2 class="h2 mb-2">أسئلة شائعة</h2>
    <ul class="list-disc pr-6 space-y-1">
      <li>حفظ الإعدادات ما يشتغل؟ → تأكد وجود فهرس فريد على <span class="kbd">name</span>.</li>
      <li>التوقيع يطلع خطأ؟ → راجع إنك تستخدم نفس <span class="kbd">api_key</span> وأن جسم الطلب مطابق للي وقّعت عليه.</li>
      <li>ودك تخفي/تُظهر مفتاح API في الواجهة؟ → بدّل <em>input</em> إلى <span class="kbd">type="password"</span> مع زر إظهار.</li>
    </ul>
  </section>

  <!-- روابط -->
  <section id="links" class="card section anchor">
    <h2 class="h2 mb-2">روابط سريعة</h2>
    <div class="flex flex-wrap gap-2">
      <a class="px-3 py-2 rounded-lg bg-indigo-600 hover:bg-indigo-700" href="<?= htmlspecialchars($settingsHref) ?>">⚙️ إعدادات الربط</a>
      <?php if ($webhookHref && $webhookHref !== '#'): ?>
        <a class="px-3 py-2 rounded-lg bg-emerald-600 hover:bg-emerald-700" href="<?= htmlspecialchars($webhookHref) ?>" target="_blank" rel="noopener">🔌 ملف Webhook</a>
      <?php endif; ?>
    </div>
  </section>

  <!-- تواصل -->
  <section id="contact" class="py-12 md:py-16">
    <div class="container mx-auto px-4 grid md:grid-cols-2 gap-8 items-start">
      <div class="card rounded-2xl p-6">
        <h2 class="text-xl md:text-2xl font-bold">خلّنا نتواصل</h2>
        <form id="contactForm" class="mt-4 grid gap-3">
          <input id="c_name"  class="border rounded-xl p-3 focus:outline-none focus:ring focus:ring-[var(--ring)]" type="text"  placeholder="الاسم" required/>
          <input id="c_email" class="border rounded-xl p-3 focus:outline-none focus:ring focus:ring-[var(--ring)]" type="email" placeholder="البريد الإلكتروني"/>
          <input id="c_phone" class="border rounded-xl p-3 focus:outline-none focus:ring focus:ring-[var(--ring)]" type="tel" placeholder="رقم الجوال"/>
          <textarea id="c_msg" class="border rounded-xl p-3 focus:outline-none focus:ring focus:ring-[var(--ring)]" rows="4" placeholder="وش تحتاج بالضبط؟" required></textarea>
          <button type="submit" class="bg-[var(--primary)] text-[var(--ink)] font-semibold px-5 py-3 rounded-xl">أرسل على واتساب</button>
          <p id="contactResult" class="text-sm mt-1 opacity-90"></p>
        </form>
      </div>
      <div>
        <h3 class="text-2xl font-bold">بيانات التواصل</h3>
        <ul class="mt-4 space-y-2" style="color:var(--muted)">
          <li>الموقع: 98RL.LINK</li>
          <li>البريد: 98rl@98rl.link</li>
          <li>واتساب: +966535500241</li>
        </ul>
        <a href="https://wa.me/966535500241" target="_blank" rel="noopener" class="mt-6 inline-flex items-center gap-2 bg-green-400 text-black font-semibold px-5 py-3 rounded-2xl">تواصل واتساب مباشر</a>
      </div>
    </div>
  </section>

</div>

<script>
/* إرسال واتساب مباشرة */
(function(){
  const f=document.getElementById('contactForm'); const r=document.getElementById('contactResult'); const WA='966535500241';
  if(!f) return;
  f.addEventListener('submit',e=>{
    e.preventDefault();
    const name=document.getElementById('c_name').value.trim();
    const email=document.getElementById('c_email').value.trim();
    const phone=document.getElementById('c_phone').value.trim();
    const msg=document.getElementById('c_msg').value.trim();
    if(!name||!msg){ r.textContent='الاسم والطلب مطلوبين'; return; }
    const txt=`طلب دعم جديد
————————
الاسم: ${name}
البريد: ${email||'-'}
الجوال: ${phone||'-'}
الصفحة: ${location.pathname}
————————
الطلب:
${msg}`;
    window.open(`https://wa.me/${WA}?text=${encodeURIComponent(txt)}`,'_blank');
    r.textContent='بيفتح لك واتساب برسالة جاهزة.. أرسلها ونخدمك 👍';
  });
})();
</script>

</body>
</html>
