<?php
require_once '../config/db.php';
require_once '../auth.php';

$title = "إدارة الربط مع الأنظمة الخارجية";
$user = $_SESSION['user'];
$color = $user['color'];
$userThemeColor = $color['hex_code'];
$userThemeTextColor = $color['text_color'];
$userThemeNavColor = $color['nav_color'];
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    
  <meta charset="UTF-8">
  <title><?= $title ?></title>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    body,
    .main-card,
    tr:hover,
    a:hover {
      background-color: <?php echo $userThemeColor; ?> !important;
    }

    nav,
    .select2-results__option,
    .select2-search,
    .select2-selection--multiple,
    li,
    .card {
      background-color: <?php echo $userThemeNavColor; ?> !important;
    }

    .text,
    label,h3,
    option,
    h2,
    th,
    td,
    li,
    select,
    input,
    a {
      color: <?php echo $userThemeTextColor; ?> !important;
    }

    option {
      text-align: center;
    }


    .view-button {
      background-color: #4d70f4;
color: #FFFFFF!important;
      width: 70px !important;
      border-radius: 15px !important;
      display: inline-block;
      text-align: center;
      padding: 5px 5px;
      text-decoration: none;
      box-sizing: border-box;

    }
  
  </style>
</head>
<script src="../assets/js/task_modal_functions.js"></script>
<?php include $_SERVER['DOCUMENT_ROOT'] . '/erp_task_system/navbar/navbar.php'; ?>

<body class="bg-gray-100 text-right">

  <div class="card p-6 rounded shadow max-w-4xl mx-auto">
    <h1 class="text text-2xl font-bold mb-4">🔗 <?= $title ?></h1>

    <table class="card w-full table-auto border border-gray-300 text-right">
      <thead class="">
        <tr>
          <th class="p-2">نوع التكامل</th>
          <th class="p-2">الوصف</th>
          <th class="p-2">الحالة</th>
          <th class="p-2">الإجراءات</th>
        </tr>
      </thead>
      <tbody>
        <tr class="border-t">
          <td class="p-2">📨 نموذج خارجي (Webhook)</td>
          <td class="p-2">استقبال الطلبات من نماذج خارجية</td>
          <td class="p-2 text-green-600" style="color:rgb(105, 227, 94) !important;">نشط</td>
          <td class="p-2">
            <a href="form_webhooks.php" class="text-blue-600 view-button" >إدارة</a>
          </td>
        </tr>
        <tr class="border-t">
          <td class="p-2">📱 واتساب</td>
          <td class="p-2">الربط مع واتساب عبر Twilio أو API</td>
          <td class="p-2 text-yellow-500" style="color:rgb(204, 239, 98) !important;">تحت الإنشاء</td>
          <td class="p-2">
            <a href="#" class="text-gray-400 cursor-not-allowed" style="color:rgb(177, 177, 177) !important;">قريباً</a>
          </td>
        </tr>
        <tr class="border-t">
          <td class="p-2">💼 CRM</td>
          <td class="p-2">مزامنة بيانات المهام مع نظام خارجي</td>
          <td class="p-2 text-yellow-500" style="color:rgb(204, 239, 98) !important;">تحت الإنشاء</td>
          <td class="p-2">
            <a href="#" class="text-gray-400 cursor-not-allowed" style="color:rgb(177, 177, 177) !important;">قريباً</a>
          </td>
        </tr>
        <tr class="border-t">
  <td class="p-2">📄 سجل الطلبات</td>
  <td class="p-2">عرض سجل الطلبات القادمة من النماذج الخارجية</td>
  <td class="p-2 text-blue-600" style="color:rgb(82, 79, 190) !important;">متاح</td>
  <td class="p-2">
    <a href="logs.php" class="text-blue-600 view-button" >عرض السجل</a>
  </td>
</tr>

      </tbody>
    </table>
  </div>

</body>
</html>
