<?php
require_once '../config/db.php';
require_once '../auth.php';

$title = "سجل الطلبات (Webhook Logs)";

// جلب السجلات من قاعدة البيانات
$stmt = $conn->query("SELECT * FROM webhook_logs ORDER BY id DESC LIMIT 100");
$logs = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title><?= $title ?></title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 p-6">

  <div class="bg-white p-6 rounded shadow max-w-6xl mx-auto overflow-auto">
    <h1 class="text-2xl font-bold mb-4"><?= $title ?></h1>

    <table class="w-full table-auto text-right border border-gray-300 text-sm">
      <thead class="bg-gray-200">
        <tr>
          <th class="p-2">#</th>
          <th class="p-2">API Key</th>
          <th class="p-2">IP</th>
          <th class="p-2">Task ID</th>
          <th class="p-2">الحالة</th>
          <th class="p-2">البيانات</th>
          <th class="p-2">التاريخ</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($logs as $log): ?>
          <tr class="border-t hover:">
            <td class="p-2"><?= $log['id'] ?></td>
            <td class="p-2 text-xs text-gray-500"><?= htmlspecialchars($log['api_key']) ?></td>
            <td class="p-2"><?= $log['ip_address'] ?></td>
            <td class="p-2"><?= $log['task_id'] ?: '-' ?></td>
            <td class="p-2">
              <?php if ($log['status'] === 'success'): ?>
                <span class="text-green-600 font-bold">✔</span>
              <?php else: ?>
                <span class="text-red-600 font-bold">✖</span>
              <?php endif; ?>
            </td>
            <td class="p-2 text-xs whitespace-pre-wrap break-words max-w-xs">
              <?= htmlspecialchars($log['request_data']) ?>
            </td>
            <td class="p-2 text-xs"><?= $log['created_at'] ?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>

</body>
</html>
