<?php
require_once '../config/db.php';
require_once '../auth.php';

$title = "إعدادات الربط مع الأنظمة الخارجية";

// التحديث عند الإرسال
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $api_key = $_POST['api_key'] ?? '';
  $webhook_enabled = isset($_POST['webhook_enabled']) ? 1 : 0;
  $whatsapp_enabled = isset($_POST['whatsapp_enabled']) ? 1 : 0;

  $settings = [
    'api_key' => $api_key,
    'webhook_enabled' => $webhook_enabled,
    'whatsapp_enabled' => $whatsapp_enabled,
  ];

  foreach ($settings as $key => $value) {
    $stmt = $conn->prepare("INSERT INTO integration_settings (name, value) VALUES (?, ?) ON DUPLICATE KEY UPDATE value = ?");
    $stmt->execute([$key, $value, $value]);
  }

  $message = "✅ تم حفظ الإعدادات بنجاح.";
}

// جلب الإعدادات
$stmt = $conn->query("SELECT name, value FROM integration_settings");
$settings = [];
foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $row) {
  $settings[$row['name']] = $row['value'];
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title><?= $title ?></title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 p-6">

<div class="bg-white p-6 rounded shadow max-w-2xl mx-auto">
  <div class="flex items-center gap-2 mb-4">
    <h1 class="text-2xl font-bold"><?= $title ?></h1>

    <!-- يسار في RTL -->
    <a href="help.php" target="_blank" rel="noopener"
       class="bg-indigo-600 text-white px-3 py-1 rounded rtl:mr-auto ltr:ml-auto no-print inline-flex items-center gap-1"
       title="تعليمات الإعدادات">❓ تعليمات</a>
  </div>

    <?php if (!empty($message)): ?>
      <div class=" text-green-700 p-3 rounded mb-4" style="background-color: #7be667;"><?= $message ?></div>
    <?php endif; ?>

    <form method="POST" class="space-y-4">
      <div>
        <label class="block font-semibold">🔑 مفتاح API العام</label>
        <input type="text" name="api_key" class="w-full border p-2 rounded" value="<?= htmlspecialchars($settings['api_key'] ?? '') ?>">
      </div>

      <div class="flex items-center">
        <input type="checkbox" name="webhook_enabled" id="webhook_enabled" <?= !empty($settings['webhook_enabled']) ? 'checked' : '' ?>>
        <label for="webhook_enabled" class="ml-2">✅ تفعيل استقبال من Webhooks</label>
      </div>

      <div class="flex items-center">
        <input type="checkbox" name="whatsapp_enabled" id="whatsapp_enabled" <?= !empty($settings['whatsapp_enabled']) ? 'checked' : '' ?>>
        <label for="whatsapp_enabled" class="ml-2">📱 تفعيل الربط مع واتساب</label>
      </div>

      <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">💾 حفظ الإعدادات</button>
    </form>
  </div>

</body>
</html>
