<?php
require_once '../config/db.php';
require_once '../auth.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  echo json_encode(['success' => false, 'message' => 'طلب غير صالح']);
  exit;
}

$data = json_decode(file_get_contents('php://input'), true);
$task_id = $data['task_id'] ?? null;
$content = $data['content'] ?? null;
$user_id = $_SESSION['user']['id'] ?? null;

if (!$task_id || !$content || !$user_id) {
  echo json_encode(['success' => false, 'message' => 'بيانات غير مكتملة']);
  exit;
}

try {
  $stmt = $conn->prepare("INSERT INTO task_comments (task_id, user_id, comment, created_at) VALUES (?, ?, ?, NOW())");
  $stmt->execute([$task_id, $user_id, $content]);
  echo json_encode(['success' => true]);
} catch (Exception $e) {
  echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
