<?php
// /erp_task_system/api/attendance.php
session_start();
require_once '../config/db.php';
header('Content-Type: application/json; charset=utf-8');

$user = $_SESSION['user'] ?? null;
if (!$user) { echo json_encode(['ok'=>false,'msg'=>'تحتاج تسجّل دخول']); exit; }
$user_id = intval($user['id'] ?? 0);

$action = $_REQUEST['action'] ?? 'status';
$location_id = intval($_REQUEST['location_id'] ?? 0);
$method = 'manual';

try {
  if ($action==='status') {
    // هل فيه حضور مفتوح اليوم؟
    $stmt = $conn->prepare("SELECT id, check_in, check_out FROM attendance WHERE user_id=? AND `date`=CURDATE() ORDER BY id DESC LIMIT 1");
    $stmt->execute([$user_id]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    echo json_encode(['ok'=>true,'data'=>$row]); exit;
  }

  if ($action==='checkin') {
    if (!$location_id) { echo json_encode(['ok'=>false,'msg'=>'اختر الموقع']); exit; }
    // تأكد ما فيه حضور مفتوح
    $stmt = $conn->prepare("SELECT id FROM attendance WHERE user_id=? AND `date`=CURDATE() AND check_out IS NULL");
    $stmt->execute([$user_id]);
    if ($stmt->fetchColumn()) { echo json_encode(['ok'=>false,'msg'=>'حضورك اليوم مفتوح مسبقًا']); exit; }

    $sql = "INSERT INTO attendance (user_id, `date`, check_in, status, note, created_at, method, location_id)
            VALUES (?, CURDATE(), NOW(), 'حاضر', CONCAT('من الموقع: ', ?), NOW(), ?, ?)";
    $conn->prepare($sql)->execute([$user_id, $location_id, $method, $location_id]);
    echo json_encode(['ok'=>true]); exit;
  }

  if ($action==='checkout') {
    // أغلق آخر حضور مفتوح اليوم
    $sql = "UPDATE attendance SET check_out=NOW(), status='انصرف' 
            WHERE user_id=? AND `date`=CURDATE() AND check_out IS NULL";
    $conn->prepare($sql)->execute([$user_id]);
    echo json_encode(['ok'=>true]); exit;
  }

  echo json_encode(['ok'=>false,'msg'=>'Action غير معروف']);
} catch (Throwable $e) {
  echo json_encode(['ok'=>false,'msg'=>'خطأ داخلي','err'=>$e->getMessage()]);
}
