<?php
// /erp_task_system/api/emergency_contacts.php
session_start();
require_once '../config/db.php';
header('Content-Type: application/json; charset=utf-8');

if (!isset($_SESSION['user'])) { echo json_encode(['ok'=>false,'msg'=>'login']); exit; }
$me   = $_SESSION['user'];
$role = $me['role'] ?? 'user';

$action  = $_REQUEST['action'] ?? 'list';
$user_id = intval($_REQUEST['user_id'] ?? 0);
if (!$user_id) { echo json_encode(['ok'=>false,'msg'=>'user_id']); exit; }

// صلاحيات
$canEditAll = in_array($role, ['admin','manager']);
if (!$canEditAll && $user_id !== intval($me['id'])) {
  echo json_encode(['ok'=>false,'msg'=>'forbidden']); exit;
}

try {
  if ($action === 'list') {
    $stmt = $conn->prepare("SELECT * FROM emergency_contacts WHERE user_id=? ORDER BY is_primary DESC, id DESC");
    $stmt->execute([$user_id]);
    echo json_encode(['ok'=>true,'data'=>$stmt->fetchAll(PDO::FETCH_ASSOC)]); exit;
  }

  if ($action === 'save') {
    $id          = intval($_POST['id'] ?? 0);
    $name        = trim($_POST['contact_name'] ?? '');
    $relation    = trim($_POST['relationship'] ?? '');
    $phone       = trim($_POST['phone'] ?? '');
    $alt_phone   = trim($_POST['alt_phone'] ?? '');
    $email       = trim($_POST['email'] ?? '');
    $address     = trim($_POST['address'] ?? '');
    $is_primary  = intval($_POST['is_primary'] ?? 0) ? 1 : 0;

    if ($name==='' || $phone==='') { echo json_encode(['ok'=>false,'msg'=>'name/phone']); exit; }
    if ($is_primary) $conn->prepare("UPDATE emergency_contacts SET is_primary=0 WHERE user_id=?")->execute([$user_id]);

    if ($id>0) {
      $sql = "UPDATE emergency_contacts SET contact_name=?, relationship=?, phone=?, alt_phone=?, email=?, address=?, is_primary=? WHERE id=? AND user_id=?";
      $conn->prepare($sql)->execute([$name,$relation,$phone,$alt_phone,$email,$address,$is_primary,$id,$user_id]);
    } else {
      $sql = "INSERT INTO emergency_contacts (user_id, contact_name, relationship, phone, alt_phone, email, address, is_primary) VALUES (?,?,?,?,?,?,?,?)";
      $conn->prepare($sql)->execute([$user_id,$name,$relation,$phone,$alt_phone,$email,$address,$is_primary]);
      $id = $conn->lastInsertId();
    }
    echo json_encode(['ok'=>true,'id'=>$id]); exit;
  }

  if ($action === 'delete') {
    $id = intval($_POST['id'] ?? 0);
    if (!$id) { echo json_encode(['ok'=>false,'msg'=>'id']); exit; }
    $conn->prepare("DELETE FROM emergency_contacts WHERE id=? AND user_id=?")->execute([$id,$user_id]);
    echo json_encode(['ok'=>true]); exit;
  }

  echo json_encode(['ok'=>false,'msg'=>'bad_action']);
} catch (Throwable $e) {
  echo json_encode(['ok'=>false,'msg'=>'error','err'=>$e->getMessage()]);
}