<?php
// /erp_task_system/api/family_members.php
session_start();
require_once '../config/db.php';
header('Content-Type: application/json; charset=utf-8');

if (!isset($_SESSION['user'])) { echo json_encode(['ok'=>false,'msg'=>'login']); exit; }
$me   = $_SESSION['user'];
$role = $me['role'] ?? 'user';

$action  = $_REQUEST['action'] ?? 'list';
$user_id = intval($_REQUEST['user_id'] ?? 0);
if (!$user_id) { echo json_encode(['ok'=>false,'msg'=>'user_id']); exit; }

// صلاحيات
$canEditAll = in_array($role, ['admin','manager']);
if (!$canEditAll && $user_id !== intval($me['id'])) {
  echo json_encode(['ok'=>false,'msg'=>'forbidden']); exit;
}

try {
  if ($action === 'list') {
    $stmt = $conn->prepare("SELECT * FROM family_members WHERE user_id=? ORDER BY id DESC");
    $stmt->execute([$user_id]);
    echo json_encode(['ok'=>true,'data'=>$stmt->fetchAll(PDO::FETCH_ASSOC)]); exit;
  }

  if ($action === 'save') {
    $id           = intval($_POST['id'] ?? 0);
    $name         = trim($_POST['name'] ?? '');
    $relationship = trim($_POST['relationship'] ?? '');
    $national_id  = trim($_POST['national_id'] ?? '');
    $birth_date   = trim($_POST['birth_date'] ?? '');
    $is_dep       = intval($_POST['is_dependent'] ?? 1) ? 1 : 0;

    if ($name==='' || $relationship==='') { echo json_encode(['ok'=>false,'msg'=>'name/rel']); exit; }

    $allowedRel = ['زوج','زوجة','ابن','ابنة','أب','أم','أخ','أخت','أخرى'];
    if (!in_array($relationship, $allowedRel)) $relationship = 'أخرى';

    if ($id>0) {
      $sql = "UPDATE family_members SET name=?, relationship=?, national_id=?, birth_date=?, is_dependent=? WHERE id=? AND user_id=?";
      $conn->prepare($sql)->execute([$name,$relationship,$national_id?:NULL,$birth_date?:NULL,$is_dep,$id,$user_id]);
    } else {
      $sql = "INSERT INTO family_members (user_id,name,relationship,national_id,birth_date,is_dependent) VALUES (?,?,?,?,?,?)";
      $conn->prepare($sql)->execute([$user_id,$name,$relationship,$national_id?:NULL,$birth_date?:NULL,$is_dep]);
      $id = $conn->lastInsertId();
    }
    echo json_encode(['ok'=>true,'id'=>$id]); exit;
  }

  if ($action === 'delete') {
    $id = intval($_POST['id'] ?? 0);
    if (!$id) { echo json_encode(['ok'=>false,'msg'=>'id']); exit; }
    $conn->prepare("DELETE FROM family_members WHERE id=? AND user_id=?")->execute([$id,$user_id]);
    echo json_encode(['ok'=>true]); exit;
  }

  echo json_encode(['ok'=>false,'msg'=>'bad_action']);
} catch (Throwable $e) {
  echo json_encode(['ok'=>false,'msg'=>'error','err'=>$e->getMessage()]);
}
