<?php
require_once '../config/db.php';
header('Content-Type: application/json');

$task_id = $_GET['task_id'] ?? null;

if (!$task_id) {
  echo json_encode(['success' => false, 'message' => 'رقم المهمة مفقود']);
  exit;
}

try {
  $stmt = $conn->prepare("
    SELECT tc.id, tc.comment, tc.created_at, u.name AS author_name
    FROM task_comments tc
    LEFT JOIN users u ON u.id = tc.user_id
    WHERE tc.task_id = ?
    ORDER BY tc.created_at ASC
  ");
  $stmt->execute([$task_id]);
  $comments = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo json_encode(['success' => true, 'comments' => $comments], JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
  echo json_encode([
    'success' => false,
    'message' => 'فشل في جلب التعليقات',
    'error' => $e->getMessage()
  ]);
}
