<?php
require_once '../config/db.php';
header('Content-Type: application/json');

$department_id = $_GET['department_id'] ?? null;

if (!$department_id) {
  echo json_encode(['success' => false, 'message' => 'رقم الإدارة مفقود']);
  exit;
}

try {
  $stmt = $conn->prepare("SELECT id, label, type FROM custom_fields WHERE department_id = ?");
  $stmt->execute([$department_id]);
  $fields = $stmt->fetchAll(PDO::FETCH_ASSOC);

  echo json_encode(['success' => true, 'fields' => $fields]);
} catch (Exception $e) {
  echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
