<?php
// /erp_task_system/api/iban_lookup.php
session_start();
require_once '../config/db.php';
header('Content-Type: application/json; charset=utf-8');

$iban = trim($_POST['iban'] ?? '');
if ($iban === '') { echo json_encode(['ok'=>false,'msg'=>'IBAN فارغ']); exit; }

try {
  // نطبع الـ IBAN: حروف كبيرة وبدون مسافات
  $ibanNorm = strtoupper(str_replace(' ', '', $iban));

  // الدولة من أول حرفين
  $cc = substr($ibanNorm, 0, 2);

  // bank_code يجي من الفنكشن + نطابق مع جدول البنوك
  $sql = "
    SELECT b.id AS bank_id, b.name_ar AS bank_name, b.swift_code, b.bank_code
    FROM banks b
    WHERE b.country_code = :cc
      AND b.bank_code = fn_iban_bank_code(:iban)
    LIMIT 1
  ";
  $stmt = $conn->prepare($sql);
  $stmt->execute([':cc'=>$cc, ':iban'=>$ibanNorm]);
  $row = $stmt->fetch(PDO::FETCH_ASSOC);

  if ($row) {
    echo json_encode(['ok'=>true] + $row); 
  } else {
    echo json_encode(['ok'=>false,'msg'=>'ما وجدنا بنك مطابق للآيبان']);
  }
} catch (Throwable $e) {
  echo json_encode(['ok'=>false,'msg'=>'خطأ داخلي','err'=>$e->getMessage()]);
}
