<?php
// ====== إعداد الجلسة والمخرجات ======
ob_start();                      // امسك أي خرج شارد من الملفات المضمّنة
session_start();
header('Content-Type: application/json; charset=utf-8');

// ====== تضمين الملفات ======
require_once '../config/db.php';
require_once '../auth.php';
// حطّه بعد require_once مباشرة
function hasCol(PDO $conn, string $table, string $col): bool {
  $stmt = $conn->prepare("SHOW COLUMNS FROM `$table` LIKE ?");
  $stmt->execute([$col]);
  return (bool)$stmt->fetch();
}

// ...
$cols = [
  'title'         => ':title',
  'description'   => ':description',
  'stage_id'      => ':stage_id',
  'priority'      => ':priority',
  'secret_level'  => ':secret_level',
  'due_date'      => ':due_date',
  'department_id' => ':department_id',
  'assigned_to'   => ':assigned_to',
];

// أضف أعمدة اختيارية لو موجودة فعلاً
if (hasCol($conn, 'tasks', 'project_id'))    $cols['project_id']    = ':project_id';
if (hasCol($conn, 'tasks', 'task_type_id'))  $cols['task_type_id']  = ':task_type_id';
if (hasCol($conn, 'tasks', 'updated_at'))    $cols['updated_at']    = 'NOW()';

// completed_at نحطه فقط إذا المرحلة خضراء والعمود موجود
$setCompletedNow = ($newStageColor === '#10b981') && hasCol($conn, 'tasks', 'completed_at');
if ($setCompletedNow) $cols['completed_at'] = ':completed_at';

// بني جملة UPDATE ديناميكياً
$setParts = [];
foreach ($cols as $k => $v) { $setParts[] = "$k = $v"; }
$sql = "UPDATE tasks SET " . implode(', ', $setParts) . " WHERE id = :id";
$stmt = $conn->prepare($sql);

// حضّر الباراميترات
$params = [
  ':title'         => $title,
  ':description'   => $description,
  ':stage_id'      => $stage_id,
  ':priority'      => $priority,
  ':secret_level'  => $secret_level,
  ':due_date'      => $due_date,
  ':department_id' => $department_id,
  ':assigned_to'   => $assigned_to,
  ':id'            => $id,
];

// ضف الاختيارية إذا موجودة
if (isset($cols['project_id']))    $params[':project_id']   = ($project_id === '' ? null : $project_id);
if (isset($cols['task_type_id']))  $params[':task_type_id'] = ($task_type_id === '' ? null : $task_type_id);
if ($setCompletedNow)              $params[':completed_at'] = date('Y-m-d H:i:s');

$stmt->execute($params);

// بعد التحميل، نظّف أي مخرجات سابقة (لو فيه echo/BOM)
if (ob_get_length()) { ob_clean(); }

// دالة إرجاع JSON وإنهاء الطلب بشكل نظيف
function json_end($arr) {
  // تأكد ما فيه أي شيء بالبفر
  if (ob_get_length()) { ob_clean(); }
  echo json_encode($arr, JSON_UNESCAPED_UNICODE);
  // نزّل الرد للعميل فورًا
  if (function_exists('fastcgi_finish_request')) { fastcgi_finish_request(); }
  exit;
}

function logTaskAction(PDO $conn, $task_id, $user_id, $action_type, $action_details) {
  $stmt = $conn->prepare("INSERT INTO task_logs (task_id, user_id, action_type, action_details) VALUES (?, ?, ?, ?)");
  $stmt->execute([$task_id, $user_id, $action_type, $action_details]);
}

// ====== تحقّق نوع الطلب ======
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  json_end(['success' => false, 'message' => 'طريقة الطلب غير صحيحة']);
}

// ====== استقبال القيم وتنظيفها ======
$id            = $_POST['id'] ?? null;
$title         = trim($_POST['title'] ?? '');
$description   = trim($_POST['description'] ?? '');
$stage_id      = $_POST['stage_id'] ?? null;
$priority      = $_POST['priority'] ?? 'medium';
$secret_level  = $_POST['secret_level'] ?? 'normal';
$due_date      = $_POST['due_date'] ?? null;
$department_id = $_POST['department_id'] ?? null;
$assigned_to   = $_POST['assigned_to'] ?? null;
$custom_fields = $_POST['custom_fields'] ?? [];
$project_id    = $_POST['project_id'] ?? null;
$task_type_id  = $_POST['task_type_id'] ?? null;

// طبع القيم الفارغة إلى null
if ($due_date === '')      $due_date = null;
$stage_id      = ($stage_id === ''      ? null : $stage_id);
$department_id = ($department_id === '' ? null : $department_id);
$assigned_to   = ($assigned_to === ''   ? null : $assigned_to);
$project_id    = ($project_id === ''    ? null : $project_id);
$task_type_id  = ($task_type_id === ''  ? null : $task_type_id);

// تحقّق أساسي
if (!$id || $title === '') {
  json_end(['success' => false, 'message' => 'بيانات غير كافية']);
}

// ====== جلب المهمة القديمة ======
$oldStmt = $conn->prepare("SELECT * FROM tasks WHERE id = ?");
$oldStmt->execute([$id]);
$oldTask = $oldStmt->fetch(PDO::FETCH_ASSOC);
if (!$oldTask) {
  json_end(['success' => false, 'message' => 'المهمة غير موجودة']);
}

// ====== لون المرحلة الجديدة (بأمان) ======
$newStageColor = null;
if (!is_null($stage_id) && ctype_digit((string)$stage_id)) {
  $stageStmt = $conn->prepare("SELECT color FROM stages WHERE id = ?");
  $stageStmt->execute([$stage_id]);
  $c = $stageStmt->fetchColumn();
  if (is_string($c)) $newStageColor = strtolower(trim($c));
}

// إذا خضراء خلّ completed_at الآن، غير كذا خلّ القديم كما هو
$setCompletedNow = ($newStageColor === '#10b981');

// ====== بناء وتفيذ التحديث ======
$sql = "UPDATE tasks SET
          title = :title,
          description = :description,
          stage_id = :stage_id,
          priority = :priority,
          secret_level = :secret_level,
          due_date = :due_date,
          department_id = :department_id,
          assigned_to = :assigned_to,
          project_id = :project_id,
          task_type_id = :task_type_id,
          updated_at = NOW()";

if ($setCompletedNow) {
  $sql .= ", completed_at = :completed_at";
}
// ملاحظة: إذا تبي تصفّر completed_at عند الخروج من الأخضر، أضف else يعيّنها NULL.

$sql .= " WHERE id = :id";

$stmt = $conn->prepare($sql);
$params = [
  ':title'         => $title,
  ':description'   => $description,
  ':stage_id'      => $stage_id,
  ':priority'      => $priority,
  ':secret_level'  => $secret_level,
  ':due_date'      => $due_date,
  ':department_id' => $department_id,
  ':assigned_to'   => $assigned_to,
  ':project_id'    => $project_id,
  ':task_type_id'  => $task_type_id,
  ':id'            => $id
];
if ($setCompletedNow) {
  $params[':completed_at'] = date('Y-m-d H:i:s');
}

try {
  $success = $stmt->execute($params);
} catch (Throwable $e) {
  json_end(['success' => false, 'message' => 'خطأ SQL أثناء التحديث', 'error' => $e->getMessage()]);
}

if (!$success) {
  json_end(['success' => false, 'message' => 'فشل في تحديث المهمة']);
}

// ====== تسجيل السجلّات ======
$user_id = $_SESSION['user']['id'] ?? null;
if ($user_id) {
  // قواميس أسماء
  $stageNames = array_column($conn->query("SELECT id,name FROM stages")->fetchAll(PDO::FETCH_ASSOC), 'name', 'id');
  $deptNames  = array_column($conn->query("SELECT id,name FROM departments")->fetchAll(PDO::FETCH_ASSOC), 'name', 'id');
  $userNames  = array_column($conn->query("SELECT id,name FROM users")->fetchAll(PDO::FETCH_ASSOC), 'name', 'id');
  $projNames  = array_column($conn->query("SELECT id,name FROM projects")->fetchAll(PDO::FETCH_ASSOC), 'name', 'id');
  $typeNames  = array_column($conn->query("SELECT id,name FROM task_types")->fetchAll(PDO::FETCH_ASSOC), 'name', 'id');

  if ($oldTask['title'] !== $title)              logTaskAction($conn, $id, $user_id, 'تعديل العنوان',   "من \"{$oldTask['title']}\" إلى \"$title\"");
  if ($oldTask['description'] !== $description)  logTaskAction($conn, $id, $user_id, 'تعديل الوصف',     "تم تعديل وصف المهمة");
  if ($oldTask['stage_id'] != $stage_id) {
    $old = $stageNames[$oldTask['stage_id']] ?? 'غير معروفة';
    $new = $stageNames[$stage_id] ?? 'غير معروفة';
    logTaskAction($conn, $id, $user_id, 'نقل المهمة', "من '$old' إلى '$new'");
  }
  if ($oldTask['priority'] !== $priority)        logTaskAction($conn, $id, $user_id, 'تعديل الأولوية',  "من \"{$oldTask['priority']}\" إلى \"$priority\"");
  if ($oldTask['secret_level'] !== $secret_level)logTaskAction($conn, $id, $user_id, 'تعديل السرية',    "من \"{$oldTask['secret_level']}\" إلى \"$secret_level\"");
  if (($oldTask['due_date'] ?? '') !== ($due_date ?? ''))
                                                 logTaskAction($conn, $id, $user_id, 'تعديل التاريخ',   "من \"{$oldTask['due_date']}\" إلى \"$due_date\"");
  if ($oldTask['assigned_to'] != $assigned_to) {
    $old = $userNames[$oldTask['assigned_to']] ?? 'غير معروف';
    $new = $userNames[$assigned_to] ?? 'غير معروف';
    logTaskAction($conn, $id, $user_id, 'تغيير المسؤول', "من '$old' إلى '$new'");
  }
  if ($oldTask['department_id'] != $department_id) {
    $old = $deptNames[$oldTask['department_id']] ?? 'غير معروفة';
    $new = $deptNames[$department_id] ?? 'غير معروفة';
    logTaskAction($conn, $id, $user_id, 'نقل الإدارة', "من '$old' إلى '$new'");
  }
  if ($oldTask['project_id'] != $project_id) {
    $old = $projNames[$oldTask['project_id']] ?? 'بدون';
    $new = $projNames[$project_id] ?? 'بدون';
    logTaskAction($conn, $id, $user_id, 'تغيير المشروع', "من '$old' إلى '$new'");
  }
  if ($oldTask['task_type_id'] != $task_type_id) {
    $old = $typeNames[$oldTask['task_type_id']] ?? 'بدون';
    $new = $typeNames[$task_type_id] ?? 'بدون';
    logTaskAction($conn, $id, $user_id, 'تغيير التصنيف', "من '$old' إلى '$new'");
  }
}

// ====== تحديث/إضافة الحقول المخصّصة ======
foreach ($custom_fields as $field_id => $value) {
  $check = $conn->prepare("SELECT id, value FROM task_custom_values WHERE task_id = ? AND field_id = ?");
  $check->execute([$id, $field_id]);
  $existing = $check->fetch(PDO::FETCH_ASSOC);

  if ($existing) {
    if ($existing['value'] !== $value) {
      $u = $conn->prepare("UPDATE task_custom_values SET value = ? WHERE id = ?");
      $u->execute([$value, $existing['id']]);
      if (!empty($user_id)) {
        logTaskAction($conn, $id, $user_id, 'تعديل حقل إضافي', "تغيير حقل ID: $field_id من '{$existing['value']}' إلى '$value'");
      }
    }
  } else {
    $i = $conn->prepare("INSERT INTO task_custom_values (task_id, field_id, value) VALUES (?, ?, ?)");
    $i->execute([$id, $field_id, $value]);
    if (!empty($user_id)) {
      logTaskAction($conn, $id, $user_id, 'إضافة حقل إضافي', "إضافة حقل ID: $field_id بالقيمة: '$value'");
    }
  }
}

// ====== رجّع JSON بشكل نظيف ======
json_end(['success' => true, 'message' => 'تم تحديث المهمة بنجاح']);

// ====== أي شيء تحت هنا ما يأثر على الرد ======
// Webhook للنظام الآلي (اختياري)
try {
  $stmt = $conn->prepare("SELECT id, title, description, stage_id, department_id FROM tasks WHERE id = ?");
  $stmt->execute([$id]);
  $taskPayload = $stmt->fetch(PDO::FETCH_ASSOC);

  $ctx = stream_context_create([
    'http' => [
      'method'  => 'POST',
      'header'  => "Content-Type: application/json",
      'content' => json_encode($taskPayload, JSON_UNESCAPED_UNICODE),
      'timeout' => 2
    ]
  ]);
  @file_get_contents('https://asraa.app.n8n.cloud/webhook/watch-task-update', false, $ctx);
} catch (Throwable $e) {
  // تجاهل الأخطاء هنا
}
