<?php
session_start();
require_once '../config/db.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  echo json_encode(['success' => false, 'message' => 'طريقة الطلب غير صحيحة']);
  exit;
}

$task_id = $_POST['task_id'] ?? null;
$stage_id = $_POST['stage_id'] ?? null;
$user_id = $_SESSION['user']['id'] ?? null;

if (!$task_id || !$stage_id || !$user_id) {
  echo json_encode(['success' => false, 'message' => 'بيانات ناقصة']);
  exit;
}

// جلب تفاصيل المرحلة (مع اللون)
$stage_stmt = $conn->prepare("SELECT id, name, is_shared, department_id, shared_department_id, color FROM stages WHERE id = ?");
$stage_stmt->execute([$stage_id]);
$stage = $stage_stmt->fetch(PDO::FETCH_ASSOC);

if (!$stage) {
  echo json_encode(['success' => false, 'message' => 'المرحلة غير موجودة']);
  exit;
}

$new_department_id = $stage['is_shared'] ? $stage['shared_department_id'] : $stage['department_id'];

// جلب اسم الإدارة
$dept_stmt = $conn->prepare("SELECT name FROM departments WHERE id = ?");
$dept_stmt->execute([$new_department_id]);
$dept = $dept_stmt->fetch(PDO::FETCH_ASSOC);
$department_name = $dept['name'] ?? 'غير معروفة';

// تحديث completed_at إذا المرحلة مكتملة (لونها أخضر)
$completed_at = (strtolower(trim($stage['color'])) === '#10b981') ? date('Y-m-d H:i:s') : null;

// تحديث المهمة
$update_stmt = $conn->prepare("UPDATE tasks SET stage_id = ?, department_id = ?, completed_at = ? WHERE id = ?");
$success = $update_stmt->execute([$stage_id, $new_department_id, $completed_at, $task_id]);

if ($success) {
  // تسجيل في سجل المهام
  $details = "تم نقل المهمة إلى المرحلة: {$stage['name']} (الإدارة: $department_name)";
  $log = $conn->prepare("INSERT INTO task_logs (task_id, user_id, action_type, action_details) VALUES (?, ?, ?, ?)");
  $log->execute([$task_id, $user_id, 'نقل المهمة', $details]);

  echo json_encode(['success' => true]);
} else {
  echo json_encode(['success' => false, 'message' => 'فشل في التحديث']);
}
