<?php
// /erp_task_system/api/user_locations.php
session_start();
require_once '../config/db.php';
header('Content-Type: application/json; charset=utf-8');

if (!isset($_SESSION['user'])) { echo json_encode(['ok'=>false,'msg'=>'login']); exit; }
$me   = $_SESSION['user'];
$role = $me['role'] ?? 'user';

$action  = $_REQUEST['action'] ?? 'list';
$user_id = intval($_REQUEST['user_id'] ?? 0);
if (!$user_id) { echo json_encode(['ok'=>false,'msg'=>'user_id']); exit; }

// صلاحيات
$canEditAll = in_array($role, ['admin','manager']);
if (!$canEditAll && $user_id !== intval($me['id'])) {
  echo json_encode(['ok'=>false,'msg'=>'forbidden']); exit;
}

try {
  if ($action === 'list') {
    // رجّع كل المواقع مع فلاغ مخصص
    $sql = "SELECT l.id, l.name, IF(ul.user_id IS NULL, 0, 1) AS assigned
            FROM locations l
            LEFT JOIN user_locations ul ON ul.location_id=l.id AND ul.user_id=?
            ORDER BY l.name";
    $stmt = $conn->prepare($sql);
    $stmt->execute([$user_id]);
    echo json_encode(['ok'=>true,'data'=>$stmt->fetchAll(PDO::FETCH_ASSOC)]); exit;
  }

  if ($action === 'save') {
    $ids = $_POST['locations'] ?? [];
    if (!is_array($ids)) $ids = [];

    $conn->beginTransaction();
    $conn->prepare("DELETE FROM user_locations WHERE user_id=?")->execute([$user_id]);
    if ($ids) {
      $ins = $conn->prepare("INSERT INTO user_locations (user_id, location_id) VALUES (?,?)");
      foreach ($ids as $loc) { $ins->execute([$user_id, intval($loc)]); }
    }
    $conn->commit();
    echo json_encode(['ok'=>true]); exit;
  }

  echo json_encode(['ok'=>false,'msg'=>'bad_action']);
} catch (Throwable $e) {
  if ($conn->inTransaction()) $conn->rollBack();
  echo json_encode(['ok'=>false,'msg'=>'error','err'=>$e->getMessage()]);
}