<?php
// /erp_task_system/api/user_qualifications.php
session_start();
require_once '../config/db.php';
header('Content-Type: application/json; charset=utf-8');

if (!isset($_SESSION['user'])) { echo json_encode(['ok'=>false,'msg'=>'login']); exit; }
$me   = $_SESSION['user'];
$role = $me['role'] ?? 'user';

$action  = $_REQUEST['action'] ?? 'list';
$user_id = intval($_REQUEST['user_id'] ?? 0);
if (!$user_id) { echo json_encode(['ok'=>false,'msg'=>'user_id']); exit; }

// صلاحيات
$canEditAll = in_array($role, ['admin','manager']);
if (!$canEditAll && $user_id !== intval($me['id'])) {
  echo json_encode(['ok'=>false,'msg'=>'forbidden']); exit;
}

$UPLOAD_DIR = realpath(__DIR__ . '/../uploads') . '/qualifications/';
$PUBLIC_URL = '/erp_task_system/uploads/qualifications/';

if (!is_dir($UPLOAD_DIR)) { @mkdir($UPLOAD_DIR, 0777, true); }

try {
  if ($action === 'list') {
    $stmt = $conn->prepare("SELECT * FROM user_qualifications WHERE user_id=? ORDER BY id DESC");
    $stmt->execute([$user_id]);
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    // أضف رابط عام للملف
    foreach ($rows as &$r) {
      $r['file_url'] = $r['attachment_path'] ? $PUBLIC_URL . $r['attachment_path'] : null;
    }
    echo json_encode(['ok'=>true,'data'=>$rows]); exit;
  }

  if ($action === 'save') {
    $id       = intval($_POST['id'] ?? 0);
    $degree   = trim($_POST['degree'] ?? '');
    $major    = trim($_POST['major'] ?? '');
    $inst     = trim($_POST['institution'] ?? '');
    $country  = trim($_POST['country'] ?? '');
    $grad_dt  = trim($_POST['graduation_date'] ?? '');
    $grade    = trim($_POST['grade'] ?? '');

    if ($degree===''){ echo json_encode(['ok'=>false,'msg'=>'degree']); exit; }

    // معالجة الملف (اختياري)
    $newFile = null;
    if (!empty($_FILES['file']['name']) && $_FILES['file']['error'] === 0) {
      $ext = strtolower(pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION));
      $allowed = ['pdf','jpg','jpeg','png','doc','docx'];
      if (!in_array($ext, $allowed)) { echo json_encode(['ok'=>false,'msg'=>'bad_ext']); exit; }
      $newFile = uniqid('qual_').'.'.$ext;
      if (!move_uploaded_file($_FILES['file']['tmp_name'], $UPLOAD_DIR.$newFile)) {
        echo json_encode(['ok'=>false,'msg'=>'upload_fail']); exit;
      }
    }

    if ($id>0) {
      if ($newFile){
        // احذف القديم إن وجد
        $old = $conn->prepare("SELECT attachment_path FROM user_qualifications WHERE id=? AND user_id=?");
        $old->execute([$id,$user_id]); $o=$old->fetch(PDO::FETCH_ASSOC);
        if ($o && !empty($o['attachment_path'])) @unlink($UPLOAD_DIR.$o['attachment_path']);
      }
      $sql = "UPDATE user_qualifications
              SET degree=?, major=?, institution=?, country=?, graduation_date=?, grade=?, attachment_path=COALESCE(?, attachment_path)
              WHERE id=? AND user_id=?";
      $conn->prepare($sql)->execute([$degree,$major,$inst,$country,$grad_dt?:NULL,$grade?:NULL,$newFile,$id,$user_id]);
    } else {
      $sql = "INSERT INTO user_qualifications (user_id, degree, major, institution, country, graduation_date, grade, attachment_path)
              VALUES (?,?,?,?,?,?,?,?)";
      $conn->prepare($sql)->execute([$user_id,$degree,$major,$inst,$country,$grad_dt?:NULL,$grade?:NULL,$newFile]);
      $id = $conn->lastInsertId();
    }
    echo json_encode(['ok'=>true,'id'=>$id]); exit;
  }

  if ($action === 'delete') {
    $id = intval($_POST['id'] ?? 0);
    if (!$id) { echo json_encode(['ok'=>false,'msg'=>'id']); exit; }
    // احذف الملف
    $old = $conn->prepare("SELECT attachment_path FROM user_qualifications WHERE id=? AND user_id=?");
    $old->execute([$id,$user_id]); $o=$old->fetch(PDO::FETCH_ASSOC);
    if ($o && !empty($o['attachment_path'])) @unlink($UPLOAD_DIR.$o['attachment_path']);

    $conn->prepare("DELETE FROM user_qualifications WHERE id=? AND user_id=?")->execute([$id,$user_id]);
    echo json_encode(['ok'=>true]); exit;
  }

  echo json_encode(['ok'=>false,'msg'=>'bad_action']);
} catch (Throwable $e) {
  echo json_encode(['ok'=>false,'msg'=>'error','err'=>$e->getMessage()]);
}
